/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.polarsys.kitalpha.resourcereuse.Messages;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceHelper;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceNotFoundException;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;
import org.polarsys.kitalpha.resourcereuse.utils.Assert;
import org.polarsys.kitalpha.resourcereuse.utils.Matcher;

public abstract class ResourceRegistry
implements ResourceHelper {
    private final ResourceRegistry parent;
    protected final Map<String, Resource> id2resource = new HashMap<String, Resource>();
    protected final Map<String, Set<String>> user2concern = new HashMap<String, Set<String>>();
    protected final Map<String, Set<String>> used2concern = new HashMap<String, Set<String>>();

    public ResourceRegistry(ResourceRegistry parent) {
        this.parent = parent;
    }

    public boolean containsResource(String id) {
        return this.id2resource.containsKey(id);
    }

    protected void addResource(Resource resource) {
        this.id2resource.put(resource.getId(), resource);
    }

    protected void addConcern(String concernName, String user, String used) {
        Set<String> concerns = this.user2concern.get(user);
        if (concerns == null) {
            concerns = new HashSet<String>();
            this.user2concern.put(user, concerns);
        }
        concerns.add(concernName);
        concerns = this.used2concern.get(used);
        if (concerns == null) {
            concerns = new HashSet<String>();
            this.used2concern.put(used, concerns);
        }
        concerns.add(concernName);
    }

    @Override
    public Resource getResource(String id) throws ResourceNotFoundException {
        Assert.notNullnotEmpty(id);
        Resource resource = this.id2resource.get(id);
        if (resource == null) {
            if (this.parent == null) {
                throw new ResourceNotFoundException(Messages.bind((String)Messages.ResourceId_Not_Found, (Object)id));
            }
            return this.parent.getResource(id);
        }
        return resource;
    }

    @Override
    public Resource[] getResources(SearchCriteria criteria) {
        Assert.usable(criteria);
        ArrayList<Resource> result = new ArrayList<Resource>();
        Matcher matcher = new Matcher(criteria);
        this.applyCriteria(result, matcher);
        Collections.sort(result, new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                return o2.getWeight() - o1.getWeight();
            }
        });
        return result.toArray(new Resource[result.size()]);
    }

    protected void applyCriteria(List<Resource> result, Matcher matcher) {
        for (Map.Entry<String, Resource> entry : this.id2resource.entrySet()) {
            Resource resource = entry.getValue();
            Set<String> usedConcerns = this.used2concern.get(resource.getId());
            Set<String> userConcerns = this.user2concern.get(resource.getId());
            if (!matcher.matchResource(resource) || !matcher.matchConcerns(usedConcerns, userConcerns)) continue;
            result.add(resource);
        }
        if (this.parent != null) {
            this.parent.applyCriteria(result, matcher);
        }
    }

    @Override
    public void dispose() {
        if (this.parent != null) {
            this.parent.dispose();
        }
        this.id2resource.clear();
        this.used2concern.clear();
        this.user2concern.clear();
    }
}

