/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.extension.registry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.osgi.util.NLS;
import org.polarsys.kitalpha.emde.extension.i18n.Messages;
import org.polarsys.kitalpha.emde.extension.registry.RegistryProvider;
import org.polarsys.kitalpha.emde.extension.registry.URIFactory;
import org.polarsys.kitalpha.emde.extension.utils.Log;

public class ItemProviderAdapterFactoriesRegistryProvider
extends RegistryProvider {
    private static ItemProviderAdapterFactoriesRegistryProvider registryReader;
    public static final String EXTENSION_POINT = "itemProviderAdapterFactories";
    public static final String TAG = "factory";
    public static final String ATT_URI = "uri";
    public static final String ATT_CLASS = "class";
    public static final String ATT_SUPPORTED_TYPES = "supportedTypes";
    private final Map<String, URIFactory> URIFactories = new HashMap<String, URIFactory>();

    private ItemProviderAdapterFactoriesRegistryProvider() {
        super(EMFEditPlugin.INSTANCE.getSymbolicName(), EXTENSION_POINT);
        this.loadRegistry();
    }

    public static String getName() {
        return String.valueOf(EMFEditPlugin.INSTANCE.getSymbolicName()) + "-" + EXTENSION_POINT;
    }

    public static ItemProviderAdapterFactoriesRegistryProvider getURIsReader() {
        if (registryReader == null) {
            registryReader = new ItemProviderAdapterFactoriesRegistryProvider();
        }
        return registryReader;
    }

    private void loadRegistry() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        this.readRegistry(extensionRegistry);
    }

    @Override
    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG)) {
            this.readTagAttributeElement(element);
            return true;
        }
        return false;
    }

    private void readTagAttributeElement(IConfigurationElement element) {
        String uri = element.getAttribute(ATT_URI);
        String clazz = element.getAttribute(ATT_CLASS);
        String supportedTypes = element.getAttribute(ATT_SUPPORTED_TYPES);
        if (uri == null || uri.trim().length() == 0 || clazz == null || clazz.trim().length() == 0 || supportedTypes == null || supportedTypes.trim().length() == 0) {
            return;
        }
        uri = uri.trim();
        clazz = clazz.trim();
        supportedTypes = supportedTypes.trim();
        boolean found = false;
        StringTokenizer stringTokenizer = new StringTokenizer(supportedTypes);
        while (stringTokenizer.hasMoreTokens()) {
            if (!IEditingDomainItemProvider.class.getName().equals(stringTokenizer.nextToken())) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        URIFactory factory = this.URIFactories.get(uri);
        if (factory != null) {
            String msg = NLS.bind((String)Messages.ImplementationRegistryProvider_invalidKey, (Object[])new String[]{uri, element.getDeclaringExtension().getNamespaceIdentifier(), factory.getIConfigurationElement().getDeclaringExtension().getNamespaceIdentifier()});
            Log.getDefault().logWarning(msg);
            return;
        }
        this.URIFactories.put(uri, new URIFactory(uri, clazz, element));
    }

    protected Map<String, URIFactory> getURIFactories() {
        return this.URIFactories;
    }

    public static Map<String, URIFactory> getItemProviderAdapterFactories() {
        return ItemProviderAdapterFactoriesRegistryProvider.getURIsReader().getURIFactories();
    }

    public static URIFactory getURIFactoryFromNsURI(String uri) {
        if (uri == null || uri.trim().length() == 0) {
            return null;
        }
        return ItemProviderAdapterFactoriesRegistryProvider.getURIsReader().getURIFactories().get(uri.trim());
    }

    public static URIFactory getURIFactoryFromAdapterFactoryName(String clazz) {
        if (clazz == null || clazz.trim().length() == 0) {
            return null;
        }
        clazz = clazz.trim();
        for (URIFactory factory : ItemProviderAdapterFactoriesRegistryProvider.getURIsReader().getURIFactories().values()) {
            if (!clazz.equals(factory.getAdapterFactoryName())) continue;
            return factory;
        }
        return null;
    }

    @Override
    protected void addExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.readTagAttributeElement(element);
            ++n2;
        }
    }

    @Override
    protected void removeExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Iterator<Map.Entry<String, URIFactory>> it = ItemProviderAdapterFactoriesRegistryProvider.getURIsReader().getURIFactories().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, URIFactory> entry = it.next();
                if (entry.getValue().getIConfigurationElement() != element) continue;
                it.remove();
                break;
            }
            ++n2;
        }
    }
}

