/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ModelListener;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ModelManager;
import org.polarsys.kitalpha.ad.viewpoint.ui.AFImages;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;
import org.polarsys.kitalpha.ad.viewpoint.ui.provider.AFSelectionProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.BasicEditingSupport;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.AFLabelProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.Tab;

public abstract class AbstractTab
implements Tab,
ModelListener,
AFImages {
    protected Viewpoint viewpoint;
    private boolean designOnly;
    protected ModelManager modelManager;
    private final List<BasicEditingSupport> editingSupports = new ArrayList<BasicEditingSupport>();
    protected IViewSite site;
    protected final AFLabelProvider labelProvider;
    private CTabItem item;
    protected AFSelectionProvider selectionProvider;

    protected AbstractTab(AFLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public void setSite(IViewSite site) {
        this.site = site;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    @Override
    public void setModelManager(Viewpoint vp, ModelManager modelManager) {
        if (this.modelManager != null) {
            this.modelManager.removeListener((ModelListener)this);
        }
        if (modelManager != null) {
            modelManager.addListener((ModelListener)this);
        }
        this.modelManager = modelManager;
        this.viewpoint = vp;
        for (BasicEditingSupport bes : this.editingSupports) {
            bes.setModelManager(modelManager);
        }
        this.configureLabelProvider();
    }

    @Override
    public void setSelectionProvider(AFSelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    protected Composite createTab(FormToolkit toolkit, CTabFolder folder, String label, String image) {
        return this.createTab(toolkit, folder, label, Activator.getDefault().getImage(image));
    }

    protected Composite createTab(FormToolkit toolkit, CTabFolder folder, String label, Object url) {
        Image image = ExtendedImageRegistry.getInstance().getImage(url);
        return this.createTab(toolkit, folder, label, image);
    }

    protected Composite createTab(FormToolkit toolkit, CTabFolder folder, String label, Image image) {
        this.item = new CTabItem(folder, 0);
        this.item.setText(label);
        this.item.setImage(image);
        ScrolledForm scrolledForm = toolkit.createScrolledForm((Composite)folder);
        scrolledForm.setExpandHorizontal(true);
        scrolledForm.setExpandVertical(true);
        Composite composite = scrolledForm.getBody();
        this.item.setControl((Control)scrolledForm);
        return composite;
    }

    @Override
    public void dispose() {
        this.setModelManager(this.viewpoint, null);
        if (this.item != null && !this.item.isDisposed()) {
            this.item.dispose();
        }
    }

    protected BasicEditingSupport register(BasicEditingSupport support) {
        this.editingSupports.add(support);
        return support;
    }

    public void workspaceHasChanged() {
        this.configureLabelProvider();
    }

    private void configureLabelProvider() {
        Object ref = this.modelManager == null ? null : this.modelManager.getResourceManager().getRootModel();
        this.labelProvider.setReference(this.viewpoint, ref);
    }

    @Override
    public void setDesignOnly(boolean b) {
        this.designOnly = b;
    }

    @Override
    public boolean isDesignOnly() {
        return this.designOnly;
    }

    protected void displayError(String message) {
        this.site.getActionBars().getStatusLineManager().setErrorMessage(message);
    }

    protected class FocusListener2
    implements FocusListener {
        protected FocusListener2() {
        }

        public void doFocusLost(FocusEvent e) {
        }

        public final void focusLost(FocusEvent e) {
            AbstractTab.this.displayError(null);
            try {
                this.doFocusLost(e);
            }
            catch (Exception e1) {
                AbstractTab.this.displayError(e1.getMessage());
            }
        }

        public void focusGained(FocusEvent e) {
        }
    }

    protected abstract class SelectionListener2
    implements SelectionListener {
        protected SelectionListener2() {
        }

        public final void widgetDefaultSelected(SelectionEvent e) {
        }

        public final void widgetSelected(SelectionEvent e) {
            AbstractTab.this.displayError(null);
            try {
                this.doWidgetSelected(e);
            }
            catch (Exception ee) {
                AbstractTab.this.displayError(ee.getMessage());
            }
        }

        protected abstract void doWidgetSelected(SelectionEvent var1) throws Exception;
    }
}

