/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.validation.java.provider.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.validation.AccuracyPlugin;
import org.polarsys.kitalpha.validation.java.provider.generic.GenericJavaConstraintProvider;
import org.polarsys.kitalpha.validation.java.provider.generic.IJavaConstraint;
import org.polarsys.kitalpha.validation.java.provider.generic.JavaConstraintDescriptor;
import org.polarsys.kitalpha.validation.java.provider.generic.JavaConstraintExtension;
import org.polarsys.kitalpha.validation.provider.generic.GenericConstraintFactory;

public class GenericJavaConstraintFactory
extends GenericConstraintFactory {
    private static final String REQUIREMENT_ID = "requirementId";
    private static final String INVARIANT_ID = "invariantId";
    private Category commonCategory;
    private Category mandatoryCategory;
    private String commonCategoryName;
    private Bundle contributorPluginBundle;
    private List<JavaConstraintDescriptor> createdConstraints = new LinkedList<JavaConstraintDescriptor>();

    public GenericJavaConstraintFactory(GenericJavaConstraintProvider provider) {
        super(provider);
        this.contributorPluginBundle = provider.getContributorBundle();
        this.commonCategoryName = this.getCommonConstraintCategory();
        this.commonCategory = CategoryManager.getInstance().getCategory(this.commonCategoryName);
    }

    private Category getMandatoryCategory() {
        if (this.mandatoryCategory == null) {
            this.mandatoryCategory = CategoryManager.getInstance().getCategory(String.valueOf(this.commonCategoryName) + "/mandatory");
            this.mandatoryCategory.setMandatory(true);
        }
        return this.mandatoryCategory;
    }

    @Override
    public List<AbstractConstraintDescriptor> createConstraints() {
        this.createdConstraints.clear();
        Collection<IConfigurationElement> constraints = JavaConstraintExtension.getConstraintsFromContributor(this.contributorPluginBundle.getSymbolicName());
        for (IConfigurationElement currentConstraint : constraints) {
            this.createConstraintsFromConfigurationElement(currentConstraint);
        }
        return new ArrayList<AbstractConstraintDescriptor>(this.createdConstraints);
    }

    private void createConstraintsFromConfigurationElement(IConfigurationElement currentConstraint) {
        List<String> mandatoryRequirements = this.getMandatoryRequirements();
        IConfigurationElement[] iConfigurationElementArray = currentConstraint.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            this.createConstraintFromJavaConstraint(child, mandatoryRequirements);
            ++n2;
        }
    }

    private void createConstraintFromJavaConstraint(IConfigurationElement javaConstraint, List<String> mandatoryRequirements) {
        try {
            IJavaConstraint executableInstance = (IJavaConstraint)javaConstraint.createExecutableExtension("Class");
            String requirementId = javaConstraint.getAttribute(REQUIREMENT_ID);
            String invariantId = javaConstraint.getAttribute(INVARIANT_ID);
            String message = this.getMessage(requirementId, invariantId);
            ConstraintSeverity severity = this.toConstraintSeverity(this.getSeverity(requirementId, invariantId));
            String name = this.getName(requirementId, invariantId);
            String codeStr = this.getCode(requirementId, invariantId);
            int code = this.toIntegerCode(codeStr);
            JavaConstraintDescriptor descriptor = new JavaConstraintDescriptor(this.contributorPluginBundle.getSymbolicName(), requirementId, invariantId, message, message, name, severity, executableInstance, code);
            List<String> constraintCategories = this.getConstraintCategories(requirementId, invariantId);
            this.associateConstaintToCategory(descriptor, this.commonCategory);
            this.associateConstraintToCategories(descriptor, constraintCategories);
            if (mandatoryRequirements.contains(requirementId)) {
                this.associateConstaintToCategory(descriptor, this.getMandatoryCategory());
            }
            this.createdConstraints.add(descriptor);
        }
        catch (CoreException e) {
            AccuracyPlugin.getDefault().getLog().log(e.getStatus());
        }
    }
}

