/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.wizards;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.polarsys.kitalpha.composer.api.Parameter;
import org.polarsys.kitalpha.composer.api.configuration.CodeManagerConfiguration;

public class GenericConfigurationWizardPage
extends WizardPage {
    private CodeManagerConfiguration configuration;
    private static Text configNameText;

    public static final String getConfigNameName() {
        return configNameText.getText();
    }

    protected GenericConfigurationWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void setConfiguration(CodeManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    public void createControl(Composite parent) {
        GridData groupData;
        Composite composite = new Composite(parent, 0);
        GridData compositeData = new GridData(1808);
        composite.setLayoutData((Object)compositeData);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createConfigNameComposite(composite);
        this.createDestinationFolderComposite(composite);
        if (this.configuration.getStrategyParameters() != null && !this.configuration.getStrategyParameters().isEmpty()) {
            Group strategyParametersGroup = new Group(composite, 4);
            strategyParametersGroup.setLayout((Layout)new GridLayout(2, false));
            groupData = new GridData(768);
            strategyParametersGroup.setLayoutData((Object)groupData);
            strategyParametersGroup.setText("Strategy parameters");
            this.createParametersComposite((Composite)strategyParametersGroup, this.configuration.getStrategyParameters());
        }
        if (this.configuration.getRefineryParameters() != null && !this.configuration.getRefineryParameters().isEmpty()) {
            Group refineryParametersGroup = new Group(composite, 4);
            refineryParametersGroup.setLayout((Layout)new GridLayout(2, false));
            groupData = new GridData(768);
            refineryParametersGroup.setLayoutData((Object)groupData);
            refineryParametersGroup.setText("Refinery parameters");
            this.createParametersComposite((Composite)refineryParametersGroup, this.configuration.getRefineryParameters());
        }
        if (this.configuration.getGeneratorParameters() != null && !this.configuration.getGeneratorParameters().isEmpty()) {
            Group generatorParametersGroup = new Group(composite, 4);
            generatorParametersGroup.setLayout((Layout)new GridLayout(2, false));
            groupData = new GridData(768);
            generatorParametersGroup.setLayoutData((Object)groupData);
            generatorParametersGroup.setText("Generator parameters");
            this.createParametersComposite((Composite)generatorParametersGroup, this.configuration.getGeneratorParameters());
        }
        this.setControl((Control)composite);
        composite.pack();
    }

    private void createConfigNameComposite(Composite parent) {
        GridData gridData;
        Group destinationFolderGroup = new Group(parent, 4);
        destinationFolderGroup.setLayout((Layout)new GridLayout(3, false));
        GridData groupData = gridData = new GridData(768);
        destinationFolderGroup.setLayoutData((Object)groupData);
        destinationFolderGroup.setText("Configuration Name");
        configNameText = new Text((Composite)destinationFolderGroup, 2048);
        gridData.minimumWidth = 200;
        configNameText.setLayoutData((Object)gridData);
        configNameText.setEditable(true);
    }

    private void createDestinationFolderComposite(Composite parent) {
        GridData gridData;
        Group destinationFolderGroup = new Group(parent, 4);
        destinationFolderGroup.setLayout((Layout)new GridLayout(3, false));
        GridData groupData = gridData = new GridData(768);
        destinationFolderGroup.setLayoutData((Object)groupData);
        destinationFolderGroup.setText("Destination folder");
        Text destinationFolderText = new Text((Composite)destinationFolderGroup, 2048);
        gridData.minimumWidth = 200;
        destinationFolderText.setLayoutData((Object)gridData);
        if (this.configuration.getDestinationFolder() != null) {
            destinationFolderText.setText(this.configuration.getDestinationFolder().toString());
        }
        destinationFolderText.setEditable(true);
        destinationFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                GenericConfigurationWizardPage.this.configuration.setDestinationFolder((IPath)new Path(text.getText()));
            }
        });
        Button browseWorkspace = new Button((Composite)destinationFolderGroup, 8);
        browseWorkspace.setText("Browse Workspace...");
        browseWorkspace.addSelectionListener((SelectionListener)new BrowseWorksapceListener(this.configuration, destinationFolderText));
        Button browseFileSystem = new Button((Composite)destinationFolderGroup, 8);
        browseFileSystem.setText("Browse File System...");
        browseFileSystem.addSelectionListener((SelectionListener)new BrowseFileSystemListener(this.configuration, destinationFolderText));
    }

    private void createParametersComposite(Composite parent, Map<String, Parameter> parameters) {
        for (Map.Entry<String, Parameter> parameter : parameters.entrySet()) {
            Label label = new Label(parent, 16384);
            label.setText(parameter.getValue().getName());
            label.setToolTipText(parameter.getValue().getDescription());
            Text text = new Text(parent, 2048);
            text.setLayoutData((Object)new GridData(768));
            text.setToolTipText(parameter.getValue().getDescription());
            text.setText(parameter.getValue().getValue());
            text.addModifyListener((ModifyListener)new TextListener(text, parameters, parameter.getKey()));
        }
    }

    private static class BrowseFileSystemListener
    extends SelectionAdapter {
        private CodeManagerConfiguration configuration;
        private Text toUpdate;

        public BrowseFileSystemListener(CodeManagerConfiguration configuration, Text text) {
            this.configuration = configuration;
            this.toUpdate = text;
        }

        public void widgetSelected(SelectionEvent e) {
            DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
            String absolutePath = dialog.open();
            if (absolutePath != null) {
                this.toUpdate.setText(absolutePath);
                this.configuration.setDestinationFolder((IPath)new Path(absolutePath));
            }
        }
    }

    private static class BrowseWorksapceListener
    extends SelectionAdapter {
        private CodeManagerConfiguration configuration;
        private Text toUpdate;

        public BrowseWorksapceListener(CodeManagerConfiguration configuration, Text text) {
            this.configuration = configuration;
            this.toUpdate = text;
        }

        public void widgetSelected(SelectionEvent e) {
            Object[] result;
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(Display.getCurrent().getActiveShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
            if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                IPath path = (IPath)result[0];
                this.toUpdate.setText(path.toString());
                this.configuration.setDestinationFolder(path);
            }
        }
    }

    private static class TextListener
    implements ModifyListener {
        private Text text;
        private Map<String, Parameter> map;
        private String key;

        public TextListener(Text text, Map<String, Parameter> map, String key) {
            this.text = text;
            this.map = map;
            this.key = key;
        }

        public void modifyText(ModifyEvent e) {
            this.map.get(this.key).setValue(this.text.getText());
        }
    }
}

