/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.vp.componentsample.wizard.project.wizard;

import java.util.regex.Pattern;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewProjectPage
extends WizardPage {
    private static Pattern pattern = Pattern.compile("[a-zA-Z][a-zA-Z0-9]*");
    private String _projectName = null;
    private String _modelName = null;

    protected NewProjectPage(String pageName) {
        super(pageName);
        this.setDescription("Create a new Component Sample Project");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        container.setLayout((Layout)gridLayout);
        Label projectNameLabel = new Label(container, 0);
        projectNameLabel.setText("Project Name");
        final Text projectName = new Text(container, 2052);
        projectName.setText("");
        Label modelNamelabel = new Label(container, 0);
        modelNamelabel.setText("Model Name");
        final Text modelName = new Text(container, 2052);
        modelName.setText("");
        GridData gd = new GridData(768);
        projectName.setLayoutData((Object)gd);
        modelName.setLayoutData((Object)gd);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object source = e.getSource();
                if (source instanceof Text) {
                    Text text = (Text)source;
                    String name = text.getText();
                    if (NewProjectPage.this.isValid(name)) {
                        NewProjectPage.this.setErrorMessage(null);
                        if (text == projectName) {
                            NewProjectPage.this._projectName = name;
                            modelName.setText(name);
                            NewProjectPage.this._modelName = name;
                        } else {
                            NewProjectPage.this._modelName = name;
                        }
                        NewProjectPage.this.setPageComplete(true);
                    } else {
                        NewProjectPage.this.setErrorMessage("Allowed Characters: [a-zA-Z][a-zA-Z0-9]*");
                        NewProjectPage.this.setPageComplete(false);
                    }
                }
            }
        };
        projectName.addModifyListener(listener);
        modelName.addModifyListener(listener);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private boolean isValid(String name) {
        return name != null && !name.isEmpty() && pattern.matcher(name).matches();
    }

    public String getProjectName() {
        return this._projectName;
    }

    public String getModelName() {
        return this._modelName;
    }
}

