/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.scrutiny.contrib.viewpoints.scrutinizes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.common.utils.URIHelper;
import org.polarsys.kitalpha.ad.integration.sirius.model.SiriusRepresentation;
import org.polarsys.kitalpha.ad.metadata.metadata.Metadata;
import org.polarsys.kitalpha.ad.metadata.metadata.ViewpointReference;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.RepresentationElement;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.Scrutineer;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.modelresources.scrutinize.ModelResourcesScrutinizer;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.viewpoints.scrutinizes.ViewpointRelationshipHelper;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.viewpoints.scrutinizes.ViewpointTreeBuilder;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.ViewpointTreeContainer;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.helpers.FinderAFViewpointHelper;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.helpers.ViewpointsSearcherHelper;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceHelper;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceNotFoundException;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class UsedAFViewpoints
implements IScrutinize<ViewpointTreeContainer, Object> {
    private Set<String> usedNsURI = new HashSet<String>();
    private Set<String> usedViewpoints = new HashSet<String>();
    private ViewpointTreeContainer container;
    private final ResourceHelper resourceReuseHelper = ResourceReuse.createHelper();

    public void findIn(EObject eObject) {
        String ePackageURI = FinderAFViewpointHelper.getEPackageNsURI_of((EObject)eObject);
        if (!this.usedNsURI.contains(ePackageURI)) {
            this.usedNsURI.add(ePackageURI);
        }
    }

    public void findIn(org.eclipse.emf.ecore.resource.Resource resource) {
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Metadata) {
            Metadata root = (Metadata)resource.getContents().get(0);
            for (ViewpointReference uv : root.getViewpointReferences()) {
                try {
                    this.resourceReuseHelper.getResource(uv.getVpId());
                    this.usedViewpoints.add(uv.getVpId());
                }
                catch (ResourceNotFoundException resourceNotFoundException) {}
            }
        }
    }

    public ViewpointTreeContainer getAnalysisResult() {
        if (this.container != null) {
            return this.container;
        }
        this.computeUsedViewpointsHierarchy();
        return this.container;
    }

    private void computeUsedViewpointsHierarchy() {
        Resource[] allVpResources = ViewpointsSearcherHelper.getAllViewpoints();
        Map<String, Collection<String>> viewpointsURIDependencies = ViewpointRelationshipHelper.getUsedRelationship(allVpResources);
        this.usedNsURI = FinderAFViewpointHelper.filterURISet(this.usedNsURI, viewpointsURIDependencies);
        Map filtredVpDependencies = FinderAFViewpointHelper.filterURIMap(viewpointsURIDependencies, this.usedNsURI);
        ViewpointTreeBuilder vpTreeBuilder = new ViewpointTreeBuilder();
        this.container = vpTreeBuilder.getViewpointTreeContainer(filtredVpDependencies, this.usedViewpoints);
    }

    public Object getFeedbackAnalysisMessages() {
        return null;
    }

    public void dispose() {
        this.container.dispose();
        this.container = null;
    }

    public Collection<String> getUsedNsURIs() {
        return new ArrayList<String>(this.usedNsURI);
    }

    @Deprecated
    public static Set<Resource> lookUp(org.eclipse.emf.ecore.resource.Resource resource) {
        return UsedAFViewpoints.lookUp(Collections.singleton(resource));
    }

    public static Set<Resource> lookUp(Collection<org.eclipse.emf.ecore.resource.Resource> resources) {
        HashSet<Resource> result = new HashSet<Resource>();
        ArrayList<org.eclipse.emf.ecore.resource.Resource> resourcesCopyList = new ArrayList<org.eclipse.emf.ecore.resource.Resource>();
        resourcesCopyList.addAll(resources);
        ModelScrutinyRegistry analysis = Scrutineer.startScrutiny(resourcesCopyList);
        HashSet<String> nsUris = new HashSet<String>();
        HashSet<String> odesigns = new HashSet<String>();
        HashSet<String> collectedUsedViewpoints = new HashSet<String>();
        UsedAFViewpoints.collectData(analysis, nsUris, odesigns, collectedUsedViewpoints);
        ResourceSetImpl set = new ResourceSetImpl();
        try {
            Resource[] resourceArray = ViewpointManager.getAvailableViewpoints();
            int n = resourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Resource res = resourceArray[n2];
                try {
                    URI uri = URIHelper.createURI((Resource)res);
                    Viewpoint vp = (Viewpoint)set.getEObject(uri, true);
                    UsedAFViewpoints.lookupViewpointResources(result, nsUris, odesigns, collectedUsedViewpoints, res, vp);
                }
                catch (Exception e) {
                    ViewpointManager.pinError((Resource)res, (Exception)e);
                }
                ++n2;
            }
        }
        finally {
            UsedAFViewpoints.cleanResourceSet((ResourceSet)set);
        }
        return result;
    }

    private static void cleanResourceSet(ResourceSet set) {
        for (org.eclipse.emf.ecore.resource.Resource r : set.getResources()) {
            r.unload();
        }
        set.getResources().clear();
    }

    private static void lookupViewpointResources(Set<Resource> result, Set<String> nsUris, Set<String> odesigns, Set<String> usedViewpoints, Resource res, Viewpoint vp) {
        UsedAFViewpoints.lookupUsedViewpoints(result, usedViewpoints, res, vp);
        UsedAFViewpoints.lookupViewpointEPackages(result, nsUris, res, vp);
        UsedAFViewpoints.lookupViewpointOdesign(result, odesigns, res, vp);
    }

    private static void lookupUsedViewpoints(Set<Resource> result, Set<String> usedViewpoints, Resource res, Viewpoint vp) {
        if (usedViewpoints.contains(vp.getId()) && !result.contains(res)) {
            result.add(res);
        }
    }

    private static void lookupViewpointOdesign(Set<Resource> result, Set<String> odesigns, Resource res, Viewpoint vp) {
        if (vp.getRepresentation() != null && !result.contains(res)) {
            for (RepresentationElement representation : vp.getRepresentation().getRepresentations()) {
                SiriusRepresentation sr;
                URI uri2;
                if (!(representation instanceof SiriusRepresentation) || !odesigns.contains((uri2 = EcoreUtil.getURI((EObject)(sr = (SiriusRepresentation)representation).getOdesign())).lastSegment())) continue;
                result.add(res);
            }
        }
    }

    private static void lookupViewpointEPackages(Set<Resource> result, Set<String> nsUris, Resource res, Viewpoint vp) {
        if (vp.getMetamodel() != null && !result.contains(res)) {
            for (EPackage pack : vp.getMetamodel().getModels()) {
                if (pack.getNsURI() == null || !nsUris.contains(pack.getNsURI())) continue;
                result.add(res);
            }
        }
    }

    private static void collectData(ModelScrutinyRegistry analysis, Set<String> nsUris, Set<String> odesigns, Set<String> collectedUsedViewpoints) {
        try {
            ModelScrutinyRegistry.RegistryElement element = analysis.getRegistryElement("org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownresources.scrutiny");
            for (IScrutinize iFinder : element.getFinders()) {
                if (!(iFinder instanceof ModelResourcesScrutinizer)) continue;
                ModelResourcesScrutinizer resources = (ModelResourcesScrutinizer)iFinder;
                for (URI uri : resources.getAnalysisResult().getAllModelResourceURI()) {
                    if (!"odesign".equals(uri.fileExtension())) continue;
                    odesigns.add(uri.lastSegment());
                }
            }
            ModelScrutinyRegistry.RegistryElement vpElement = analysis.getRegistryElement("org.polarsys.kitalpha.model.common.scrutiny.contrib.scrutiny.viewpoints");
            for (IScrutinize iFinder : vpElement.getFinders()) {
                if (!(iFinder instanceof UsedAFViewpoints)) continue;
                UsedAFViewpoints afFinder = (UsedAFViewpoints)iFinder;
                nsUris.addAll(afFinder.getUsedNsURIs());
                collectedUsedViewpoints.addAll(afFinder.usedViewpoints.stream().collect(Collectors.toList()));
            }
        }
        catch (ModelScrutinyException e) {
            AD_Log.getDefault().logWarning((Throwable)e);
        }
    }
}

