/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.ext;

import org.eclipse.amalgam.explorer.contextual.core.ExplorerActivator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public abstract class AbstractExtensionPointManager {
    public static final String DEFAULT_CLASS_ATTRIBUTE = "class";
    public static final String DEFAULT_NAME_ATTRIBUTE = "name";
    public static final String DEFAULT_ID_ATTRIBUTE = "id";

    public static IConfigurationElement[] getConfigurationElementsFor(String pluginId_p, String extensionPointId_p) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = extensionRegistry.getConfigurationElementsFor(pluginId_p, extensionPointId_p);
        return configElements;
    }

    public static <T> T createTypedInstance(IConfigurationElement configurationElement_p, String attributeName_p, Class<T> type_p) {
        Status status;
        String message;
        T typedInstance = null;
        Object instance = null;
        try {
            instance = configurationElement_p.createExecutableExtension(attributeName_p);
        }
        catch (CoreException e) {
            message = "Unable to create instance of class :";
            message.concat(configurationElement_p.getAttribute(attributeName_p));
            status = new Status(4, "org.eclipse.amalgam.explorer.contextual.core", message, (Throwable)e);
            ExplorerActivator.getDefault().getLog().log((IStatus)status);
        }
        try {
            typedInstance = type_p.cast(instance);
        }
        catch (ClassCastException e) {
            message = "Unable to cast class ";
            message.concat(configurationElement_p.getAttribute(attributeName_p));
            status = new Status(4, "org.eclipse.amalgam.explorer.contextual.core", message, (Throwable)e);
            message.concat(" To ");
            message.concat(type_p.getName());
            ExplorerActivator.getDefault().getLog().log((IStatus)status);
        }
        return typedInstance;
    }

    public static Object createInstance(IConfigurationElement configurationElement_p, String attributeName_p) {
        return AbstractExtensionPointManager.createTypedInstance(configurationElement_p, attributeName_p, Object.class);
    }
}

