/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.api.path;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.composer.api.configuration.CodeManagerConfiguration;
import org.polarsys.kitalpha.composer.api.configuration.ICodeManagerInput;
import org.polarsys.kitalpha.composer.api.path.decoders.ComposerVariablePathDecoder;
import org.polarsys.kitalpha.composer.api.path.decoders.EclipseVariablePathDecoder;
import org.polarsys.kitalpha.composer.api.path.decoders.IVariableDecoder;

public final class ComposerPathUtils {
    private static final String COMPOSER_LINK_PROJECT = ".composer";
    private static final String LINKED_FOLDER_NAME = "link";
    private static final String GENERATED_FOLDER = "/generated";
    private static final IVariableDecoder[] resolvers = new IVariableDecoder[]{new EclipseVariablePathDecoder(), new ComposerVariablePathDecoder()};

    private ComposerPathUtils() {
    }

    public static void recomputePath(CodeManagerConfiguration configuration) throws CoreException {
        String actualPathString;
        ICodeManagerInput input = configuration.getInput();
        IPath actualPath = configuration.getDestinationFolder();
        String string = actualPathString = actualPath == null ? null : actualPath.toString();
        if (input.isMultipleObjectsInput()) {
            List<EObject> inputs = input.getListInput();
            if (!inputs.isEmpty()) {
                configuration.setDestinationFolder(ComposerPathUtils.getPath(inputs.get(0), actualPathString));
            }
        } else if (!input.getRootsInputs().isEmpty()) {
            configuration.setDestinationFolder(ComposerPathUtils.getPath(input.getRootsInputs().get(0), actualPathString));
        }
    }

    public static IPath getPath(Object object, String pathGeneration) throws CoreException {
        String projectPath = "";
        if (object instanceof IResource) {
            IResource res = (IResource)object;
            projectPath = res.getProject().getFullPath().toString();
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            projectPath = "/" + eObject.eResource().getURI().segment(1);
        }
        return pathGeneration == null ? new Path(String.valueOf(projectPath) + GENERATED_FOLDER) : ComposerPathUtils.computeIPath(pathGeneration, object);
    }

    public static final String pathVariablesDecode(String path, Object object) {
        String resolved = path;
        IVariableDecoder[] resolvers = ComposerPathUtils.getDecoders();
        int i = 0;
        while (i < resolvers.length) {
            IVariableDecoder resolver = resolvers[i];
            resolved = resolver.decodePath(resolved, object);
            ++i;
        }
        return resolved;
    }

    private static IVariableDecoder[] getDecoders() {
        return resolvers;
    }

    private static IPath computeIPath(String path, Object object) throws CoreException {
        path = ComposerPathUtils.pathVariablesDecode(path, object);
        Path pathObject = new Path(path);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pathObject.segment(0));
        if (!project.exists()) {
            project = ComposerPathUtils.getComposerProject();
            IFolder folder = ComposerPathUtils.createLinkedFolder(project, path);
            pathObject = folder.getFullPath();
        }
        return pathObject;
    }

    private static IFolder createLinkedFolder(IProject project, String targetPath) throws CoreException {
        File javaFile;
        IFolder folder = project.getFolder(LINKED_FOLDER_NAME);
        if (folder.exists()) {
            folder.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(javaFile = new File(targetPath)).exists()) {
            javaFile.mkdirs();
        }
        folder.createLink((IPath)new Path(targetPath), 0, (IProgressMonitor)new NullProgressMonitor());
        return folder;
    }

    private static IProject getComposerProject() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(COMPOSER_LINK_PROJECT);
        if (!project.exists()) {
            project.create((IProgressMonitor)new NullProgressMonitor());
        }
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        return project;
    }
}

