/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IUpdateMessageListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.UpdateListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderMemberFetcher;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableFolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class RemoteFolder
extends RemoteResource
implements ICVSRemoteFolder,
ICVSFolder {
    protected static final int CHILD_DOES_NOT_EXIST = 1000;
    protected FolderSyncInfo folderInfo;
    private ICVSRemoteResource[] children;
    private ICVSRepositoryLocation repository;

    public static RemoteFolder fromBytes(IResource local, byte[] bytes) throws CVSException {
        Assert.isNotNull((Object)bytes);
        Assert.isTrue((local.getType() != 1 ? 1 : 0) != 0);
        FolderSyncInfo syncInfo = FolderSyncInfo.getFolderSyncInfo(bytes);
        return new RemoteFolder(null, local.getName(), KnownRepositories.getInstance().getRepository(syncInfo.getRoot()), syncInfo.getRepository(), syncInfo.getTag(), syncInfo.getIsStatic());
    }

    public RemoteFolder(RemoteFolder parent, ICVSRepositoryLocation repository, String repositoryRelativePath, CVSTag tag) {
        this(parent, repositoryRelativePath == null ? "" : Util.getLastSegment(repositoryRelativePath), repository, repositoryRelativePath, tag, false);
    }

    public RemoteFolder(RemoteFolder parent, String name, ICVSRepositoryLocation repository, String repositoryRelativePath, CVSTag tag, boolean isStatic) {
        super(parent, name);
        if (repository != null) {
            this.folderInfo = new FolderSyncInfo(repositoryRelativePath.toString(), repository.getLocation(false), tag, isStatic);
        }
        this.repository = repository;
    }

    @Override
    public void accept(ICVSResourceVisitor visitor) throws CVSException {
        visitor.visitFolder(this);
    }

    @Override
    public void accept(ICVSResourceVisitor visitor, boolean recurse) throws CVSException {
        visitor.visitFolder(this);
        ICVSResource[] resources = recurse ? this.members(127) : this.members(1);
        ICVSResource[] iCVSResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSResource resource = iCVSResourceArray[n2];
            resource.accept(visitor, recurse);
            ++n2;
        }
    }

    @Override
    public boolean exists(IProgressMonitor monitor) throws TeamException {
        try {
            this.members(monitor);
            return true;
        }
        catch (CVSException e) {
            if (e.getStatus().getCode() == -17) {
                return false;
            }
            throw e;
        }
    }

    protected boolean exists(ICVSRemoteResource child, IProgressMonitor monitor) throws CVSException {
        return this.exists(child, this.getTag(), monitor);
    }

    protected boolean exists(ICVSRemoteResource child, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(CVSMessages.RemoteFolder_exists, 100);
        try {
            final boolean[] exists = new boolean[]{true};
            IUpdateMessageListener listener = new IUpdateMessageListener(){

                @Override
                public void directoryInformation(ICVSFolder parent, String path, boolean newDirectory) {
                    exists[0] = true;
                }

                @Override
                public void directoryDoesNotExist(ICVSFolder parent, String path) {
                    exists[0] = false;
                }

                @Override
                public void fileInformation(int type, ICVSFolder parent, String filename) {
                    if (type == 1) {
                        exists[0] = false;
                    }
                }

                @Override
                public void fileDoesNotExist(ICVSFolder parent, String filename) {
                    exists[0] = false;
                }
            };
            ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
            localOptions.add(Update.RETRIEVE_ABSENT_DIRECTORIES);
            if (tag != null && tag.getType() != 0) {
                localOptions.add(Update.makeTagOption(tag));
            }
            boolean retry = false;
            session.open(Policy.subMonitorFor(progress, 10), false);
            try (Session session = new Session(this.getRepository(), this, false);){
                IStatus status = Command.UPDATE.execute(session, new Command.GlobalOption[]{Command.DO_NOT_CHANGE}, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new ICVSResource[]{child}, (ICommandOutputListener)new UpdateListener(listener), Policy.subMonitorFor(progress, 70));
                if (status.getCode() == -10) {
                    CVSServerException e = new CVSServerException(status);
                    if (e.isNoTagException() && child.isContainer()) {
                        retry = true;
                    } else if (e.containsErrors()) {
                        throw e;
                    }
                }
            }
            if (retry) {
                Policy.checkCanceled(progress);
                boolean bl = this.exists(child, null, Policy.subMonitorFor(progress, 20));
                return bl;
            }
            boolean bl = exists[0];
            return bl;
        }
        finally {
            progress.done();
        }
    }

    public ICVSRemoteResource[] getMembers(IProgressMonitor monitor) throws TeamException {
        return this.getMembers(this.getTag(), monitor);
    }

    protected ICVSRemoteResource[] getMembers(CVSTag tag, IProgressMonitor monitor) throws CVSException {
        RemoteFolderMemberFetcher fetcher = new RemoteFolderMemberFetcher(this, tag);
        fetcher.fetchMembers(Policy.monitorFor(monitor));
        return this.children;
    }

    @Override
    public ICVSResource[] members(int flags) throws CVSException {
        ArrayList<ICVSRemoteResource> result = new ArrayList<ICVSRemoteResource>();
        ICVSRemoteResource[] resources = this.getChildren();
        if (this.children == null) {
            return new ICVSResource[0];
        }
        if ((flags & 0x20) == 0 && (flags & 0x40) == 64) {
            return new ICVSResource[0];
        }
        boolean includeFiles = (flags & 1) != 0 || (flags & 3) == 0;
        boolean includeFolders = (flags & 2) != 0 || (flags & 3) == 0;
        boolean includeManaged = (flags & 0x10) != 0 || (flags & 0x1C) == 0;
        boolean includeUnmanaged = (flags & 8) != 0 || (flags & 0x1C) == 0;
        boolean includeIgnored = (flags & 4) != 0;
        ICVSRemoteResource[] iCVSRemoteResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSRemoteResource cvsResource = iCVSRemoteResourceArray[n2];
            if (includeFiles && !cvsResource.isFolder() || includeFolders && cvsResource.isFolder()) {
                boolean isManaged = cvsResource.isManaged();
                boolean isIgnored = cvsResource.isIgnored();
                if (isManaged && includeManaged || isIgnored && includeIgnored || !isManaged && !isIgnored && includeUnmanaged) {
                    result.add(cvsResource);
                }
            }
            ++n2;
        }
        return result.toArray(new ICVSResource[result.size()]);
    }

    @Override
    public ICVSFolder getFolder(String name) throws CVSException {
        if (name.equals(".") || name.equals("./")) {
            return this;
        }
        ICVSResource child = this.getChild(name);
        if (child.isFolder()) {
            return (ICVSFolder)child;
        }
        CVSStatus status = new CVSStatus(4, 1000, NLS.bind((String)CVSMessages.RemoteFolder_invalidChild, (Object[])new String[]{name, this.getName()}), child.getIResource());
        throw new CVSException((IStatus)status);
    }

    @Override
    public ICVSFile getFile(String name) throws CVSException {
        ICVSResource child = this.getChild(name);
        if (!child.isFolder()) {
            return (ICVSFile)child;
        }
        CVSStatus status = new CVSStatus(4, 1000, NLS.bind((String)CVSMessages.RemoteFolder_invalidChild, (Object[])new String[]{name, this.getName()}), child.getIResource());
        throw new CVSException((IStatus)status);
    }

    @Override
    public Command.LocalOption[] getLocalOptions() {
        return Command.NO_LOCAL_OPTIONS;
    }

    @Override
    public String getRepositoryRelativePath() {
        return this.getFolderSyncInfo().getRepository();
    }

    @Override
    public String getRelativePath(ICVSFolder ancestor) throws CVSException {
        if (ancestor == this) {
            return ".";
        }
        if (this.parent == null) {
            CVSStatus status = new CVSStatus(4, 4, NLS.bind((String)CVSMessages.RemoteFolder_invalidChild, (Object[])new String[]{this.getName(), ancestor.getName()}), this);
            throw new CVSException((IStatus)status);
        }
        return super.getRelativePath(ancestor);
    }

    @Override
    public ICVSRepositoryLocation getRepository() {
        return this.repository;
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public boolean childExists(String path) {
        try {
            return this.getChild(path) != null;
        }
        catch (CVSException cVSException) {
            return false;
        }
    }

    @Override
    public ICVSResource getChild(String path) throws CVSException {
        if (path.equals(".") || path.length() == 0) {
            return this;
        }
        if (path.contains("/")) {
            Path p = new Path(null, path);
            try {
                return ((RemoteFolder)this.getChild(p.segment(0))).getChild(p.removeFirstSegments(1).toString());
            }
            catch (CVSException e) {
                CVSStatus status = new CVSStatus(4, 1000, NLS.bind((String)CVSMessages.RemoteFolder_invalidChild, (Object[])new String[]{path, this.getName()}), (Throwable)((Object)e), this.repository);
                throw new CVSException((IStatus)status);
            }
        }
        ICVSRemoteResource[] children = this.getChildren();
        if (children == null) {
            CVSStatus status = new CVSStatus(4, 1000, NLS.bind((String)CVSMessages.RemoteFolder_invalidChild, (Object[])new String[]{path, this.getName()}), this.repository);
            throw new CVSException((IStatus)status);
        }
        ICVSRemoteResource[] iCVSRemoteResourceArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSRemoteResource c = iCVSRemoteResourceArray[n2];
            if (c.getName().equals(path)) {
                return c;
            }
            ++n2;
        }
        CVSStatus status = new CVSStatus(4, 1000, NLS.bind((String)CVSMessages.RemoteFolder_invalidChild, (Object[])new String[]{path, this.getName()}), this.repository);
        throw new CVSException((IStatus)status);
    }

    @Override
    public void mkdir() throws CVSException {
        CVSStatus status = new CVSStatus(4, CVSMessages.RemoteResource_invalidOperation);
        throw new CVSException((IStatus)status);
    }

    public void flush(boolean deep) {
    }

    @Override
    public FolderSyncInfo getFolderSyncInfo() {
        return this.folderInfo;
    }

    @Override
    public String getRemoteLocation(ICVSFolder stopSearching) throws CVSException {
        if (this.folderInfo == null) {
            return Util.appendPath(this.parent.getRemoteLocation(stopSearching), this.getName());
        }
        return this.folderInfo.getRemoteLocation();
    }

    @Override
    public boolean isCVSFolder() {
        return this.folderInfo != null;
    }

    @Override
    public void acceptChildren(ICVSResourceVisitor visitor) throws CVSException {
        CVSStatus status = new CVSStatus(4, CVSMessages.RemoteResource_invalidOperation);
        throw new CVSException((IStatus)status);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public ICVSRemoteResource[] members(IProgressMonitor progress) throws TeamException {
        return this.getMembers(progress);
    }

    public ICVSRemoteResource[] getChildren() {
        return this.children;
    }

    protected void setChildren(ICVSRemoteResource[] children) {
        this.children = children;
    }

    public void setTag(CVSTag tag) {
        MutableFolderSyncInfo newInfo = this.folderInfo.cloneMutable();
        newInfo.setTag(tag);
        this.setFolderSyncInfo(newInfo);
    }

    @Override
    public CVSTag getTag() {
        if (this.folderInfo == null) {
            return null;
        }
        return this.folderInfo.getTag();
    }

    @Override
    public void setFolderSyncInfo(FolderSyncInfo folderInfo) {
        this.folderInfo = folderInfo.asImmutable();
    }

    @Override
    public void run(ICVSRunnable job, IProgressMonitor monitor) throws CVSException {
        job.run(monitor);
    }

    @Override
    public IStatus tag(CVSTag tag, Command.LocalOption[] localOptions, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        session.open(Policy.subMonitorFor(monitor, 10), true);
        try (Session session = new Session(this.getRepository(), this, true);){
            IStatus iStatus = Command.RTAG.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions, (CVSTag)this.folderInfo.getTag(), tag, new ICVSRemoteResource[]{this}, Policy.subMonitorFor(monitor, 90));
            return iStatus;
        }
    }

    @Override
    public ICVSResource[] fetchChildren(IProgressMonitor monitor) throws CVSException {
        try {
            return this.getMembers(monitor);
        }
        catch (TeamException e) {
            throw new CVSException(e.getStatus());
        }
    }

    @Override
    public boolean equals(Object target) {
        if (!super.equals(target)) {
            return false;
        }
        RemoteFolder folder = (RemoteFolder)target;
        if (folder.isDefinedModule() != this.isDefinedModule()) {
            return false;
        }
        CVSTag tag1 = this.getTag();
        CVSTag tag2 = folder.getTag();
        if (tag1 == null) {
            tag1 = CVSTag.DEFAULT;
        }
        if (tag2 == null) {
            tag2 = CVSTag.DEFAULT;
        }
        return tag1.equals(tag2);
    }

    @Override
    public int hashCode() {
        CVSTag tag = this.getTag();
        if (tag == null) {
            tag = CVSTag.DEFAULT;
        }
        return super.hashCode() | tag.getName().hashCode();
    }

    protected IPath getRelativePathFromRootRelativePath(ICVSFolder root, IPath path) throws CVSException {
        if (root == this) {
            return path;
        }
        Assert.isTrue((!path.isEmpty() ? 1 : 0) != 0);
        return this.getRelativePathFromRootRelativePath((ICVSFolder)root.getChild(path.segment(0)), path.removeFirstSegments(1));
    }

    @Override
    public ICVSRemoteResource forTag(ICVSRemoteFolder parent, CVSTag tagName) {
        return new RemoteFolder((RemoteFolder)parent, this.getName(), this.repository, this.folderInfo.getRepository(), tagName, this.folderInfo.getIsStatic());
    }

    @Override
    public ICVSRemoteResource forTag(CVSTag tagName) {
        return this.forTag(null, tagName);
    }

    @Override
    public boolean isDefinedModule() {
        return false;
    }

    @Override
    public ResourceSyncInfo getSyncInfo() {
        return new ResourceSyncInfo(this.getName());
    }

    @Override
    public byte[] getSyncBytes() {
        try {
            return this.folderInfo.getBytes();
        }
        catch (CVSException cVSException) {
            return null;
        }
    }

    public String getContentIdentifier() {
        return this.getTag().getName();
    }

    @Override
    public boolean isManaged() {
        return super.isManaged() && this.isCVSFolder();
    }

    protected void fetchContents(IProgressMonitor monitor) throws TeamException {
    }
}

