/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.builder.AbstractLeakProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;

public abstract class AbstractTypeLeakDetector
extends AbstractLeakProblemDetector {
    public AbstractTypeLeakDetector(Set<String> nonApiPackageNames) {
        super(nonApiPackageNames);
    }

    @Override
    public boolean considerReference(IReference reference, IProgressMonitor monitor) {
        IApiMember member;
        int modifiers;
        if (super.considerReference(reference, monitor) && this.isNonAPIReference(reference) && (5 & (modifiers = (member = reference.getMember()).getModifiers())) > 0) {
            try {
                IApiAnnotations annotations = member.getApiComponent().getApiDescription().resolveAnnotations(member.getHandle());
                if (annotations != null && this.isApplicable(annotations) && this.isEnclosingTypeVisible(member)) {
                    this.retainReference(reference);
                    return true;
                }
            }
            catch (CoreException e) {
                ApiPlugin.log(e.getStatus());
                AbstractTypeLeakDetector.checkIfDisposed(reference.getMember().getApiComponent(), monitor);
            }
        }
        return false;
    }

    @Override
    protected boolean isProblem(IReference reference, IProgressMonitor monitor) {
        block5: {
            IApiMember member = reference.getResolvedReference();
            try {
                IApiAnnotations annotations = member.getApiComponent().getApiDescription().resolveAnnotations(member.getHandle());
                if (annotations != null) {
                    return VisibilityModifiers.isPrivate(annotations.getVisibility());
                }
                if (this.isEnclosingTypeVisible(member)) {
                    String memberName = member.getName();
                    if (memberName != null && !memberName.startsWith("javax.")) {
                        ApiPlugin.log(Status.info((String)MessageFormat.format(BuilderMessages.AbstractTypeLeakDetector_vis_type_has_no_api_description, memberName)));
                    }
                    break block5;
                }
                return true;
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
                AbstractTypeLeakDetector.checkIfDisposed(member.getApiComponent(), monitor);
            }
        }
        return false;
    }

    protected boolean isApplicable(IApiAnnotations annotations) {
        return VisibilityModifiers.isAPI(annotations.getVisibility());
    }

    @Override
    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        return new String[]{this.getQualifiedTypeName(reference.getResolvedReference()), this.getQualifiedTypeName(reference.getMember())};
    }

    @Override
    protected String[] getMessageArgs(IReference reference) throws CoreException {
        return new String[]{this.getSimpleTypeName(reference.getResolvedReference()), this.getSimpleTypeName(reference.getMember())};
    }

    @Override
    protected Position getSourceRange(IType type, IDocument doc, IReference reference) throws CoreException, BadLocationException {
        ISourceRange range = type.getNameRange();
        Position pos = null;
        if (range != null) {
            pos = new Position(range.getOffset(), range.getLength());
        }
        if (pos == null) {
            return this.defaultSourcePosition(type, reference);
        }
        return pos;
    }

    @Override
    protected int getElementType(IReference reference) {
        return 2;
    }

    @Override
    protected int getProblemKind() {
        return 6;
    }
}

