/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.category;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.amalgam.explorer.contextual.core.category.CategoryImpl;
import org.eclipse.amalgam.explorer.contextual.core.category.ICategory;
import org.eclipse.amalgam.explorer.contextual.core.category.Messages;
import org.eclipse.amalgam.explorer.contextual.core.ext.AbstractExtensionPointManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;

public class CategoryRegistry
extends AbstractExtensionPointManager {
    protected static CategoryRegistry _categoryRegistry = null;
    private static final String CONTENT_PROVIDER_CATEGORY = Messages.getString("CategoryRegistry.ContentProvider");
    protected List<ICategory> categoriesCache = new ArrayList<ICategory>(0);
    protected HashMap<String, ICategory> currentElementRegistry = null;
    protected HashMap<String, ICategory> diagramElementRegistry = null;
    protected HashMap<String, ICategory> referencedElementRegistry = null;
    protected HashMap<String, ICategory> referencingElementRegistry = null;

    private CategoryRegistry() {
        this.initRegister();
    }

    public Set<ICategory> gatherCategories(String viewerId_p, EObject currentElement_p) {
        Set<ICategory> result = this.gatherCategoriesInternal(currentElement_p, this.getRegistry(viewerId_p));
        return result;
    }

    private Set<ICategory> gatherCategoriesInternal(Object element_p, HashMap<String, ICategory> elementRegistry_p) {
        HashSet<ICategory> categories = new HashSet<ICategory>(0);
        Set<Map.Entry<String, ICategory>> entrySet = elementRegistry_p.entrySet();
        for (Map.Entry<String, ICategory> entry : entrySet) {
            ICategory category = entry.getValue();
            if (!category.isAvailableForType(element_p) || !category.isTopLevel()) continue;
            categories.add(category);
        }
        return categories;
    }

    public List<ICategory> gatherSubCategories(String viewerId_p, EObject currentElement_p, ICategory category_p) {
        List<ICategory> result = this.gatherSubCategoriesInternal(currentElement_p, category_p, this.getRegistry(viewerId_p));
        return result;
    }

    private List<ICategory> gatherSubCategoriesInternal(Object element_p, ICategory category_p, HashMap<String, ICategory> elementRegistry_p) {
        ArrayList<ICategory> subCategories = new ArrayList<ICategory>(0);
        for (String subCategoryId : category_p.getSubCategoryIds()) {
            ICategory subCategory = elementRegistry_p.get(subCategoryId);
            if (subCategory == null || !subCategory.isAvailableForType(element_p)) continue;
            subCategories.add(subCategory);
        }
        return subCategories;
    }

    protected HashMap<String, ICategory> getRegistry(String viewerId_p) {
        if (viewerId_p.equalsIgnoreCase("CurrentElementExplorer")) {
            return this.currentElementRegistry;
        }
        if (viewerId_p.equalsIgnoreCase("ReferencedElementExplorer")) {
            return this.referencedElementRegistry;
        }
        if (viewerId_p.equalsIgnoreCase("ReferencingElementExplorer")) {
            return this.referencingElementRegistry;
        }
        return this.diagramElementRegistry;
    }

    private void initRegister() {
        IConfigurationElement[] categories;
        this.currentElementRegistry = new HashMap(0);
        this.referencedElementRegistry = new HashMap(0);
        this.referencingElementRegistry = new HashMap(0);
        this.diagramElementRegistry = new HashMap(0);
        IConfigurationElement[] iConfigurationElementArray = categories = CategoryRegistry.getConfigurationElementsFor("org.eclipse.amalgam.explorer.contextual.core", CONTENT_PROVIDER_CATEGORY);
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] targetExplorerIdNode;
            IConfigurationElement[] typeConfigurationElement;
            IConfigurationElement[] queryConfigurationElements;
            IConfigurationElement[] itemQueriesNode;
            IConfigurationElement categoryConfigurationElement = iConfigurationElementArray[n2];
            CategoryImpl category = new CategoryImpl();
            String categoryId = categoryConfigurationElement.getAttribute("id");
            category.setId(categoryId);
            String categoryName = categoryConfigurationElement.getAttribute("name");
            category.setName(categoryName);
            String isTopLevelCategory = categoryConfigurationElement.getAttribute(Messages.getString("CategoryRegistry.TopLevel"));
            if (isTopLevelCategory != null && isTopLevelCategory != "") {
                category.setIsTopLevel(Boolean.parseBoolean(isTopLevelCategory));
            } else {
                category.setIsTopLevel(false);
            }
            IConfigurationElement[] subCategoriesNodes = categoryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.SubCategory"));
            if (subCategoriesNodes.length > 0) {
                IConfigurationElement[] subCategoryConfigurationElements;
                IConfigurationElement[] iConfigurationElementArray2 = subCategoryConfigurationElements = subCategoriesNodes[0].getChildren(Messages.getString("CategoryRegistry.Category"));
                int n3 = subCategoryConfigurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement subCategoryConfigurationElement = iConfigurationElementArray2[n4];
                    category.addSubCategoryId(subCategoryConfigurationElement.getAttribute("id"));
                    ++n4;
                }
            }
            if ((itemQueriesNode = categoryConfigurationElement.getChildren(Messages.getString("ItemQueries"))).length > 0) {
                IConfigurationElement[] itemQueries = itemQueriesNode[0].getChildren(Messages.getString("basicQuery"));
                List<IConfigurationElement> basicQueryCollection = Arrays.asList(itemQueries);
                List<IConfigurationElement> navigationQueryCollection = Arrays.asList(itemQueriesNode[0].getChildren(Messages.getString("CategoryRegistry.NavigationQuery")));
                basicQueryCollection.addAll(navigationQueryCollection);
                IConfigurationElement[] iConfigurationElementArray3 = itemQueries = (IConfigurationElement[])basicQueryCollection.toArray();
                int n5 = itemQueries.length;
                int n6 = 0;
                while (n6 < n5) {
                    IConfigurationElement itemQueryConfigurationElement = iConfigurationElementArray3[n6];
                    Object queryInstance = CategoryRegistry.createInstance(itemQueryConfigurationElement, "class");
                    category.addItemQuery(queryInstance);
                    ++n6;
                }
            }
            if ((queryConfigurationElements = categoryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.CategoryQuery"))).length > 0) {
                Object query = null;
                IConfigurationElement queryConfigurationElement = queryConfigurationElements[0];
                IConfigurationElement[] categoryQueries = queryConfigurationElement.getChildren(Messages.getString("basicQuery"));
                if (categoryQueries.length == 0) {
                    categoryQueries = queryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.NavigationQuery"));
                }
                if (categoryQueries.length > 0) {
                    query = CategoryRegistry.createInstance(categoryQueries[0], "class");
                }
                category.setQuery(query);
            }
            if ((typeConfigurationElement = categoryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.AvailableForType"))).length > 0) {
                String qualifiedClassName = typeConfigurationElement[0].getAttribute("class");
                category.setTypeFullyQualifiedName(qualifiedClassName);
            }
            if ((targetExplorerIdNode = categoryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.TargetExplorerId"))).length > 0) {
                IConfigurationElement explorerIdConfigurationElement = targetExplorerIdNode[0];
                String id = explorerIdConfigurationElement.getAttribute("id");
                if (id.equalsIgnoreCase("CurrentElementExplorer")) {
                    this.currentElementRegistry.put(categoryId, category);
                } else if (id.equalsIgnoreCase("ReferencingElementExplorer")) {
                    this.referencingElementRegistry.put(categoryId, category);
                } else if (id.equalsIgnoreCase("ReferencedElementExplorer")) {
                    this.referencedElementRegistry.put(categoryId, category);
                } else {
                    this.diagramElementRegistry.put(categoryId, category);
                }
            }
            ++n2;
        }
    }

    public static CategoryRegistry getInstance() {
        if (_categoryRegistry == null) {
            _categoryRegistry = new CategoryRegistry();
        }
        return _categoryRegistry;
    }
}

