/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers.categories;

import java.util.Set;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IElementRelativeDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategory;
import org.eclipse.emf.diffmerge.ui.viewers.categories.AbstractDifferenceCategoryItem;

public abstract class AbstractDifferenceCategory
extends AbstractDifferenceCategoryItem
implements IDifferenceCategory {
    private boolean _visible = true;
    private boolean _active = false;
    private boolean _modifiable = true;
    private boolean _inFocusMode = false;

    protected AbstractDifferenceCategory() {
    }

    @Override
    public void copyState(IDifferenceCategory peer_p) {
        this.setActive(peer_p.isActive());
        this.setInFocusMode(peer_p.isInFocusMode());
        this.setModifiable(peer_p.isModifiable());
        this.setVisible(peer_p.isVisible());
    }

    @Override
    public String getDescription(EMFDiffNode node_p) {
        return null;
    }

    protected Object getDifferenceElement(IDifference<?> difference_p) {
        Object result = null;
        if (difference_p instanceof IElementRelativeDifference) {
            IElementRelativeDifference casted = (IElementRelativeDifference)difference_p;
            IMatch match = casted.getElementMatch();
            result = this.getElement(match);
        }
        return result;
    }

    protected Object getDifferenceFeature(IDifference<?> difference_p) {
        Object result = null;
        if (difference_p instanceof IValuePresence) {
            IValuePresence casted = (IValuePresence)difference_p;
            result = casted.getFeature();
        }
        return result;
    }

    protected Object getElement(IMatch<?> match_p) {
        return this.getElements(match_p).iterator().next();
    }

    protected Set<Object> getElements(IMatch<?> match_p) {
        FOrderedSet result = new FOrderedSet();
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            Object element = match_p.get(role);
            if (element != null) {
                result.add(element);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public boolean isActive() {
        return this._active;
    }

    @Override
    public boolean isApplicable(EMFDiffNode node_p) {
        return true;
    }

    @Override
    public boolean isInFocusMode() {
        return this._inFocusMode;
    }

    @Override
    public boolean isModifiable() {
        return this._modifiable;
    }

    @Override
    public boolean isVisible() {
        return this._visible;
    }

    @Override
    public boolean mayCoverPendingDifferences() {
        return true;
    }

    @Override
    public void setActive(boolean active_p) {
        this._active = active_p;
    }

    @Override
    public void setInFocusMode(boolean inFocusMode_p) {
        this._inFocusMode = inFocusMode_p;
    }

    @Override
    public void setModifiable(boolean modifiable_p) {
        this._modifiable = modifiable_p;
    }

    @Override
    public void setVisible(boolean visible_p) {
        this._visible = visible_p;
    }
}

