/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.report.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.polarsys.kitalpha.report.model.ReportList;
import org.polarsys.kitalpha.report.registry.ReportRegistry;
import org.polarsys.kitalpha.report.ui.Activator;
import org.polarsys.kitalpha.report.ui.description.ReportsUI;
import org.polarsys.kitalpha.report.ui.views.MenuCreatorAction;

class SelectReportDropDownAction
extends MenuCreatorAction
implements IMenuCreator {
    private final Action selectAction = new SelectReportAction();
    private final Action deselectAction = new DeselectReportAction();

    public SelectReportDropDownAction() {
        this.setToolTipText("Manage reports providers");
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/chooseReport.png"));
        this.setMenuCreator(this);
    }

    @Override
    protected void fillMenu(Control parent) {
        ReportList[] reportListArray = ReportRegistry.INSTANCE.getLists();
        int n = reportListArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReportList list = reportListArray[n2];
            ManageReportAction action = new ManageReportAction(list);
            action.setChecked(ReportsUI.getDisplayedLists().contains(list));
            this.addActionToMenu(this.menu, action);
            ++n2;
        }
        new MenuItem(this.menu, 2);
        this.addActionToMenu(this.menu, this.selectAction);
        this.addActionToMenu(this.menu, this.deselectAction);
    }

    class DeselectReportAction
    extends Action {
        public DeselectReportAction() {
            super("Deselect all");
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/deselectAll.gif"));
        }

        public void run() {
            ReportsUI.hideAllLists();
        }
    }

    class ManageReportAction
    extends Action {
        private final ReportList list;

        public ManageReportAction(ReportList list) {
            super(list.getId(), 2);
            this.list = list;
        }

        public void run() {
            if (ReportsUI.getDisplayedLists().contains(this.list)) {
                ReportsUI.hideList(this.list);
            } else {
                ReportsUI.showList(this.list);
            }
        }
    }

    class SelectReportAction
    extends Action {
        public SelectReportAction() {
            super("Select all");
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/selectAll.gif"));
        }

        public void run() {
            ReportsUI.showAllLists();
        }
    }
}

