/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.misc;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.ITemplatePatternBasedSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractPatternWizard;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractPatternImageBuilderJob
extends Job {
    private static final String NAME = Messages.AbstractPatternWizard_ComputationJobName;
    private final AbstractPatternWizard<?> _wizard;
    private final TemplatePattern _pattern;
    private final List<Object> _graphicalContext;
    private String _imageSpecifiation;
    private final boolean _updatePattern;

    public AbstractPatternImageBuilderJob(AbstractPatternWizard<?> wizard_p, List<Object> graphicalContext_p, boolean updatePattern_p) {
        super(NAME);
        this._wizard = wizard_p;
        this._graphicalContext = Collections.unmodifiableList(graphicalContext_p);
        this._imageSpecifiation = null;
        this._pattern = ((ITemplatePatternBasedSpecification)wizard_p.getData()).getPattern();
        this._updatePattern = updatePattern_p;
    }

    public AbstractPatternImageBuilderJob(AbstractPatternWizard<?> wizard_p, String imageSpecification_p, boolean updatePattern_p) {
        super(NAME);
        this._wizard = wizard_p;
        this._graphicalContext = null;
        this._imageSpecifiation = imageSpecification_p;
        this._pattern = ((ITemplatePatternBasedSpecification)wizard_p.getData()).getPattern();
        this._updatePattern = updatePattern_p;
    }

    protected IStatus run(IProgressMonitor monitor_p) {
        IStatus result = Status.OK_STATUS;
        if (this._graphicalContext != null) {
            this._imageSpecifiation = this.exportToSVG(this._graphicalContext);
        }
        Image image = null;
        if (this._imageSpecifiation != null && this._imageSpecifiation.length() > 0) {
            image = UIUtil.renderSVG(this._imageSpecifiation);
        }
        this._wizard.setPatternImage(this._pattern, this._imageSpecifiation, image, this._updatePattern);
        return result;
    }

    protected abstract String exportToSVG(List<Object> var1);
}

