/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.pages;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.epackage.IProxyEObject;
import org.eclipse.egf.model.EGFModelPlugin;
import org.eclipse.egf.model.pattern.BasicQuery;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternFactory;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternInitializer;
import org.eclipse.egf.pattern.query.IQuery;
import org.eclipse.egf.pattern.query.QueryKind;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.PatternUIHelper;
import org.eclipse.egf.pattern.ui.contributions.EditHelper;
import org.eclipse.egf.pattern.ui.editors.adapter.LiveValidationContentAdapter;
import org.eclipse.egf.pattern.ui.editors.dialogs.ParametersEditDialog;
import org.eclipse.egf.pattern.ui.editors.dialogs.PatternSelectionDialog;
import org.eclipse.egf.pattern.ui.editors.models.QueryContent;
import org.eclipse.egf.pattern.ui.editors.modifiers.ParametersTableCellModifier;
import org.eclipse.egf.pattern.ui.editors.pages.PatternEditorPage;
import org.eclipse.egf.pattern.ui.editors.providers.ComboListLabelProvider;
import org.eclipse.egf.pattern.ui.editors.providers.CommonListContentProvider;
import org.eclipse.egf.pattern.ui.editors.providers.ParametersTableLabelProvider;
import org.eclipse.egf.pattern.ui.editors.providers.TableObservableListContentProvider;
import org.eclipse.egf.pattern.ui.editors.wizards.OpenTypeWizard;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class SpecificationPage
extends PatternEditorPage {
    public static final String ID = "org.eclipse.egf.pattern.ui.editors.pages.specification.page.id";
    private Link parentLink;
    private Button add;
    private Button edit;
    private Button remove;
    private Button up;
    private Button down;
    private Button browse;
    private Button removeParent;
    private Combo natureCombo;
    private TableViewer parametersViewer;
    private FormColors colors = new FormColors(Display.getDefault());
    public static final String NAME_COLUMN_ID = "Name";
    public static final String TYPE_COLUMN_ID = "Type";
    public static final String QUERY_COLUMN_ID = "Query";
    private static final String NO_QUERY_VALUE = "";
    private static final String PARAMETER_NAME_DEFAULT_VALUE = "parameter";
    private static final String PARAMETER_TYPE_DEFAULT_VALUE = "http://www.eclipse.org/emf/2002/Ecore#//EClass";
    private int dragIndex = -1;
    private ISelectionChangedListener changedListener;
    private ParametersTableCellModifier modifier;
    private TextCellEditor nameEditor;
    private DialogCellEditor typeEditor;
    private ComboBoxViewerCellEditor queryEditor;
    private LiveValidationContentAdapter parameterNameEmptyValidationAdapter;
    private IMessageManager messageManager;

    public SpecificationPage(FormEditor editor) {
        super(editor, ID, Messages.SpecificationPage_title);
    }

    @Override
    protected void checkReadOnlyModel() {
        if (this.isReadOnly()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    private void setEnabled(boolean enabled) {
        this.browse.setEnabled(enabled);
        this.removeParent.setEnabled(enabled);
        this.add.setEnabled(enabled);
        this.edit.setEnabled(enabled);
        this.remove.setEnabled(enabled);
        this.up.setEnabled(enabled);
        this.down.setEnabled(enabled);
        this.natureCombo.setEnabled(enabled);
        if (enabled) {
            this.parametersViewer.addSelectionChangedListener(this.changedListener);
            this.parametersViewer.setCellModifier((ICellModifier)this.modifier);
            this.parametersViewer.setCellEditors(new CellEditor[]{this.nameEditor, this.typeEditor, this.queryEditor});
        } else {
            this.parametersViewer.removeSelectionChangedListener(this.changedListener);
            this.parametersViewer.setCellModifier(null);
            this.parametersViewer.setCellEditors(null);
        }
    }

    protected void openParentPatternEditor() {
        EditHelper.openPatternEditor(this.getSite().getPage(), this.getPattern().getSuperPattern());
    }

    @Override
    protected void doCreateFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.messageManager = managedForm.getMessageManager();
        ScrolledForm form = managedForm.getForm();
        toolkit.decorateFormHeading(form.getForm());
        Composite body = form.getBody();
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        body.setLayout((Layout)twl);
        form.setImage(Activator.getDefault().getImage("obj16/plugin_mf_obj.gif"));
        form.setText(Messages.SpecificationPage_title);
        this.createInheritanceSection(toolkit, body);
        this.createPatternNatureSection(toolkit, body);
        this.createParametersSection(toolkit, body);
        form.reflow(true);
    }

    private void createInheritanceSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.SpecificationPage_inherSection_title);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        Composite container = toolkit.createComposite((Composite)section, 0);
        container.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        container.setLayout((Layout)twl);
        Label title = toolkit.createLabel(container, Messages.SpecificationPage_inherSection_discrip_label);
        TableWrapData twd = new TableWrapData(256);
        twd.colspan = 2;
        title.setLayoutData((Object)twd);
        Label parentLabel = toolkit.createLabel(container, Messages.SpecificationPage_inherSection_parent_label);
        parentLabel.setLayoutData((Object)new TableWrapData(2, 32));
        parentLabel.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        this.parentLink = new Link(container, 64);
        this.parentLink.setLayoutData((Object)new TableWrapData(256, 32));
        this.parentLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecificationPage.this.openParentPatternEditor();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createInheritanceButtons(toolkit, container);
        section.setClient((Control)container);
    }

    private void createInheritanceButtons(FormToolkit toolkit, Composite parent) {
        Composite container = toolkit.createComposite(parent, 0);
        TableWrapData twd = new TableWrapData(4, 32);
        twd.colspan = 2;
        container.setLayoutData((Object)twd);
        container.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData(1808);
        gd.widthHint = 65;
        this.browse = toolkit.createButton(container, Messages.SpecificationPage_button_browse, 8);
        this.browse.setLayoutData((Object)gd);
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PatternSelectionDialog dialog = new PatternSelectionDialog(e.display.getActiveShell(), false);
                dialog.setTitle(Messages.SpecificationPage_browse_dialog_title);
                if (dialog.open() != 0) {
                    return;
                }
                Object result = dialog.getFirstResult();
                if (result instanceof Pattern) {
                    final Pattern pattern = (Pattern)result;
                    TransactionalEditingDomain editingDomain = SpecificationPage.this.getEditingDomain();
                    RecordingCommand cmd = new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            SpecificationPage.this.getPattern().setSuperPattern(pattern);
                        }
                    };
                    editingDomain.getCommandStack().execute((Command)cmd);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeParent = toolkit.createButton(container, NO_QUERY_VALUE, 8);
        this.removeParent.setLayoutData((Object)gd);
        this.removeParent.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        this.removeParent.setToolTipText(Messages.SpecificationPage_button_remove);
        this.removeParent.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransactionalEditingDomain editingDomain = SpecificationPage.this.getEditingDomain();
                RecordingCommand cmd = new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        SpecificationPage.this.getPattern().setSuperPattern(null);
                    }
                };
                editingDomain.getCommandStack().execute((Command)cmd);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createPatternNatureSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.SpecificationPage_patternSection_title);
        section.setLayoutData((Object)new TableWrapData(256));
        Composite container = toolkit.createComposite((Composite)section, 0);
        container.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        container.setLayout((Layout)twl);
        Label label = toolkit.createLabel(container, Messages.SpecificationPage_patternSection_discrip_label, 64);
        TableWrapData twd = new TableWrapData(256);
        twd.colspan = 2;
        label.setLayoutData((Object)twd);
        this.createTypeArea(toolkit, container);
        section.setClient((Control)container);
    }

    private void createTypeArea(FormToolkit toolkit, Composite composite) {
        Label type = toolkit.createLabel(composite, Messages.SpecificationPage_patternSection_type_label);
        type.setLayoutData((Object)new TableWrapData(256));
        type.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        this.natureCombo = new Combo(composite, 8);
        for (String name : EGFPatternPlugin.getPatternNatures()) {
            this.natureCombo.add(name);
        }
        this.natureCombo.setLayoutData((Object)new TableWrapData(256));
        this.natureCombo.select(0);
    }

    private void updateNature() {
        final Pattern pattern = this.getPattern();
        PatternLibrary library = pattern.getContainer();
        final IProject project = EMFHelper.getProject((Resource)library.eResource());
        WorkspaceJob job = new WorkspaceJob(Messages.PatternNature_update){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    PatternInitializer initializer = ExtensionHelper.getExtension((PatternNature)SpecificationPage.this.getPattern().getNature()).createInitializer(project, pattern);
                    initializer.updateSpecialMethods(true);
                }
                catch (Throwable t) {
                    if (t instanceof CoreException) {
                        return ((CoreException)t).getStatus();
                    }
                    return EGFModelPlugin.getPlugin().newStatus(4, NLS.bind((String)Messages.PatternNature_update_execute_exception, (Object)EcoreUtil.getURI((EObject)SpecificationPage.this.getPattern())), t);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)project);
        job.schedule();
        this.getEditor().doSave((IProgressMonitor)new NullProgressMonitor());
    }

    private void createParametersSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.SpecificationPage_paraSection_title);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        Composite container = toolkit.createComposite((Composite)section, 0);
        container.setLayoutData((Object)new TableWrapData(256));
        container.setLayout((Layout)new GridLayout(2, false));
        Label discrip = toolkit.createLabel(container, Messages.SpecificationPage_paraSection_discrip_label, 64);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 4;
        gd.widthHint = 100;
        discrip.setLayoutData((Object)gd);
        this.createParametersTableArea(toolkit, container);
        this.createParametersButtons(toolkit, container);
        section.setClient((Control)container);
    }

    private void createParametersTableArea(FormToolkit toolkit, Composite parameters) {
        Composite tableComp = new Composite(parameters, 0);
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        tableComp.setLayoutData((Object)gd);
        Table table = toolkit.createTable(tableComp, 68352);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gd = new GridData(1808);
        gd.verticalIndent = 10;
        gd.horizontalIndent = 10;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        this.parametersViewer = new TableViewer(table);
        String[] colNames = new String[]{Messages.SpecificationPage_column_title_name, Messages.SpecificationPage_column_title_type, Messages.SpecificationPage_column_title_query};
        int[] colWidths = new int[]{100, 80, 80};
        this.parametersViewer.setContentProvider((IContentProvider)new TableObservableListContentProvider(this.parametersViewer));
        this.parametersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SpecificationPage.this.isReadOnly()) {
                    return;
                }
                SpecificationPage.this.setButtonsStatus();
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.parametersViewer, (int)2);
        ParametersTableLabelProvider cellLabelProvider = new ParametersTableLabelProvider();
        int i = 0;
        while (i < colNames.length) {
            TableViewerColumn column = new TableViewerColumn(this.parametersViewer, 0);
            column.setLabelProvider((CellLabelProvider)cellLabelProvider);
            column.getColumn().setWidth(colWidths[i]);
            column.getColumn().setText(colNames[i]);
            layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(colWidths[i], true));
            ++i;
        }
        this.initTableEditor();
        this.addDragDrop();
    }

    private void addDragDrop() {
        this.parametersViewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                if (SpecificationPage.this.isReadOnly()) {
                    event.doit = false;
                } else if (SpecificationPage.this.parametersViewer.getSelection() == null) {
                    event.doit = false;
                }
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                if (SpecificationPage.this.parametersViewer.getSelection() != null) {
                    SpecificationPage.this.dragIndex = SpecificationPage.this.parametersViewer.getTable().getSelectionIndex();
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.parametersViewer.addDropSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.parametersViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return !SpecificationPage.this.isReadOnly();
            }

            public boolean performDrop(Object data) {
                Object currentTarget = this.getCurrentTarget();
                SpecificationPage.this.executeChangeOrder(currentTarget);
                return false;
            }
        });
    }

    protected void executeChangeOrder(Object currentTarget) {
        EList allParameters = this.getPattern().getAllParameters();
        Object currentSource = allParameters.get(this.dragIndex);
        BasicEList allParametersNew = new BasicEList();
        int targetIndex = 0;
        int index = 0;
        if (currentTarget == null) {
            targetIndex = this.parametersViewer.getTable().getItemCount() - 1;
            currentTarget = this.parametersViewer.getElementAt(targetIndex);
        } else {
            for (Object parameter : allParameters) {
                if (currentTarget.equals(parameter)) {
                    targetIndex = index;
                    break;
                }
                ++index;
            }
        }
        int i = 0;
        while (i < allParameters.size()) {
            if (i == targetIndex) {
                if (targetIndex > this.dragIndex) {
                    allParametersNew.add((Object)((PatternParameter)currentTarget));
                    allParametersNew.add((Object)((PatternParameter)currentSource));
                } else {
                    allParametersNew.add((Object)((PatternParameter)currentSource));
                    allParametersNew.add((Object)((PatternParameter)currentTarget));
                }
            } else if (i != this.dragIndex) {
                allParametersNew.add((Object)((PatternParameter)allParameters.get(i)));
            }
            ++i;
        }
        this.updateAllParameters((BasicEList<PatternParameter>)allParametersNew);
        this.parametersViewer.getTable().setSelection(targetIndex);
        this.setButtonsStatus();
    }

    private void createParametersButtons(FormToolkit toolkit, Composite parameters) {
        Composite buttons = toolkit.createComposite(parameters, 0);
        GridLayout layout = new GridLayout();
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.widthHint = 65;
        this.add = toolkit.createButton(buttons, NO_QUERY_VALUE, 8);
        this.add.setLayoutData((Object)gd);
        this.add.setImage(Activator.getDefault().getImage("obj16/add.gif"));
        this.add.setToolTipText(Messages.SpecificationPage_button_add);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecificationPage.this.executeAdd();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.edit = toolkit.createButton(buttons, NO_QUERY_VALUE, 8);
        this.edit.setLayoutData((Object)gd);
        this.edit.setEnabled(false);
        this.edit.setImage(Activator.getDefault().getImage("obj16/edit.gif"));
        this.edit.setToolTipText(Messages.SpecificationPage_button_edit);
        this.edit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = SpecificationPage.this.parametersViewer.getSelection();
                final Object selectItem = ((IStructuredSelection)selection).getFirstElement();
                if (selectItem instanceof PatternParameter) {
                    PatternParameter patternParameter = (PatternParameter)selectItem;
                    final ParametersEditDialog dialog = new ParametersEditDialog(SpecificationPage.this.getSite().getShell(), patternParameter);
                    dialog.setTitle(Messages.SpecificationPage_parametersEditDialog_title);
                    if (dialog.open() == 0) {
                        TransactionalEditingDomain editingDomain = SpecificationPage.this.getEditingDomain();
                        RecordingCommand cmd = new RecordingCommand(editingDomain){

                            protected void doExecute() {
                                SpecificationPage.this.executeParameterEdit(dialog, selectItem);
                            }
                        };
                        editingDomain.getCommandStack().execute((Command)cmd);
                    }
                }
                SpecificationPage.this.parametersViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.remove = toolkit.createButton(buttons, NO_QUERY_VALUE, 8);
        this.remove.setLayoutData((Object)gd);
        this.remove.setEnabled(false);
        this.remove.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        this.remove.setToolTipText(Messages.SpecificationPage_button_remove);
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecificationPage.this.executeRemove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.up = toolkit.createButton(buttons, NO_QUERY_VALUE, 8);
        this.up.setLayoutData((Object)gd);
        this.up.setEnabled(false);
        this.up.setImage(Activator.getDefault().getImage("obj16/upward.gif"));
        this.up.setToolTipText(Messages.SpecificationPage_button_up);
        this.up.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecificationPage.this.executeUpOrDown(-1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.down = toolkit.createButton(buttons, NO_QUERY_VALUE, 8);
        this.down.setLayoutData((Object)gd);
        this.down.setEnabled(false);
        this.down.setImage(Activator.getDefault().getImage("obj16/downward.gif"));
        this.down.setToolTipText(Messages.SpecificationPage_button_down);
        this.down.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecificationPage.this.executeUpOrDown(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void executeParameterEdit(ParametersEditDialog dialog, Object selectItem) {
        String newName = dialog.getName();
        String newType = dialog.getType();
        String newQuey = dialog.getQuery();
        QueryKind queryKind = IQuery.INSTANCE.getQueryKindByName(newQuey);
        if (queryKind != null) {
            newQuey = queryKind.getId();
        }
        if (selectItem instanceof PatternParameter) {
            PatternParameter item = (PatternParameter)selectItem;
            item.setName(newName);
            item.setType(newType);
            Query queryItem = item.getQuery();
            if (queryItem != null) {
                queryItem.setExtensionId(newQuey);
                this.setQueryContent(dialog, queryItem);
            } else if (!NO_QUERY_VALUE.equals(newQuey)) {
                BasicQuery query = PatternFactory.eINSTANCE.createBasicQuery();
                query.setExtensionId(newQuey);
                item.setQuery((Query)query);
                query.setParameter(item);
                this.setQueryContent(dialog, (Query)query);
            }
            if (NO_QUERY_VALUE.equals(queryItem)) {
                item.setQuery(null);
            }
        }
    }

    private void setQueryContent(ParametersEditDialog dialog, Query query) {
        List<QueryContent> queryContents = dialog.getQueryContents();
        EMap queryContext = query.getQueryContext();
        if (queryContext != null && !queryContext.isEmpty()) {
            queryContext.clear();
        }
        for (QueryContent queryContent : queryContents) {
            queryContext.put((Object)queryContent.getKey(), (Object)queryContent.getValue());
        }
    }

    private void setButtonsStatus() {
        int selectIndex = this.parametersViewer.getTable().getSelectionIndex();
        if (selectIndex == -1) {
            this.edit.setEnabled(false);
            this.remove.setEnabled(false);
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            return;
        }
        int length = this.parametersViewer.getTable().getItemCount();
        if (length > 0) {
            this.remove.setEnabled(true);
            this.edit.setEnabled(true);
        } else {
            this.remove.setEnabled(false);
            this.edit.setEnabled(false);
        }
        if (selectIndex <= 0) {
            this.up.setEnabled(false);
        } else {
            this.up.setEnabled(true);
        }
        if (selectIndex + 1 == length) {
            this.down.setEnabled(false);
        } else {
            this.down.setEnabled(true);
        }
    }

    protected void executeRemove() {
        int index = this.parametersViewer.getTable().getSelectionIndex();
        final Pattern pattern = this.getPattern();
        ISelection selection = this.parametersViewer.getSelection();
        final Object[] removeThem = ((IStructuredSelection)selection).toArray();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                Object[] objectArray = removeThem;
                int n = removeThem.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof PatternParameter) {
                        pattern.getParameters().remove(object);
                    }
                    ++n2;
                }
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
        int len = this.parametersViewer.getTable().getItemCount();
        if (index < len) {
            this.parametersViewer.getTable().setSelection(index);
        } else if (index >= len) {
            this.parametersViewer.getTable().setSelection(index - 1);
        }
        this.setButtonsStatus();
    }

    protected void executeAdd() {
        final Pattern pattern = this.getPattern();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                PatternParameter newPatternParameter = PatternFactory.eINSTANCE.createPatternParameter();
                newPatternParameter.setName(SpecificationPage.PARAMETER_NAME_DEFAULT_VALUE);
                newPatternParameter.setType(SpecificationPage.PARAMETER_TYPE_DEFAULT_VALUE);
                pattern.getParameters().add((Object)newPatternParameter);
                PatternUIHelper.addAdapterForNewItem(SpecificationPage.this.parametersViewer, newPatternParameter);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
        EList allParameters = pattern.getAllParameters();
        int len = allParameters.size();
        this.parametersViewer.getTable().setSelection(len - 1);
        this.setButtonsStatus();
    }

    private void executeUpOrDown(int num) {
        int oldIndex = this.parametersViewer.getTable().getSelectionIndex();
        int newIndex = oldIndex + num;
        EList allParameters = this.getPattern().getAllParameters();
        BasicEList allParametersNew = new BasicEList();
        int i = 0;
        while (i < allParameters.size()) {
            if (i == newIndex) {
                allParametersNew.add((Object)((PatternParameter)allParameters.get(oldIndex)));
            } else if (i == oldIndex) {
                allParametersNew.add((Object)((PatternParameter)allParameters.get(newIndex)));
            } else {
                allParametersNew.add((Object)((PatternParameter)allParameters.get(i)));
            }
            ++i;
        }
        this.updateAllParameters((BasicEList<PatternParameter>)allParametersNew);
        this.parametersViewer.getTable().setSelection(newIndex);
        this.setButtonsStatus();
    }

    private void updateAllParameters(final BasicEList<PatternParameter> allParametersNew) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                SpecificationPage.this.getPattern().getParameters().removeAll((Collection)SpecificationPage.this.getPattern().getParameters());
                SpecificationPage.this.getPattern().getParameters().addAll((Collection)allParametersNew);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    private void initTableEditor() {
        this.parametersViewer.setColumnProperties(new String[]{NAME_COLUMN_ID, TYPE_COLUMN_ID, QUERY_COLUMN_ID});
        this.nameEditor = new TextCellEditor((Composite)this.parametersViewer.getTable());
        this.typeEditor = new DialogCellEditor((Composite)this.parametersViewer.getTable()){

            protected Object openDialogBox(Control cellEditorWindow) {
                OpenTypeWizard wizard = new OpenTypeWizard(SpecificationPage.this.getSelectItemType(), (EObject)SpecificationPage.this.getPattern());
                wizard.init(PlatformUI.getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    Object object = wizard.getSelectType();
                    if (object instanceof IProxyEObject) {
                        SpecificationPage.this.updateType(((IProxyEObject)object).getURI().toString());
                    } else if (wizard.getSelectType() instanceof IType) {
                        SpecificationPage.this.updateType(((IType)object).getFullyQualifiedName());
                    }
                }
                return null;
            }
        };
        this.queryEditor = new ComboBoxViewerCellEditor((Composite)this.parametersViewer.getTable(), 0);
        this.queryEditor.setLabelProvider((IBaseLabelProvider)new ComboListLabelProvider());
        this.queryEditor.setContenProvider((IStructuredContentProvider)new CommonListContentProvider());
        this.setComboViewerInput();
        this.modifier = new ParametersTableCellModifier(this.getEditingDomain(), this.parametersViewer);
        this.changedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List availableQueries = IQuery.INSTANCE.getAvailableQueries();
                availableQueries.add(0, SpecificationPage.NO_QUERY_VALUE);
                SpecificationPage.this.queryEditor.setInput((Object)availableQueries);
            }
        };
        if (!this.isReadOnly()) {
            this.parametersViewer.addSelectionChangedListener(this.changedListener);
            this.parametersViewer.setCellModifier((ICellModifier)this.modifier);
            this.parametersViewer.setCellEditors(new CellEditor[]{this.nameEditor, this.typeEditor, this.queryEditor});
        }
    }

    private void updateType(final String selectType) {
        ISelection selection;
        Object selectItem;
        if (selectType != null && !NO_QUERY_VALUE.equals(selectType) && (selectItem = ((IStructuredSelection)(selection = this.parametersViewer.getSelection())).getFirstElement()) instanceof PatternParameter) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    ((PatternParameter)selectItem).setType(selectType);
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
            this.parametersViewer.refresh();
        }
    }

    private void setComboViewerInput() {
        List availableQueries = IQuery.INSTANCE.getAvailableQueries();
        availableQueries.add(0, NO_QUERY_VALUE);
        this.queryEditor.setInput((Object)availableQueries);
    }

    private String getSelectItemType() {
        int selectionIndex = this.parametersViewer.getTable().getSelectionIndex();
        Object selectItem = this.parametersViewer.getElementAt(selectionIndex);
        if (selectItem instanceof PatternParameter) {
            return ((PatternParameter)selectItem).getType();
        }
        return NO_QUERY_VALUE;
    }

    @Override
    protected void bind() {
        if (this.getPattern() != null) {
            this.bindParent();
            this.bindNature();
            this.bindTableViewer();
            this.parameterNameEmptyValidationAdapter = PatternUIHelper.addValidationAdapter(this.messageManager, this.getPattern(), "org.eclipse.egf.pattern.ui.PatternParameterNameNotEmpty", (Control)this.parametersViewer.getTable());
        }
        this.checkReadOnlyModel();
    }

    protected void bindParent() {
        IEMFEditValueProperty mprop = EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)PatternPackage.Literals.PATTERN__SUPER_PATTERN);
        IWidgetValueProperty textProp = WidgetProperties.text();
        ISWTObservableValue uiObs = textProp.observeDelayed(400, (Widget)this.parentLink);
        IObservableValue mObs = mprop.observe((Object)this.getPattern());
        UpdateValueStrategy targetToModel = new EMFUpdateValueStrategy().setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                return Status.OK_STATUS;
            }
        });
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter(new IConverter(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return EReference.class;
            }

            public Object convert(Object fromObject) {
                if (fromObject == null || !(fromObject instanceof Pattern)) {
                    return Messages.SpecificationPage_No_parent;
                }
                return "<a>" + ((Pattern)fromObject).getName() + "</a>";
            }
        });
        this.addBinding(this.ctx.bindValue((IObservableValue)uiObs, mObs, targetToModel, modelToTarget));
    }

    protected void bindNature() {
        IEMFEditValueProperty mprop = EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)PatternPackage.Literals.PATTERN__NATURE);
        IWidgetValueProperty comboProp = WidgetProperties.selection();
        ISWTObservableValue uiObs = comboProp.observeDelayed(400, (Widget)this.natureCombo);
        IObservableValue mObs = mprop.observe((Object)this.getPattern());
        EMFUpdateValueStrategy targetToModel = new EMFUpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                IStatus status = super.doSet(observableValue, value);
                if (status.isOK()) {
                    SpecificationPage.this.updateNature();
                }
                return status;
            }
        };
        targetToModel.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                SpecificationPage.this.updateNature();
                return Status.OK_STATUS;
            }
        });
        targetToModel.setConverter(new IConverter(){

            public Object getToType() {
                return EReference.class;
            }

            public Object getFromType() {
                return String.class;
            }

            public Object convert(Object fromObject) {
                if (fromObject.equals(ExtensionHelper.getName((PatternNature)SpecificationPage.this.getPattern().getNature()))) {
                    return SpecificationPage.this.getPattern().getNature();
                }
                return ExtensionHelper.createNature((String)((String)fromObject));
            }
        });
        targetToModel = targetToModel.setAfterGetValidator(new IValidator(){

            public IStatus validate(Object value) {
                if (SpecificationPage.this.getPattern().getNature() == null) {
                    return Status.OK_STATUS;
                }
                String currentNature = ExtensionHelper.getName((PatternNature)SpecificationPage.this.getPattern().getNature());
                if (value == null) {
                    SpecificationPage.this.natureCombo.setText(currentNature);
                    return Status.CANCEL_STATUS;
                }
                if (value.equals(currentNature)) {
                    return Status.CANCEL_STATUS;
                }
                if (MessageDialog.openQuestion((Shell)SpecificationPage.this.getPartControl().getShell(), (String)Messages.SpecificationPage_change_nature_title, (String)Messages.SpecificationPage_change_nature_type)) {
                    return Status.OK_STATUS;
                }
                SpecificationPage.this.natureCombo.setText(currentNature);
                return Status.CANCEL_STATUS;
            }
        });
        EMFUpdateValueStrategy modelToTarget = new EMFUpdateValueStrategy();
        modelToTarget.setAfterGetValidator(new IValidator(){

            public IStatus validate(Object value) {
                if (value == null || !(value instanceof PatternNature)) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        });
        modelToTarget.setConverter(new IConverter(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return EReference.class;
            }

            public Object convert(Object fromObject) {
                return ExtensionHelper.getName((PatternNature)((PatternNature)fromObject));
            }
        });
        this.addBinding(this.ctx.bindValue((IObservableValue)uiObs, mObs, (UpdateValueStrategy)targetToModel, (UpdateValueStrategy)modelToTarget));
    }

    private void bindTableViewer() {
        Pattern pattern = this.getPattern();
        if (pattern != null && this.parametersViewer != null) {
            IEMFListProperty input = EMFProperties.list((EStructuralFeature)PatternPackage.Literals.PATTERN__PARAMETERS);
            IObservableList observe = input.observe((Object)pattern);
            this.parametersViewer.setInput((Object)observe);
        }
    }

    public Pattern getParentPattern() {
        return this.getPattern() != null ? this.getPattern().getSuperPattern() : null;
    }

    public void dispose() {
        PatternUIHelper.removeAdapterForPattern(this.getPattern(), (AdapterImpl)this.parameterNameEmptyValidationAdapter);
        this.colors.dispose();
        super.dispose();
    }
}

