/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.preferences;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.ActivityExplorerEditor;
import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.extension.point.manager.ActivityExplorerExtensionManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.preferences.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormText;

public class ActivityExplorerSelectionBlock {
    private LabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private ICheckStateProvider checkStateProvider;
    public Controller controller;
    private static final Pattern P_FORM = Pattern.compile("<form>.*</form>");
    private final Map<String, Boolean> deferredPreferencesValues = new HashMap<String, Boolean>();
    private CheckboxTreeViewer treeArea;
    private CheckboxTableViewer listArea;
    private FormText detailsArea;

    public ActivityExplorerSelectionBlock() {
        this.labelProvider = new ExtensionLabelProvider();
        this.contentProvider = new ExtensionTreeContentProvider();
        this.checkStateProvider = new CheckStateProvider();
    }

    public Composite createWidget(Composite parent) {
        SashForm result = new SashForm(parent, 512);
        result.setFont(parent.getFont());
        SashForm topPart = new SashForm((Composite)result, 256);
        this.createTreeViewer((Composite)topPart);
        this.createPageListViewer((Composite)topPart);
        this.createDetailsView(result);
        return result;
    }

    public void performOk() {
        HashSet<String> propertyPages = new HashSet<String>();
        for (String id : this.deferredPreferencesValues.keySet()) {
            if (ActivityExplorerExtensionManager.isPage(id)) {
                propertyPages.add(id);
                continue;
            }
            ActivityExplorerActivator.getDefault().getPreferenceStore().setValue(id, this.deferredPreferencesValues.get(id).booleanValue());
        }
        for (String propertyPage : propertyPages) {
            ActivityExplorerActivator.getDefault().getPreferenceStore().setValue(propertyPage, this.deferredPreferencesValues.get(propertyPage).booleanValue());
        }
        this.deferredPreferencesValues.clear();
    }

    private void createDetailsView(SashForm parent) {
        this.detailsArea = new FormText((Composite)parent, 2560);
        this.detailsArea.setText("", false, true);
        Display d = Display.getCurrent();
        if (d != null) {
            this.detailsArea.setBackground(d.getSystemColor(1));
        }
    }

    private void createPageListViewer(Composite parent) {
        Composite form = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        form.setLayout((Layout)layout);
        Label prompt = new Label(form, 0);
        prompt.setText(Messages.ActivityExplorerSelectionBlock_0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        prompt.setLayoutData((Object)data);
        this.listArea = CheckboxTableViewer.newCheckList((Composite)form, (int)2048);
        data = new FormData();
        data.top = new FormAttachment((Control)prompt, 4);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.listArea.getControl().setLayoutData((Object)data);
        this.listArea.setContentProvider((IContentProvider)this.contentProvider);
        this.listArea.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listArea.addSelectionChangedListener((ISelectionChangedListener)this.getInstance());
        this.listArea.addCheckStateListener((ICheckStateListener)this.getInstance());
        this.listArea.setCheckStateProvider(this.checkStateProvider);
    }

    private void createTreeViewer(Composite parent) {
        Composite form = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        form.setLayout((Layout)layout);
        Label prompt = new Label(form, 0);
        prompt.setText(Messages.ActivityExplorerSelectionBlock_1);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        prompt.setLayoutData((Object)data);
        this.treeArea = new CheckboxTreeViewer(form);
        data = new FormData();
        data.top = new FormAttachment((Control)prompt, 4);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.treeArea.getControl().setLayoutData((Object)data);
        this.treeArea.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeArea.setContentProvider((IContentProvider)this.contentProvider);
        this.treeArea.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IConfigurationElement && !ActivityExplorerExtensionManager.getIndex((IConfigurationElement)element).equals("0");
            }
        });
        this.treeArea.setInput((Object)ActivityExplorerExtensionManager.getExtensionPoint("org.eclipse.amalgam.explorer.activity.ui.pagesProvider"));
        this.treeArea.addSelectionChangedListener((ISelectionChangedListener)this.getInstance());
        this.treeArea.addCheckStateListener((ICheckStateListener)this.getInstance());
        this.treeArea.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IConfigurationElement elt;
                IStructuredSelection selection;
                Object obj;
                ISelection iselection = event.getSelection();
                if (iselection instanceof IStructuredSelection && (obj = (selection = (IStructuredSelection)iselection).getFirstElement()) instanceof IConfigurationElement && (elt = (IConfigurationElement)obj).getName().equals("Page")) {
                    IFormPage page;
                    String id = ActivityExplorerExtensionManager.getId(elt);
                    ActivityExplorerEditor editor = ActivityExplorerManager.INSTANCE.getEditor();
                    if (editor != null && (page = editor.findPage(id)) != null) {
                        ActivityExplorerManager.INSTANCE.getEditor().setActivePage(id);
                    }
                }
            }
        });
        this.treeArea.setCheckStateProvider(this.checkStateProvider);
    }

    public Viewer getTreeViewer() {
        return this.treeArea;
    }

    public Viewer getTableViewer() {
        return this.listArea;
    }

    private Controller getInstance() {
        if (this.controller == null) {
            this.controller = new Controller();
        }
        return this.controller;
    }

    private class CheckStateProvider
    implements ICheckStateProvider {
        private CheckStateProvider() {
        }

        public boolean isGrayed(Object element) {
            return false;
        }

        public boolean isChecked(Object element) {
            boolean value = false;
            IConfigurationElement elt = (IConfigurationElement)element;
            String id = ActivityExplorerExtensionManager.getId(elt);
            if (ActivityExplorerSelectionBlock.this.deferredPreferencesValues.containsKey(id)) {
                return ActivityExplorerSelectionBlock.this.deferredPreferencesValues.get(id);
            }
            IPreferenceStore prefs = ActivityExplorerActivator.getDefault().getPreferenceStore();
            value = prefs.getBoolean(id);
            return value;
        }
    }

    public class Controller
    implements ISelectionChangedListener,
    ICheckStateListener {
        protected void setDefaultValue(Object element) {
            boolean defaultValue = ActivityExplorerActivator.getDefault().getPreferenceStore().getDefaultBoolean(ActivityExplorerExtensionManager.getId((IConfigurationElement)element));
            this.checkStateChanged(new CheckStateChangedEvent((ICheckable)ActivityExplorerSelectionBlock.this.getTableViewer(), element, defaultValue));
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            boolean checked = event.getChecked();
            ICheckable source = (ICheckable)event.getSource();
            if (element instanceof IConfigurationElement) {
                IConfigurationElement configElement = (IConfigurationElement)element;
                String configElementId = ActivityExplorerExtensionManager.getId(configElement);
                this.updateCheckedStateChildren(configElement, source, checked);
                ActivityExplorerSelectionBlock.this.deferredPreferencesValues.put(configElementId, checked);
                this.updateCheckedStateParent(configElement, source, checked);
                this.refreshVisual();
            }
        }

        private void refreshVisual() {
            ActivityExplorerSelectionBlock.this.treeArea.refresh();
            ActivityExplorerSelectionBlock.this.listArea.refresh();
        }

        private void updateCheckedStateChildren(IConfigurationElement elt, ICheckable source, boolean state) {
            ITreeContentProvider provider = (ITreeContentProvider)ActivityExplorerSelectionBlock.this.treeArea.getContentProvider();
            Object[] children = provider.getElements((Object)elt);
            if (children != null) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    this.checkStateChanged(new CheckStateChangedEvent(source, child, state));
                    ++n2;
                }
            }
        }

        private void updateCheckedStateParent(IConfigurationElement elt, ICheckable source, boolean state) {
            ITreeContentProvider provider = (ITreeContentProvider)ActivityExplorerSelectionBlock.this.treeArea.getContentProvider();
            Object parent = provider.getParent((Object)elt);
            if (parent != null && !(parent instanceof IExtension) && state) {
                IConfigurationElement p = (IConfigurationElement)parent;
                String id = ActivityExplorerExtensionManager.getId(p);
                ActivityExplorerSelectionBlock.this.deferredPreferencesValues.put(id, state);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            Object source = event.getSource();
            if (selection != null && selection instanceof IStructuredSelection) {
                String description;
                IStructuredSelection selected = (IStructuredSelection)selection;
                IConfigurationElement elt = (IConfigurationElement)selected.getFirstElement();
                if (source.equals(ActivityExplorerSelectionBlock.this.getTreeViewer())) {
                    ActivityExplorerSelectionBlock.this.listArea.setInput((Object)elt);
                }
                if ((description = ActivityExplorerExtensionManager.getDescription(elt)) == null) {
                    ActivityExplorerSelectionBlock.this.detailsArea.setText("", false, false);
                } else {
                    boolean isWellFormed = P_FORM.matcher(description).find();
                    if (isWellFormed) {
                        ActivityExplorerSelectionBlock.this.detailsArea.setText(description, true, false);
                    } else {
                        description = "<form>" + description + "</form>";
                        ActivityExplorerSelectionBlock.this.detailsArea.setText(description, true, false);
                    }
                }
            }
        }
    }

    private class ExtensionLabelProvider
    extends LabelProvider {
        private ExtensionLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IConfigurationElement) {
                IConfigurationElement elt = (IConfigurationElement)element;
                return ActivityExplorerExtensionManager.getName(elt);
            }
            return super.getText(element);
        }
    }

    private class ExtensionTreeContentProvider
    implements ITreeContentProvider {
        private ExtensionTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IExtensionPoint) {
                return ActivityExplorerExtensionManager.getAllProviderExtensions();
            }
            if (parentElement instanceof IConfigurationElement) {
                String category = "Section";
                IConfigurationElement elt = (IConfigurationElement)parentElement;
                if (elt.getName().equals("Page")) {
                    category = "Section";
                    List<IConfigurationElement> result = ActivityExplorerExtensionManager.getAllSectionsExtensionForPageId(ActivityExplorerExtensionManager.getId(elt));
                    result.addAll(Arrays.asList(elt.getChildren(category)));
                    return result.toArray();
                }
                if (elt.getName().equals("Section")) {
                    category = "Activity";
                    List<IConfigurationElement> result = ActivityExplorerExtensionManager.getAllActivitiesExtensionForSectionId(ActivityExplorerExtensionManager.getId(elt));
                    result.addAll(Arrays.asList(elt.getChildren(category)));
                    return result.toArray();
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            Object parent = null;
            if (element instanceof IExtensionPoint) {
                parent = (IExtensionPoint)element;
            }
            if (element instanceof IConfigurationElement) {
                parent = ((IConfigurationElement)element).getParent();
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IConfigurationElement) {
                IConfigurationElement elt = (IConfigurationElement)element;
                return elt.getName().equals("Page") && elt.getChildren().length > 0;
            }
            return false;
        }
    }
}

