/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data.command;

import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.command.RowDeleteCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowObjectDeleteEvent;

public class RowDeleteCommandHandler<T>
implements ILayerCommandHandler<RowDeleteCommand> {
    private List<T> bodyData;

    public RowDeleteCommandHandler(List<T> bodyData) {
        this.bodyData = bodyData;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, RowDeleteCommand command) {
        if (command.convertToTargetLayer(targetLayer)) {
            int[] positions = command.getRowPositionsArray();
            HashMap<Integer, T> deleted = new HashMap<Integer, T>();
            int i = positions.length - 1;
            while (i >= 0) {
                int pos = positions[i];
                deleted.put(pos, this.bodyData.remove(pos));
                --i;
            }
            targetLayer.fireLayerEvent(new RowObjectDeleteEvent(targetLayer, deleted));
            return true;
        }
        return false;
    }

    @Override
    public Class<RowDeleteCommand> getCommandClass() {
        return RowDeleteCommand.class;
    }
}

