/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.sirius.rotativeimage.internal.helpers;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.polarsys.kitalpha.sirius.rotativeimage.Activator;

public class RotativeWorkspaceImageHelper {
    private static HashMap<String, String> IMAGE_PATHS_CACHE = new HashMap();

    private RotativeWorkspaceImageHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Image getImage(String path, int orientation) {
        String key = RotativeWorkspaceImageHelper.getKey(path, orientation);
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(key);
        if (image != null) {
            return image;
        }
        switch (orientation) {
            case 4: 
            case 8: 
            case 16: {
                image = RotativeWorkspaceImageHelper.rotate(RotativeWorkspaceImageHelper.getImage(path, 1), orientation);
                break;
            }
            default: {
                image = WorkspaceImageFigure.getImageInstanceFromPath((String)path);
            }
        }
        if (image != null) {
            registry.put(key, image);
        }
        return image;
    }

    public static Rectangle rotateRectangle(Rectangle rect, int orientation) {
        switch (orientation) {
            case 8: 
            case 16: {
                return rect.transpose();
            }
        }
        return rect;
    }

    public static String get4ImagesDocumentKey(String path, int orientation) {
        String result = IMAGE_PATHS_CACHE.get(String.valueOf(path) + orientation);
        if (result == null) {
            result = RotativeWorkspaceImageHelper.getImageURI(RotativeWorkspaceImageHelper.getOrientedPath(path, orientation));
            if (result == null) {
                result = RotativeWorkspaceImageHelper.getImageURI(path);
            }
            IMAGE_PATHS_CACHE.put(String.valueOf(path) + orientation, result);
        }
        return result;
    }

    public static String getOrientedPath(String path, int orientation) {
        int extentionPosition = path.lastIndexOf(".");
        String baseName = path.substring(0, extentionPosition);
        String ext = path.substring(extentionPosition);
        switch (orientation) {
            case 1: {
                baseName = String.valueOf(baseName) + "_top";
                break;
            }
            case 4: {
                baseName = String.valueOf(baseName) + "_bottom";
                break;
            }
            case 8: {
                baseName = String.valueOf(baseName) + "_left";
                break;
            }
            case 16: {
                baseName = String.valueOf(baseName) + "_right";
            }
        }
        return String.valueOf(baseName) + ext;
    }

    private static String getImageURI(String basepath) {
        File imageFile = FileProvider.getDefault().getFile((IPath)new Path(basepath));
        if (imageFile != null) {
            return imageFile.toURI().toString();
        }
        return null;
    }

    public static void createImage(String mainPath, int orientation) {
        String key = RotativeWorkspaceImageHelper.getKey(mainPath, orientation);
        String orientedPath = RotativeWorkspaceImageHelper.getOrientedPath(mainPath, orientation);
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(key);
        if (image == null) {
            image = WorkspaceImageFigure.flyWeightImage((String)orientedPath);
            registry.put(key, image);
        }
    }

    public static Image rotate(Image image, int orientation) {
        if (image == null) {
            return null;
        }
        ImageData srcData = image.getImageData();
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        byte[] newData = new byte[srcData.data.length];
        boolean isAlpha = srcData.alphaData != null;
        byte[] newAlphaData = null;
        int destBytesPerLine = 0;
        ImageData imgData = null;
        switch (orientation) {
            case 8: 
            case 16: {
                destBytesPerLine = srcData.height * bytesPerPixel;
                imgData = new ImageData(srcData.height, srcData.width, srcData.depth, srcData.palette, destBytesPerLine, newData);
                break;
            }
            default: {
                destBytesPerLine = srcData.width * bytesPerPixel;
                imgData = new ImageData(srcData.width, srcData.height, srcData.depth, srcData.palette, destBytesPerLine, newData);
            }
        }
        if (isAlpha) {
            newAlphaData = new byte[srcData.alphaData.length];
            imgData.alphaData = newAlphaData;
        }
        imgData.alpha = srcData.alpha;
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destY;
                int destX;
                switch (orientation) {
                    case 8: {
                        destX = srcY;
                        destY = srcData.width - srcX - 1;
                        break;
                    }
                    case 16: {
                        destX = srcData.height - srcY - 1;
                        destY = srcX;
                        break;
                    }
                    case 4: {
                        destX = srcData.width - srcX - 1;
                        destY = srcData.height - srcY - 1;
                        break;
                    }
                    default: {
                        destX = srcX;
                        destY = srcY;
                    }
                }
                imgData.setPixel(destX, destY, srcData.getPixel(srcX, srcY));
                if (isAlpha) {
                    imgData.setAlpha(destX, destY, srcData.getAlpha(srcX, srcY));
                }
                ++srcX;
            }
            ++srcY;
        }
        return new Image(image.getDevice(), imgData);
    }

    private static String getKey(String path, int orientation) {
        return String.valueOf(path) + orientation;
    }
}

