/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.InvalidPathException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.FilterableNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

class FilterCache {
    public static final FilterCache INSTANCE = new FilterCache();
    private static final String TAG_REPO = "repo";
    private static final String ATTR_DIR = "dir";
    private static final String TAG_FILTER = "filter";
    private static final String ATTR_NODE = "tag";
    private static final String ATTR_FILTER = "filter";
    private final Map<File, Map<RepositoryTreeNodeType, String>> cache = new ConcurrentHashMap<File, Map<RepositoryTreeNodeType, String>>();

    private FilterCache() {
    }

    public void set(FilterableNode node, String filter) {
        Map map = this.cache.computeIfAbsent(node.getRepository().getDirectory(), k -> new ConcurrentHashMap());
        if (filter == null) {
            map.remove((Object)node.getType());
        } else {
            map.put(node.getType(), filter);
        }
        node.setFilter(filter);
    }

    public String get(FilterableNode node) {
        Map<RepositoryTreeNodeType, String> filters = this.cache.get(node.getRepository().getDirectory());
        return filters == null ? null : filters.get((Object)node.getType());
    }

    public void keepOnly(Collection<File> gitDirs) {
        this.cache.keySet().retainAll(gitDirs);
    }

    public void load() {
        XMLMemento memento;
        String data = Activator.getDefault().getPreferenceStore().getString("repositories_view_filters");
        if (StringUtils.isEmptyOrNull((String)data)) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (StringReader reader = new StringReader(data);){
                memento = XMLMemento.createReadRoot((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (WorkbenchException e) {
            Activator.logError(UIText.RepositoriesView_FilterErrorRead, e);
            return;
        }
        RepositoryUtil util = RepositoryUtil.getInstance();
        IMemento[] iMementoArray = memento.getChildren(TAG_REPO);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            block22: {
                IMemento repo = iMementoArray[n2];
                String repoId = repo.getString(ATTR_DIR);
                if (repoId != null && !repoId.isEmpty()) {
                    try {
                        repoId = util.getAbsoluteRepositoryPath(repoId);
                    }
                    catch (InvalidPathException e) {
                        break block22;
                    }
                    ConcurrentHashMap<RepositoryTreeNodeType, String> values = new ConcurrentHashMap<RepositoryTreeNodeType, String>();
                    IMemento[] iMementoArray2 = repo.getChildren("filter");
                    int n3 = iMementoArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block23: {
                            String filter;
                            IMemento entry = iMementoArray2[n4];
                            String tag = entry.getString(ATTR_NODE);
                            if (!StringUtils.isEmptyOrNull((String)tag) && !StringUtils.isEmptyOrNull((String)(filter = entry.getString("filter")))) {
                                RepositoryTreeNodeType type = null;
                                try {
                                    type = RepositoryTreeNodeType.valueOf(tag);
                                }
                                catch (RuntimeException e) {
                                    break block23;
                                }
                                values.put(type, filter);
                            }
                        }
                        ++n4;
                    }
                    if (!values.isEmpty()) {
                        this.cache.put(new File(repoId), values);
                    }
                }
            }
            ++n2;
        }
    }

    public void save() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)this.getClass().getSimpleName());
        RepositoryUtil util = RepositoryUtil.getInstance();
        this.cache.entrySet().stream().forEach(entry -> {
            Map values = (Map)entry.getValue();
            if (values.isEmpty()) {
                return;
            }
            IMemento repo = memento.createChild(TAG_REPO);
            String path = ((File)entry.getKey()).getAbsolutePath();
            assert (path != null);
            repo.putString(ATTR_DIR, util.relativizeToWorkspace(path));
            values.entrySet().stream().forEach(e -> {
                String filter = (String)e.getValue();
                if (StringUtils.isEmptyOrNull((String)filter)) {
                    return;
                }
                IMemento child = repo.createChild("filter");
                child.putString(ATTR_NODE, ((RepositoryTreeNodeType)((Object)((Object)((Object)e.getKey())))).name());
                child.putString("filter", filter);
            });
        });
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StringWriter writer = new StringWriter();){
                memento.save((Writer)writer);
                Activator.getDefault().getPreferenceStore().setValue("repositories_view_filters", writer.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logError(UIText.RepositoriesView_FilterErrorSave, e);
        }
    }
}

