/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views.editing;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.AbstractStringEditingSupport;

public class ComboStringEditingSupport
extends AbstractStringEditingSupport {
    private ComboBoxCellEditor cellEditor;
    private String[] initialItems = new String[0];

    public ComboStringEditingSupport(TableViewer viewer, Class<?> candidate, String propertyName) {
        super((ColumnViewer)viewer, candidate, propertyName);
        this.cellEditor = new ComboBoxCellEditor((Composite)viewer.getTable(), this.initialItems, 0);
    }

    protected CellEditor getCellEditor(Object element) {
        String value = super.getValue(element).toString();
        ArrayList<String> strs = new ArrayList<String>();
        strs.addAll(Arrays.asList(this.initialItems));
        if (!strs.contains(value)) {
            strs.add(value);
            this.cellEditor.setItems(strs.toArray(new String[strs.size()]));
        }
        return this.cellEditor;
    }

    @Override
    protected Object getValue(Object element) {
        Object value = super.getValue(element);
        return Arrays.asList(this.cellEditor.getItems()).indexOf(value);
    }

    @Override
    protected final void doSetValue(Object element, Object value) {
        Integer value2 = (Integer)value;
        if (value2 >= 0) {
            String val = this.cellEditor.getItems()[value2];
            super.doSetValue(element, val);
        } else {
            CCombo combo = (CCombo)this.cellEditor.getControl();
            String text = combo.getText();
            super.doSetValue(element, text);
        }
    }

    public void setItems(String[] array) {
        this.initialItems = array;
        this.cellEditor.setItems(array);
    }
}

