/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ecore.diagram.service;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DSemanticDiagram;

public class EcoreService {
    public Collection<EClass> insertEClassSelectionWizard(EObject eObject, EObject containerView) {
        Collection<EClass> focusOnEClass = this.focusOnEClassSCE(eObject);
        DSemanticDiagram diagram = (DSemanticDiagram)containerView;
        Predicate<EObject> withEClassTarget = new Predicate<EObject>(){

            public boolean apply(EObject arg0) {
                if (arg0 instanceof DNodeList) {
                    DNodeList nodeList = (DNodeList)arg0;
                    EObject target = nodeList.getTarget();
                    return target != null && target instanceof EClass;
                }
                return false;
            }
        };
        UnmodifiableIterator filter = Iterators.filter((Iterator)diagram.eContents().iterator(), (Predicate)withEClassTarget);
        ArrayList availableTargets = Lists.newArrayList((Iterator)filter);
        for (EObject target : availableTargets) {
            DNodeList dNodeList = (DNodeList)target;
            focusOnEClass.remove(dNodeList.getTarget());
        }
        return focusOnEClass;
    }

    public Collection<EClass> focusOnEClassSCE(EObject eObject) {
        EPackage ePackage = (EPackage)eObject;
        UniqueEList result = new UniqueEList();
        UnmodifiableIterator eClasses = Iterators.filter((Iterator)ePackage.eContents().iterator(), EClass.class);
        while (eClasses.hasNext()) {
            EClass curentEClass = (EClass)eClasses.next();
            result.add((Object)curentEClass);
            EList eAllOperations = curentEClass.getEAllOperations();
            for (EOperation eOperation : eAllOperations) {
                if (!(eOperation.getEType() instanceof EClass)) continue;
                result.add((Object)((EClass)eOperation.getEType()));
            }
        }
        List<EClass> handleReferencedEClasses1 = this.handleReferencedEClasses((EList<EClass>)result);
        result.addAll(handleReferencedEClasses1);
        List<EClass> handleReferencedEClasses2 = this.handleReferencedEClasses((EList<EClass>)result);
        result.addAll(handleReferencedEClasses2);
        List<EClass> handleReferencedEClasses3 = this.handleReferencedEClasses((EList<EClass>)result);
        result.addAll(handleReferencedEClasses3);
        UniqueEList toAdd = new UniqueEList();
        for (EClass eClass : result) {
            EPackage eClassPackage;
            EList eClassifiers;
            EList eAllSuperTypes = eClass.getEAllSuperTypes();
            if (!eAllSuperTypes.isEmpty()) {
                toAdd.addAll(eAllSuperTypes);
            }
            if (eClass.eIsProxy()) {
                URI uri = EcoreUtil.getURI((EObject)eClass);
                URI new_uri = uri.trimFragment();
                eObject.eResource().getResourceSet().getResource(new_uri, true);
                eClass = (EClass)eObject.eResource().getResourceSet().getEObject(uri, true);
            }
            if ((eClassifiers = (eClassPackage = eClass.getEPackage()).getEClassifiers()).isEmpty()) continue;
            UnmodifiableIterator filter = Iterators.filter((Iterator)eClassifiers.iterator(), EClass.class);
            toAdd.addAll(Lists.newArrayList((Iterator)filter));
        }
        result.addAll((Collection)toAdd);
        return result;
    }

    public Collection<EEnum> focusOnEENumSCE(EObject eObject) {
        UniqueEList result = new UniqueEList();
        Collection<EClass> focusOnEClass = this.focusOnEClassSCE(eObject);
        for (EClass eClass : focusOnEClass) {
            EPackage ePackage = eClass.getEPackage();
            UnmodifiableIterator ePackageEEnum = Iterators.filter((Iterator)ePackage.eContents().iterator(), EEnum.class);
            ArrayList eEnums = Lists.newArrayList((Iterator)ePackageEEnum);
            result.addAll(eEnums);
        }
        return result;
    }

    public Collection<EEnum> insertEEnumSelectionWizard(EPackage eObject, DSemanticDiagram containerView) {
        Collection<EEnum> focusOnEEnum = this.focusOnEENumSCE((EObject)eObject);
        DSemanticDiagram diagram = containerView;
        Predicate<EObject> withEEnumTarget = new Predicate<EObject>(){

            public boolean apply(EObject arg0) {
                if (arg0 instanceof DNodeList) {
                    DNodeList nodeList = (DNodeList)arg0;
                    EObject target = nodeList.getTarget();
                    return target != null && target instanceof EEnum;
                }
                return false;
            }
        };
        UnmodifiableIterator filter = Iterators.filter((Iterator)diagram.eContents().iterator(), (Predicate)withEEnumTarget);
        ArrayList availableTargets = Lists.newArrayList((Iterator)filter);
        for (EObject target : availableTargets) {
            DNodeList dNodeList = (DNodeList)target;
            focusOnEEnum.remove(dNodeList.getTarget());
        }
        return focusOnEEnum;
    }

    private List<EClass> handleReferencedEClasses(EList<EClass> eClasses) {
        UniqueEList result = new UniqueEList();
        for (EClass eClass : eClasses) {
            UnmodifiableIterator references = Iterators.filter((Iterator)eClass.getEAllStructuralFeatures().iterator(), EReference.class);
            while (references.hasNext()) {
                EReference eReference = (EReference)references.next();
                if (eReference.getEType() == null) continue;
                result.add((EClass)eReference.getEType());
            }
            EList eAllOperations = eClass.getEAllOperations();
            if (eAllOperations == null || eAllOperations.size() <= 0) continue;
            for (EOperation eOperation : eAllOperations) {
                if (eOperation.getEType() == null || !(eOperation.getEType() instanceof EClass)) continue;
                result.add((EClass)eOperation.getEType());
            }
        }
        return result;
    }

    public Collection<EOperation> findAllEOperation(EClass eClass) {
        ArrayList<EOperation> local = new ArrayList<EOperation>((Collection<EOperation>)eClass.getEAllOperations());
        Collections.sort(local, new MyEOperationComparator());
        return local;
    }

    public boolean isImplemented(EClass subClass, DEdge dEdge) {
        if (dEdge != null && dEdge.getTargetNode() != null) {
            EClass parentClass = (EClass)((DDiagramElement)dEdge.getTargetNode()).getTarget();
            return this.isImplemented(subClass, parentClass);
        }
        return false;
    }

    private boolean isImplemented(EClass subClass, EClass parentClass) {
        if (subClass != null && parentClass != null) {
            EList sp = subClass.getESuperTypes();
            if (sp != null && sp.size() > 0) {
                EClass firstSP = (EClass)subClass.getESuperTypes().get(0);
                if (firstSP != null) {
                    if (firstSP.equals(parentClass)) {
                        return true;
                    }
                    return this.isImplemented(firstSP, parentClass);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public Collection<EClass> superTypesLabel(EClass source, EClass destination) {
        if (source != null && destination != null) {
            UniqueEList result = new UniqueEList();
            for (EClass sp : source.getEAllSuperTypes()) {
                if (!sp.getEAllSuperTypes().contains((Object)destination)) continue;
                result.add(sp);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public Collection<EClass> nearestSuperTypes(EObject root, Collection<EObject> nodeList) {
        if (root instanceof EClass) {
            EClass rootClass = (EClass)root;
            Collection<EClass> eClassList = this.filter(nodeList);
            UniqueEList superTypes = new UniqueEList((Collection)rootClass.getEAllSuperTypes());
            superTypes.retainAll(eClassList);
            if (superTypes.size() <= 1) {
                return superTypes;
            }
            return this.nearestSuperTypes((Collection<EClass>)superTypes);
        }
        return Collections.emptyList();
    }

    private Collection<EClass> nearestSuperTypes(Collection<EClass> superTypes) {
        MyEClassComparator myComparator = new MyEClassComparator();
        ArrayList<Object> local = new ArrayList<EClass>(superTypes);
        Collections.sort(local, myComparator);
        EClass first = (EClass)local.get(0);
        UniqueEList result = new UniqueEList();
        for (EClass eClass : local) {
            if (myComparator.compare(first, eClass) != 0) continue;
            result.add(eClass);
        }
        if (result.size() > 0) {
            local = new ArrayList();
            for (EClass eClass : result) {
                for (EClass y : result) {
                    if (myComparator.compare(eClass, y) >= 0) continue;
                    local.add(y);
                }
            }
            result.removeAll(local);
            return result;
        }
        return Collections.emptyList();
    }

    public Collection<EReference> focusedEReferences(EReference eReference, Collection<EObject> nodeList) {
        EPackage ePackage = eReference.getEContainingClass().getEPackage();
        return this.focusedEReferences(ePackage, nodeList);
    }

    public Collection<EReference> focusedEReferences(EPackage ePackage, Collection<EObject> nodeList) {
        Collection<EClass> eClassList = this.filter(nodeList);
        UniqueEList potentialNodes = new UniqueEList(eClassList);
        for (EObject eObject : eClassList) {
            potentialNodes.addAll(((EClass)eObject).getEAllSuperTypes());
        }
        UniqueEList uniqueEList = new UniqueEList();
        for (EClass o : potentialNodes) {
            uniqueEList.addAll(o.getEReferences());
        }
        return uniqueEList;
    }

    public String computeEReferenceLabel(EReference eReference, Collection<EObject> nodeList) {
        StringBuilder s = new StringBuilder();
        s.append(eReference.getName());
        EObject source = eReference.eContainer();
        if (source instanceof EClass && !nodeList.contains(source)) {
            s.append(" : ");
            s.append(((EClass)source).getName());
        }
        return s.toString();
    }

    public Collection<EAttribute> findAllEAtribute(EClass eClass) {
        ArrayList<EAttribute> local = new ArrayList<EAttribute>((Collection<EAttribute>)eClass.getEAllAttributes());
        Collections.sort(local, new MyEAttributeComparator());
        return local;
    }

    public boolean hasNotDisplayedSuperType(EClass eClass, EObject parent, Collection<EObject> nodeList) {
        if (eClass != null) {
            return this.mostAbstractObject(eClass, nodeList).contains(parent);
        }
        return false;
    }

    public Collection<EClass> mostAbstractObject(EReference eReference, Collection<EObject> nodeList) {
        EClass containerClass = eReference.getEContainingClass();
        return this.mostAbstractObject(containerClass, nodeList);
    }

    public Collection<EClass> mostAbstractObject(EClass root, Collection<EObject> nodeList) {
        Collection<EClass> eClassList = this.filter(nodeList);
        UniqueEList result = new UniqueEList();
        if (eClassList.contains(root)) {
            result.add(root);
            return result;
        }
        UniqueEList potentialList = new UniqueEList();
        for (EClass node : eClassList) {
            if (!node.getEAllSuperTypes().contains((Object)root)) continue;
            potentialList.add(node);
        }
        if (potentialList.size() < 2) {
            return potentialList;
        }
        Session session = SessionManager.INSTANCE.getSession((EObject)root);
        ECrossReferenceAdapter eCrossReferenceAdapter = session.getSemanticCrossReferencer();
        Collection<EClass> local = this.mostAbstractObject(root, (Collection<EClass>)potentialList, eCrossReferenceAdapter);
        return local;
    }

    private Collection<EClass> mostAbstractObject(EClass root, Collection<EClass> potentialList, ECrossReferenceAdapter eCrossReferenceAdapter) {
        UniqueEList result = new UniqueEList();
        Collection<EClass> collection = this.getDirectDescendants(root, eCrossReferenceAdapter);
        UniqueEList rest = new UniqueEList();
        for (EClass c : collection) {
            if (potentialList.contains(c)) {
                result.add(c);
                continue;
            }
            rest.add(c);
        }
        if (rest.size() == 0 && result.size() > 0) {
            return result;
        }
        potentialList.removeAll((Collection<?>)result);
        if (potentialList.size() > 0) {
            for (EClass c : rest) {
                result.addAll(this.mostAbstractObject(c, new ArrayList<EClass>(potentialList)));
            }
        }
        return result;
    }

    public Collection<EClass> getDirectDescendants(EClass eClass, ECrossReferenceAdapter eCrossReferenceAdapter) {
        Collection list = eCrossReferenceAdapter.getInverseReferences((EObject)eClass, true);
        if (list != null && list.size() > 0) {
            UniqueEList result = new UniqueEList();
            for (EStructuralFeature.Setting s : list) {
                if (!EcorePackage.Literals.ECLASS__ESUPER_TYPES.equals(s.getEStructuralFeature())) continue;
                EClass e = (EClass)s.getEObject();
                result.add(e);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private Collection<EClass> filter(Collection<EObject> collection) {
        UniqueEList result = new UniqueEList();
        for (EObject o : collection) {
            if (!(o instanceof EClass)) continue;
            result.add((EClass)o);
        }
        return result;
    }

    public static class MyEAttributeComparator
    implements Comparator<EAttribute> {
        public static MyEClassComparator myEClassComparator = new MyEClassComparator();

        @Override
        public int compare(EAttribute o1, EAttribute o2) {
            return myEClassComparator.compare((EClass)o1.eContainer(), (EClass)o2.eContainer());
        }
    }

    public static class MyEClassComparator
    implements Comparator<EClass> {
        @Override
        public int compare(EClass o1, EClass o2) {
            if (o1.getEAllSuperTypes().contains((Object)o2)) {
                return -1;
            }
            if (o2.getEAllSuperTypes().contains((Object)o1)) {
                return 1;
            }
            return 0;
        }
    }

    public static class MyEOperationComparator
    implements Comparator<EOperation> {
        public static MyEClassComparator myEClassComparator = new MyEClassComparator();

        @Override
        public int compare(EOperation o1, EOperation o2) {
            return myEClassComparator.compare((EClass)o1.eContainer(), (EClass)o2.eContainer());
        }
    }
}

