/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.genchain.tools.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.egf.portfolio.genchain.extension.ExtensionHelper;
import org.eclipse.egf.portfolio.genchain.extension.ExtensionProperties;
import org.eclipse.egf.portfolio.genchain.generationChain.EcoreElement;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.tools.ui.Messages;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.Node;

public class GenerationChainFactory
implements ExtensionProperties {
    public static final GenerationChainFactory INSTANCE = new GenerationChainFactory();

    public void createExtension(GenerationChain container, Node containerNode, Set<Node> activeNodes) {
        Map extensionsAsMap = ExtensionHelper.getExtensionsAsMap();
        for (Node extensionNode : containerNode.getChildren()) {
            String id = extensionNode.getProperties().get("id");
            String modelName = GenerationChainFactory.getModelName(extensionNode.getProperties().get("model.path"));
            ExtensionHelper extensionHelper = (ExtensionHelper)extensionsAsMap.get(id);
            if (!activeNodes.contains(extensionNode)) continue;
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Node propertyNode : extensionNode.getChildren()) {
                properties.put(propertyNode.getName(), propertyNode.getProperties().get("property.value"));
            }
            properties.putAll(extensionNode.getProperties());
            EcoreElement leaf = extensionHelper.createEcoreElement(properties);
            leaf.setName(Messages.bind((String)Messages.genchain_wizard_element_name_creation, (Object)extensionNode.getName(), (Object)modelName));
            container.getElements().add((Object)leaf);
        }
    }

    public void createContainer(GenerationChain root, Node data, Set<Node> activeNodes) {
        for (Node containerNode : data.getChildren()) {
            GenerationChain container = org.eclipse.egf.portfolio.genchain.generationChain.GenerationChainFactory.eINSTANCE.createGenerationChain();
            container.setName(containerNode.getName());
            this.createExtension(container, containerNode, activeNodes);
            if (container.getElements().isEmpty()) continue;
            root.getElements().add((Object)container);
        }
    }

    public static String getBundleName(String modelPath) {
        return modelPath.substring(1, modelPath.indexOf(47, 1));
    }

    public static String getModelName(String modelPath) {
        return modelPath.substring(modelPath.lastIndexOf(47) + 1, modelPath.lastIndexOf(46));
    }
}

