/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.IQuickOutlineCallback;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.IQuickOutlineLabelProvider;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.QuickOutlineAdapterFactoryLabelProvider;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.QuickOutlineDescriptor;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.QuickOutlinePageDescriptor;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.SiriusInformationPresenter;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.SiriusInformationPresenterFactory;
import org.eclipse.sirius.editor.tools.internal.outline.VSMOutlineCallback;
import org.eclipse.sirius.editor.tools.internal.presentation.CustomSiriusEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class VSMQuickOutlineHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        CustomSiriusEditor editor = this.getCurrentEditor();
        Object root = this.getRoot(editor);
        if (root != null) {
            SiriusInformationPresenter presenter = SiriusInformationPresenterFactory.createInformationPresenter((Control)editor.getControl(), (QuickOutlineDescriptor)this.createDescriptor(editor), (Object)root);
            presenter.showInformation();
        }
        return null;
    }

    protected CustomSiriusEditor getCurrentEditor() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && window.getActivePage().getActiveEditor() instanceof CustomSiriusEditor) {
            return (CustomSiriusEditor)window.getActivePage().getActiveEditor();
        }
        return null;
    }

    private QuickOutlineDescriptor createDescriptor(CustomSiriusEditor editor) {
        ComposedAdapterFactory caf = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        QuickOutlineAdapterFactoryLabelProvider labelProvider = new QuickOutlineAdapterFactoryLabelProvider((AdapterFactory)caf);
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)caf);
        VSMOutlineCallback callBack = new VSMOutlineCallback(editor);
        QuickOutlinePageDescriptor page1 = new QuickOutlinePageDescriptor((IQuickOutlineCallback)callBack, (IQuickOutlineLabelProvider)labelProvider, (IContentProvider)contentProvider, "Quick Outline");
        QuickOutlineDescriptor descriptor = new QuickOutlineDescriptor();
        descriptor.addPage(page1);
        return descriptor;
    }

    private Object getRoot(CustomSiriusEditor editor) {
        Resource resource;
        ResourceSet rs;
        Object root = null;
        if (editor != null && editor.getEditingDomain() != null && (rs = editor.getEditingDomain().getResourceSet()) != null && rs.getResources() != null && (resource = (Resource)rs.getResources().get(0)) != null && resource.getContents() != null) {
            root = resource.getContents().get(0);
        }
        return root;
    }
}

