/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class ResourcesSelectionDialog
extends FilteredResourcesSelectionDialog {
    private final String fileExtension;

    public ResourcesSelectionDialog(Shell shell, boolean multi, IContainer container, int typesMask, String fileExtension) {
        super(shell, multi, container, typesMask);
        this.fileExtension = fileExtension == null ? "" : fileExtension.toLowerCase();
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ResourceExtensionFilter();
    }

    protected class ResourceExtensionFilter
    extends FilteredResourcesSelectionDialog.ResourceFilter {
        protected ResourceExtensionFilter() {
            super((FilteredResourcesSelectionDialog)ResourcesSelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            boolean match = super.matchItem(item);
            if (!match || "".equals(ResourcesSelectionDialog.this.fileExtension) && match) {
                return match;
            }
            String currentExtension = ((IResource)item).getFileExtension();
            return currentExtension != null && ResourcesSelectionDialog.this.fileExtension.equals(currentExtension.toLowerCase());
        }
    }
}

