/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.specifications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.impl.scopes.FilteredModelScope;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.util.BasicPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicCompositeLocation;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicElementLocation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractBijectiveTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractModifiableTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.AbstractRoleDerivationRule;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TemplateUsageSpecification
extends AbstractBijectiveTemplatePatternSpecification {
    private final AbstractModifiableTemplatePatternSpecification _data;
    private boolean _strictCompatibility;

    public TemplateUsageSpecification(AbstractModifiableTemplatePatternSpecification data_p) {
        this._data = data_p;
        this._strictCompatibility = true;
    }

    public IPatternApplication computeApplication() {
        EObject primaryTargetPattern = this.getTargetElement();
        EObject primaryTargetModel = this._data.getCounterpart(primaryTargetPattern, true);
        BasicPatternApplication result = new BasicPatternApplication((IPattern)this.getPattern(), (Object)primaryTargetModel);
        boolean first = true;
        for (TemplatePatternRole role : this.getPattern().getRoles()) {
            if (first) {
                first = false;
                BasicElementLocation location = new BasicElementLocation(primaryTargetModel);
                result.setLocation((IPatternRole)role, (ILocation)location);
                continue;
            }
            EList derived = null;
            BasicCompositeLocation location = null;
            if (role.getMergeDerivationRule() != null && !role.getTemplateElements().isEmpty() && (derived = role.getMergeDerivationRule().deriveCandidateElements((IPatternApplication)result)) != null) {
                location = new BasicCompositeLocation();
                for (EObject derivedElement : derived) {
                    BasicElementLocation elementLocation = new BasicElementLocation(derivedElement);
                    location.getOwnedLocations().add(elementLocation);
                }
            }
            result.setLocation((IPatternRole)role, location);
        }
        return result;
    }

    public void execute(IPatternApplication application_p, boolean includeChildren_p, boolean deleteRoles_p, boolean excludeElements_p, boolean overridePrimaryName_p, boolean overridePrimaryDescription_p, boolean includeEmptyRoles_p, boolean includeTargetDerivationRules_p) {
        boolean first = true;
        EObject primaryModelElement = this._data.getCounterpart(this.getTargetElement(), true);
        FilteredModelScope modelScope = (FilteredModelScope)this._data.getModelScope();
        if (excludeElements_p) {
            for (EObject root : new FArrayList((Collection)modelScope.getContents(), null)) {
                if (root == primaryModelElement) continue;
                modelScope.removeFromScope(root, true);
            }
        }
        for (TemplatePatternRole patternRole : new ArrayList(this._data.getPattern().getRoles())) {
            if (first) {
                if (overridePrimaryName_p) {
                    patternRole.setName(((IPatternRole)application_p.getPattern().getRoles().get(0)).getName());
                }
                if (patternRole.getDescription() == null || patternRole.getDescription().length() == 0 || overridePrimaryDescription_p) {
                    patternRole.setDescription(((IPatternRole)application_p.getPattern().getRoles().get(0)).getDescription());
                }
                first = false;
                continue;
            }
            if (!excludeElements_p && !deleteRoles_p) break;
            this._data.getPattern().getRoles().remove((Object)patternRole);
        }
        first = true;
        for (IPatternRole rawTemplateRole : application_p.getPattern().getRoles()) {
            TemplatePatternRole templateRole = (TemplatePatternRole)rawTemplateRole;
            if (first) {
                first = false;
                continue;
            }
            ILocation location = application_p.getLocation((IPatternRole)templateRole);
            List modelElements = location != null ? LocationsUtil.getMergeTargets((ILocation)location) : Collections.emptyList();
            for (EObject modelElement : modelElements) {
                modelScope.add(modelElement, includeChildren_p);
            }
        }
        this._data.updateComparison();
        EcoreUtil.Copier treeCopier = new EcoreUtil.Copier(false, false);
        first = true;
        for (IPatternRole rawTemplateRole : application_p.getPattern().getRoles()) {
            TemplatePatternRole templateRole = (TemplatePatternRole)rawTemplateRole;
            if (first) {
                first = false;
                continue;
            }
            ILocation location = application_p.getLocation((IPatternRole)templateRole);
            List modelElements = location != null ? LocationsUtil.getMergeTargets((ILocation)location) : Collections.emptyList();
            if (modelElements.isEmpty() && !includeEmptyRoles_p) continue;
            TemplatePatternRole patternRole = this._data.addRole(templateRole.getName());
            patternRole.setDescription(templateRole.getDescription());
            for (EObject modelElement : modelElements) {
                this._data.mapToRole(patternRole, modelElement);
            }
            patternRole.setAdditionKind(templateRole.getAdditionKind());
            if (templateRole.getPreferredContainment() != null) {
                patternRole.setPreferredContainment(templateRole.getPreferredContainment());
            }
            if (templateRole.getAdditionDerivationRule() != null) {
                patternRole.setAdditionDerivationRule((AbstractRoleDerivationRule)treeCopier.copy((EObject)templateRole.getAdditionDerivationRule()));
            }
            if (!includeTargetDerivationRules_p || templateRole.getMergeDerivationRule() == null) continue;
            patternRole.setMergeDerivationRule((AbstractRoleDerivationRule)treeCopier.copy((EObject)templateRole.getMergeDerivationRule()));
        }
        this._data.roleUpdated();
    }

    @Override
    public Collection<EObject> getAllElements() {
        Collection<Object> result = this.getPattern() != null ? Collections.unmodifiableList(ModelsUtil.getAllContents((Collection)this.getPattern().getTemplateElements(), (boolean)true, null)) : Collections.emptySet();
        return result;
    }

    public EObject getCounterpart(EObject element_p, boolean fromPattern_p) {
        return element_p;
    }

    public List<TemplatePatternRole> getRolesOf(EObject modelElement_p) {
        FOrderedSet result = new FOrderedSet();
        if (this.getPattern() != null) {
            for (TemplatePatternRole role : this.getPattern().getRoles()) {
                if (!role.getTemplateElements().contains((Object)modelElement_p)) continue;
                result.add(role);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public EObject getTargetElement() {
        return this.getPrimaryElement(this._data.getPattern());
    }

    public EObject getPrimaryElement(TemplatePattern pattern_p) {
        TemplatePatternRole primaryRole;
        EObject result = null;
        if (pattern_p != null && !pattern_p.getRoles().isEmpty() && !(primaryRole = (TemplatePatternRole)pattern_p.getRoles().get(0)).getTemplateElements().isEmpty()) {
            result = (EObject)primaryRole.getTemplateElements().get(0);
        }
        return result;
    }

    public Object getScopeElement() {
        return this._data.getScopeElement();
    }

    public TemplatePattern getTargetPattern() {
        return this._data.getPattern();
    }

    @Override
    public boolean isAcceptable(TemplatePattern pattern_p) {
        boolean result = pattern_p.isTemplate();
        if (result && this.isStrictCompatibility()) {
            EObject primaryTemplateElement = this.getPrimaryElement(pattern_p);
            EObject primaryTarget = this.getTargetElement();
            result = primaryTarget != null && primaryTemplateElement != null && primaryTarget.eClass() == primaryTemplateElement.eClass();
        }
        return result;
    }

    public boolean isComplete() {
        return this.getPattern() != null;
    }

    public static boolean isReadyForTemplateUsage(TemplatePattern pattern_p) {
        boolean result = false;
        if (!pattern_p.getRoles().isEmpty()) {
            TemplatePatternRole firstRole = (TemplatePatternRole)pattern_p.getRoles().get(0);
            result = firstRole.getTemplateElements().size() == 1;
        }
        return result;
    }

    public boolean isStrictCompatibility() {
        return this._strictCompatibility;
    }

    public void setStrictCompatibility(boolean strict_p) {
        this._strictCompatibility = strict_p;
        this.setRepository(this.getRepository());
    }
}

