/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.impl.utils;

import org.eclipse.emf.eef.runtime.impl.utils.StringMatcher;
import org.eclipse.jdt.core.search.SearchPattern;

public class PatternTool {
    public static boolean getPattern(String text, String pattern) {
        if (text == null) {
            return false;
        }
        if (pattern == null || "".equals(pattern)) {
            return true;
        }
        PatternMatcher fNameMatcher = new PatternMatcher(pattern, true);
        return fNameMatcher.matches(text);
    }

    private static class PatternMatcher {
        private String fPattern;
        private int fMatchKind;
        private StringMatcher fStringMatcher;
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private static final char BLANK = ' ';

        public PatternMatcher(String pattern, boolean ignoreCase) {
            this(pattern, 131);
        }

        public PatternMatcher(String pattern, int allowedModes) {
            this.initializePatternAndMatchKind(pattern);
            this.fMatchKind &= allowedModes;
            if (this.fMatchKind == 2) {
                this.fStringMatcher = new StringMatcher(this.fPattern, true, false);
            }
        }

        public String getPattern() {
            return this.fPattern;
        }

        public int getMatchKind() {
            return this.fMatchKind;
        }

        public boolean matches(String text) {
            switch (this.fMatchKind) {
                case 2: {
                    return this.fStringMatcher.match(text);
                }
                case 0: {
                    return this.fPattern.equalsIgnoreCase(text);
                }
                case 128: {
                    if (!SearchPattern.camelCaseMatch((String)this.fPattern, (String)text)) break;
                    return true;
                }
            }
            return PatternMatcher.startsWithIgnoreCase(text, this.fPattern);
        }

        public static boolean startsWithIgnoreCase(String text, String prefix) {
            int prefixLength;
            int textLength = text.length();
            if (textLength < (prefixLength = prefix.length())) {
                return false;
            }
            int i = prefixLength - 1;
            while (i >= 0) {
                if (Character.toLowerCase(prefix.charAt(i)) != Character.toLowerCase(text.charAt(i))) {
                    return false;
                }
                --i;
            }
            return true;
        }

        private void initializePatternAndMatchKind(String pattern) {
            int length = pattern.length();
            if (length == 0) {
                this.fMatchKind = 0;
                this.fPattern = pattern;
                return;
            }
            char last = pattern.charAt(length - 1);
            if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
                this.fMatchKind = 2;
                switch (last) {
                    case '<': {
                        this.fPattern = pattern.substring(0, length - 1);
                        break;
                    }
                    case ' ': {
                        this.fPattern = pattern.trim();
                        break;
                    }
                    case '*': {
                        this.fPattern = pattern;
                        break;
                    }
                    default: {
                        this.fPattern = String.valueOf(pattern) + '*';
                    }
                }
                return;
            }
            if (last == '<') {
                this.fMatchKind = 0;
                this.fPattern = pattern.substring(0, length - 1);
                return;
            }
            if (last == ' ') {
                this.fMatchKind = 0;
                this.fPattern = pattern.trim();
                return;
            }
            if (PatternMatcher.isCamelCasePattern(pattern)) {
                this.fMatchKind = 128;
                this.fPattern = pattern;
                return;
            }
            this.fMatchKind = 1;
            this.fPattern = pattern;
        }

        public static boolean isCamelCasePattern(String pattern) {
            return SearchPattern.validateMatchRule((String)pattern, (int)128) == 128;
        }
    }
}

