/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.revision;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.revision.EditableRevision;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorInput;

public class ResourceEditableRevision
extends EditableRevision
implements IResourceProvider {
    private final IFile file;
    private final IRunnableContext runnableContext;

    public ResourceEditableRevision(IFileRevision fileRevision, @NonNull IFile file, @NonNull IRunnableContext runnableContext) {
        super(fileRevision, CompareCoreUtils.getResourceEncoding((IResource)file));
        this.file = file;
        this.runnableContext = runnableContext;
    }

    @Override
    public void setContent(byte[] newContent) {
        try {
            ISchedulingRule rule = Job.getJobManager().currentRule();
            boolean fork = true;
            if (rule instanceof IResource && this.file.exists() && ((IResource)rule).isConflicting((ISchedulingRule)this.file)) {
                fork = false;
            }
            this.runnableContext.run(fork, false, monitor -> {
                try {
                    this.file.setContents((InputStream)new ByteArrayInputStream(newContent), false, true, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                Activator.showErrorStatus(e.getCause().getLocalizedMessage(), ((CoreException)e.getCause()).getStatus());
            } else {
                Activator.showError(e.getCause().getLocalizedMessage(), e.getCause());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public IResource getResource() {
        return this.file;
    }

    @Override
    protected <T> T adaptEditorInput(IEditorInput editorInput, Class<T> adapter) {
        if (adapter == IResource.class || adapter == IFile.class) {
            return adapter.cast(this.file);
        }
        return super.adaptEditorInput(editorInput, adapter);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.file, this.runnableContext);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceEditableRevision other = (ResourceEditableRevision)obj;
        return Objects.equals(this.file, other.file) && Objects.equals(this.runnableContext, other.runnableContext);
    }
}

