/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.operations.DiffOperation;
import org.eclipse.ui.IWorkbenchPart;

public class ClipboardDiffOperation
extends DiffOperation {
    private static final Object DESTINATION_CLIPBOARD = CVSUIMessages.ClipboardDiffOperation_Clipboard;
    final ByteArrayOutputStream os = new ByteArrayOutputStream();

    public ClipboardDiffOperation(IWorkbenchPart part, ResourceMapping[] mappings, Command.LocalOption[] options, boolean isMultiPatch, boolean includeFullPathInformation, IPath patchRoot) {
        super(part, mappings, options, isMultiPatch, includeFullPathInformation, patchRoot, DESTINATION_CLIPBOARD);
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        super.execute(monitor);
        if (this.os.size() == 0 || !this.patchHasContents && !this.patchHasNewFiles) {
            this.reportEmptyDiff();
        } else {
            this.copyToClipboard(this.os);
        }
    }

    private void copyToClipboard(ByteArrayOutputStream baos) {
        this.getShell().getDisplay().syncExec(() -> {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
            clipboard.setContents((Object[])new String[]{baos.toString()}, new Transfer[]{plainTextTransfer});
            clipboard.dispose();
        });
    }

    @Override
    protected PrintStream openStream() {
        return new PrintStream(this.os);
    }
}

