/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Preconditions;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.sequence.Messages;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public abstract class AbstractSequenceElement
extends AdapterImpl
implements ISequenceElement {
    protected final View view;
    protected Option<SequenceDiagram> cachedDiagram;

    AbstractSequenceElement(View view) {
        this.view = (View)Preconditions.checkNotNull((Object)view);
    }

    protected static final boolean isSequenceDiagramElement(DDiagramElement element, EClass mappingType) {
        DiagramElementMapping mapping;
        Preconditions.checkNotNull((Object)mappingType);
        boolean result = false;
        if (element != null && (mapping = element.getDiagramElementMapping()) != null) {
            DiagramElementMapping mappingToCheck = new DiagramElementMappingQuery(mapping).getRootMapping();
            result = mappingType.isInstance((Object)mappingToCheck) && SequenceDiagram.viewpointElementPredicate().apply((Object)element.getParentDiagram());
        }
        return result;
    }

    @Override
    public View getNotationView() {
        return this.view;
    }

    @Override
    public SequenceDiagram getDiagram() {
        if (this.cachedDiagram == null) {
            Diagram gmfDiagram = this.view.getDiagram();
            Option<SequenceDiagram> diagram = ISequenceElementAccessor.getSequenceDiagram(gmfDiagram);
            assert (diagram.some()) : Messages.AbstractSequenceElement_invalidDiagram;
            this.cachedDiagram = diagram;
        }
        return (SequenceDiagram)this.cachedDiagram.get();
    }

    public int hashCode() {
        return this.view.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj != null && this.getClass().equals(obj.getClass())) {
            AbstractSequenceElement other = (AbstractSequenceElement)obj;
            if (this.view != null && this.view.equals(other.view)) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public Option<EObject> getSemanticTargetElement() {
        EObject element = this.view.getElement();
        if (element instanceof DSemanticDecorator) {
            return Options.newSome((Object)((DSemanticDecorator)element).getTarget());
        }
        return Options.newNone();
    }

    public String toString() {
        return "#<" + this.getClass().getSimpleName() + ": " + this.view.getElement() + ">";
    }
}

