/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.sirius.properties.core.api.preferences.SiriusPropertiesCorePreferences;
import org.eclipse.sirius.ui.properties.internal.preferences.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SiriusPropertiesViewGeneralPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button filterSemanticTab;
    private Button filterDefaultTab;
    private Text maxTabNameLength;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        Group tabFilterComposite = this.createGroup(composite, Messages.SiriusPropertiesPreferencePage_filterGroup);
        this.addFilterSemanticTabField((Composite)tabFilterComposite);
        this.addFilterDefaultTabField((Composite)tabFilterComposite);
        Group tabNameMaxLengthComposite = this.createGroup(composite, Messages.SiriusPropertiesPreferencePage_tabGroup);
        this.addTabNameMaxLengthTabFields((Composite)tabNameMaxLengthComposite);
        this.initialize();
        this.checkState();
        return composite;
    }

    private void addFilterSemanticTabField(Composite parent) {
        this.filterSemanticTab = new Button(parent, 16416);
        this.filterSemanticTab.setText(Messages.SiriusPropertiesPreferencePage_semanticTab);
        this.filterSemanticTab.setFont(parent.getFont());
        this.filterSemanticTab.setSelection(SiriusPropertiesCorePreferences.INSTANCE.isSemanticTabFiltered());
        this.filterSemanticTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SiriusPropertiesViewGeneralPreferencePage.this.checkState();
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.filterSemanticTab.setLayoutData((Object)gridData);
    }

    private void addFilterDefaultTabField(Composite parent) {
        this.filterDefaultTab = new Button(parent, 16416);
        this.filterDefaultTab.setText(Messages.SiriusPropertiesPreferencePage_defaultTab);
        this.filterDefaultTab.setFont(parent.getFont());
        this.filterDefaultTab.setSelection(SiriusPropertiesCorePreferences.INSTANCE.isDefaultTabFiltered());
        this.filterDefaultTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SiriusPropertiesViewGeneralPreferencePage.this.checkState();
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.filterDefaultTab.setLayoutData((Object)gridData);
    }

    private void addTabNameMaxLengthTabFields(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setFont(parent.getFont());
        label.setText(Messages.SiriusPropertiesPreferencePage_maxLengthTabName);
        this.maxTabNameLength = new Text(parent, 2052);
        this.maxTabNameLength.setFont(parent.getFont());
        this.maxTabNameLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SiriusPropertiesViewGeneralPreferencePage.this.checkState();
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.maxTabNameLength.setLayoutData((Object)gridData);
    }

    private Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        group.setLayoutData((Object)gridData);
        group.setText(text);
        return group;
    }

    private void initialize() {
        this.filterSemanticTab.setSelection(SiriusPropertiesCorePreferences.INSTANCE.isSemanticTabFiltered());
        this.filterDefaultTab.setSelection(SiriusPropertiesCorePreferences.INSTANCE.isDefaultTabFiltered());
        this.maxTabNameLength.setText(Integer.toString(SiriusPropertiesCorePreferences.INSTANCE.getMaxLengthTabName()));
    }

    private void checkState() {
        try {
            int number = Integer.valueOf(this.maxTabNameLength.getText());
            if (number >= 0 && number <= Integer.MAX_VALUE) {
                this.setErrorMessage(null);
                this.setValid(true);
            } else {
                this.setErrorMessage(Messages.SiriusPropertiesPreferencePage_maxLengthTabName_invalidInteger);
                this.setValid(false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.SiriusPropertiesPreferencePage_maxLengthTabName_invalidValue);
            this.setValid(false);
        }
    }

    public boolean performCancel() {
        this.initialize();
        return super.performCancel();
    }

    protected void performDefaults() {
        this.filterSemanticTab.setSelection(SiriusPropertiesCorePreferences.INSTANCE.isSemanticTabFilteredDefaultValue());
        this.filterDefaultTab.setSelection(SiriusPropertiesCorePreferences.INSTANCE.isDefaultTabFilteredDefaultValue());
        this.maxTabNameLength.setText(Integer.toString(SiriusPropertiesCorePreferences.INSTANCE.getMaxLengthTabNameDefaultValue()));
        super.performDefaults();
    }

    public boolean performOk() {
        SiriusPropertiesCorePreferences.INSTANCE.setFilterSemanticTab(this.filterSemanticTab.getSelection());
        SiriusPropertiesCorePreferences.INSTANCE.setFilterDefaultTab(this.filterDefaultTab.getSelection());
        SiriusPropertiesCorePreferences.INSTANCE.setMaxLengthTabName(Integer.parseInt(this.maxTabNameLength.getText()));
        return super.performOk();
    }
}

