/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.ui.editor.doubleClicking.AbstractPartitionDoubleClickSelector;
import org.eclipse.xtext.ui.editor.doubleClicking.DoubleClickStrategyProvider;
import org.eclipse.xtext.ui.editor.model.CommonBreakIterator;

public class XtendDoubleClickStrategyProvider
extends DoubleClickStrategyProvider {
    public ITextDoubleClickStrategy getStrategy(ISourceViewer sourceViewer, String contentType, String documentPartitioning) {
        if ("__rich_string".equals(contentType)) {
            return new AbstractPartitionDoubleClickSelector(documentPartitioning){

                protected IRegion getSelectedRegion(IDocument document, ITypedRegion completePartition) throws BadLocationException {
                    String content = document.get(completePartition.getOffset(), completePartition.getLength());
                    int trimLeft = 1;
                    if (content.startsWith("'''")) {
                        trimLeft = 3;
                    }
                    int trimRight = 0;
                    if (content.endsWith("'''")) {
                        trimRight = 3;
                    } else if (content.endsWith("''")) {
                        trimRight = 2;
                    } else if (content.endsWith("'") || content.endsWith("\u00ab")) {
                        trimRight = 1;
                    }
                    return new Region(completePartition.getOffset() + trimLeft, completePartition.getLength() - trimLeft - trimRight);
                }
            };
        }
        if ("__java_javadoc".equals(contentType)) {
            return new AbstractPartitionDoubleClickSelector(documentPartitioning){

                protected IRegion findExtendedDoubleClickSelection(IDocument document, int position) {
                    int end;
                    int start;
                    block9: {
                        IRegion line;
                        IRegion word;
                        block8: {
                            try {
                                IRegion match = super.findExtendedDoubleClickSelection(document, position);
                                if (match != null) {
                                    return match;
                                }
                                word = this.findWord(document, position);
                                line = document.getLineInformationOfOffset(position);
                                if (position != line.getOffset() + line.getLength()) break block8;
                                return null;
                            }
                            catch (BadLocationException x) {
                                return null;
                            }
                        }
                        start = word.getOffset();
                        end = start + word.getLength();
                        if (start > 0 && document.getChar(start - 1) == '@' && Character.isJavaIdentifierPart(document.getChar(start)) && (start == 1 || Character.isWhitespace(document.getChar(start - 2)) || document.getChar(start - 2) == '{')) {
                            --start;
                        } else if (end == position && end == start + 1 && end < line.getOffset() + line.getLength() && document.getChar(end) == '@') {
                            return this.findExtendedDoubleClickSelection(document, position + 1);
                        }
                        if (start != end) break block9;
                        return null;
                    }
                    return new Region(start, end - start);
                }

                protected CommonBreakIterator createBreakIterator() {
                    return new CommonBreakIterator(false){
                        Braces braces;
                        Parentheses parentheses;
                        {
                            this.braces = new Braces();
                            this.parentheses = new Parentheses();
                        }

                        protected CommonBreakIterator.Run getRun(char ch) {
                            if (this.braces.isValid(ch)) {
                                return this.braces;
                            }
                            if (this.parentheses.isValid(ch)) {
                                return this.parentheses;
                            }
                            return super.getRun(ch);
                        }

                        class Braces
                        extends CommonBreakIterator.Other {
                            Braces() {
                            }

                            protected boolean isValid(char ch) {
                                return ch == '{' || ch == '}';
                            }
                        }

                        class Parentheses
                        extends CommonBreakIterator.Other {
                            Parentheses() {
                            }

                            protected boolean isValid(char ch) {
                                return ch == '(' || ch == ')';
                            }
                        }
                    };
                }
            };
        }
        return super.getStrategy(sourceViewer, contentType, documentPartitioning);
    }
}

