/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.internal.allocation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.composer.Activator;
import org.polarsys.kitalpha.composer.api.allocation.AllocationProviderPriority;
import org.polarsys.kitalpha.composer.api.allocation.IAllocationProvider;
import org.polarsys.kitalpha.composer.api.allocation.IAllocationProviderDescriptor;
import org.polarsys.kitalpha.composer.metamodel.allocation.base.Root;

public class AllocationProviderDescriptor
implements IAllocationProviderDescriptor {
    private IConfigurationElement configurationElement;
    private AllocationProviderPriority priority;
    private IAllocationProvider provider;
    private boolean valid = true;

    public AllocationProviderDescriptor(IConfigurationElement configurationElement, AllocationProviderPriority priority) {
        this.configurationElement = configurationElement;
        this.priority = priority;
    }

    @Override
    public IAllocationProvider getAllocationProvider() {
        if (this.provider == null && this.valid) {
            this.provider = this.createAllocationProvider();
        }
        return this.provider;
    }

    @Override
    public String getAllocationProviderClassName() {
        return this.configurationElement.getAttribute("providerClass");
    }

    @Override
    public AllocationProviderPriority getPriority() {
        return this.priority;
    }

    private IAllocationProvider createAllocationProvider() {
        try {
            return (IAllocationProvider)this.configurationElement.createExecutableExtension("providerClass");
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            this.valid = false;
            return null;
        }
    }

    @Override
    public boolean provides(Root rootAllocation, EObject unknownElement) {
        return this.getAllocationProvider() != null && this.getAllocationProvider().provides(rootAllocation, unknownElement);
    }
}

