/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.VerticalRangeFunction;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.sequence.util.Range;

public class VerticalPositionFunction
implements Function<EventEnd, Integer> {
    public static final int INVALID_POSITION = Integer.MAX_VALUE;
    private final SequenceDDiagram diagram;

    public VerticalPositionFunction(SequenceDDiagram diagram) {
        this.diagram = diagram;
    }

    public Integer apply(EventEnd end) {
        Integer result;
        Collection<View> eventViews;
        SingleEventEnd see = null;
        EObject semanticEvent = null;
        if (end instanceof SingleEventEnd) {
            see = (SingleEventEnd)end;
        } else if (end instanceof CompoundEventEnd) {
            see = (SingleEventEnd)((CompoundEventEnd)end).getEventEnds().iterator().next();
        }
        if (see != null) {
            semanticEvent = see.getSemanticEvent();
        }
        if (Iterables.isEmpty(eventViews = ISequenceElementAccessor.getViewsForSemanticElement(this.diagram, semanticEvent)) && end instanceof CompoundEventEnd) {
            for (SingleEventEnd see2 : ((CompoundEventEnd)end).getEventEnds()) {
                if (see != null) {
                    semanticEvent = see2.getSemanticEvent();
                }
                if (!Iterables.isEmpty(eventViews = ISequenceElementAccessor.getViewsForSemanticElement(this.diagram, semanticEvent))) break;
            }
        }
        if (Iterables.isEmpty(eventViews)) {
            result = Integer.MAX_VALUE;
        } else {
            result = Integer.MAX_VALUE;
            Range range = Range.emptyRange();
            for (View potentialView : eventViews) {
                range = VerticalRangeFunction.INSTANCE.apply(potentialView);
                if (!range.isEmpty()) break;
            }
            result = EventEndHelper.PUNCTUAL_COMPOUND_EVENT_END.apply((Object)end) ? Integer.valueOf(range.middleValue()) : (EventEndHelper.PUNCTUAL_COMPOUND_EVENT_END.apply((Object)end) ? Integer.valueOf(range.middleValue()) : Integer.valueOf(see.isStart() ? range.getLowerBound() : range.getUpperBound()));
        }
        return result;
    }
}

