/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.project;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.project.RepositoryMappingChangeListener;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;

public class GitProjectData {
    private static final Map<IProject, GitProjectData> projectDataCache = new HashMap<IProject, GitProjectData>();
    private static Set<RepositoryMappingChangeListener> repositoryChangeListeners = new HashSet<RepositoryMappingChangeListener>();
    private static final IResourceChangeListener rcl = new RCL();
    private static QualifiedName MAPPING_KEY = new QualifiedName(GitProjectData.class.getName(), "RepositoryMapping");
    private final IProject project;
    private final Map<IPath, RepositoryMapping> mappings = new HashMap<IPath, RepositoryMapping>();
    private final Set<IResource> protectedResources = new HashSet<IResource>();

    public static void attachToWorkspace() {
        GitProjectData.trace("attachToWorkspace - addResourceChangeListener");
        ResourcesPlugin.getWorkspace().addResourceChangeListener(rcl, 7);
    }

    public static void detachFromWorkspace() {
        GitProjectData.trace("detachFromWorkspace - removeResourceChangeListener");
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(rcl);
    }

    public static synchronized void addRepositoryChangeListener(RepositoryMappingChangeListener objectThatCares) {
        if (objectThatCares == null) {
            throw new NullPointerException();
        }
        repositoryChangeListeners.add(objectThatCares);
    }

    public static synchronized void removeRepositoryChangeListener(RepositoryMappingChangeListener objectThatCares) {
        repositoryChangeListeners.remove(objectThatCares);
    }

    static void fireRepositoryChanged(final RepositoryMapping which) {
        Job job = new Job(CoreText.GitProjectData_repositoryChangedJobName){

            protected IStatus run(IProgressMonitor monitor) {
                RepositoryMappingChangeListener[] listeners = GitProjectData.getRepositoryChangeListeners();
                monitor.beginTask(CoreText.GitProjectData_repositoryChangedTaskName, listeners.length);
                RepositoryMappingChangeListener[] repositoryMappingChangeListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    RepositoryMappingChangeListener listener = repositoryMappingChangeListenerArray[n2];
                    listener.repositoryChanged(which);
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.REPOSITORY_CHANGED.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(false);
        job.schedule();
    }

    private static synchronized RepositoryMappingChangeListener[] getRepositoryChangeListeners() {
        return repositoryChangeListeners.toArray(new RepositoryMappingChangeListener[0]);
    }

    @Nullable
    public static synchronized GitProjectData get(@NonNull IProject p) {
        try {
            GitProjectData d = GitProjectData.lookup(p);
            if (d == null && ResourceUtil.isSharedWithGit((IResource)p)) {
                d = new GitProjectData(p).load();
                GitProjectData.cache(p, d);
            }
            return d;
        }
        catch (IOException err) {
            Activator.logError(CoreText.GitProjectData_missing, err);
            return null;
        }
    }

    public static void delete(IProject p) throws IOException {
        GitProjectData.trace("delete(" + p.getName() + ")");
        GitProjectData d = GitProjectData.lookup(p);
        if (d == null) {
            GitProjectData.deletePropertyFiles(p);
        } else {
            d.deletePropertyFilesAndUncache();
        }
    }

    public static void deconfigure(IProject p) throws IOException {
        GitProjectData.trace("deconfigure(" + p.getName() + ")");
        GitProjectData d = GitProjectData.lookup(p);
        if (d == null) {
            GitProjectData.deletePropertyFiles(p);
        } else {
            d.deletePropertyFilesAndUncache();
            GitProjectData.unmap(d);
        }
    }

    public static void add(IProject p, GitProjectData d) {
        GitProjectData.trace("add(" + p.getName() + ")");
        GitProjectData.cache(p, d);
    }

    /*
     * Unable to fully structure code
     */
    public static void update(IResourceChangeEvent event) {
        block14: {
            block13: {
                modified = new HashSet<E>();
                try {
                    try {
                        event.getDelta().accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                IResource resource = delta.getResource();
                                int type = resource.getType();
                                if (type == 8) {
                                    return true;
                                }
                                if (type == 4) {
                                    return (delta.getKind() & 5) != 0 && ResourceUtil.isSharedWithGit(resource);
                                }
                                if ((delta.getKind() & 5) == 0 || resource.isLinked()) {
                                    return false;
                                }
                                IPath location = resource.getLocation();
                                if (location == null) {
                                    return false;
                                }
                                if (!".git".equals(resource.getName())) {
                                    return type == 2;
                                }
                                File gitCandidate = location.toFile().getParentFile();
                                File git = ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().addCeilingDirectory(gitCandidate)).findGitDir(gitCandidate)).getGitDir();
                                if (git == null) {
                                    return false;
                                }
                                GitProjectData data = GitProjectData.get(resource.getProject());
                                if (data == null) {
                                    return false;
                                }
                                RepositoryMapping m = RepositoryMapping.create(resource.getParent(), git);
                                try {
                                    Repository r = Activator.getDefault().getRepositoryCache().lookupRepository(git);
                                    if (m != null && r != null && !r.isBare() && gitCandidate.equals(r.getWorkTree()) && data.map(m)) {
                                        data.mappings.put(m.getContainerPath(), m);
                                        modified.add(data);
                                    }
                                }
                                catch (IOException e) {
                                    Activator.logError(e.getMessage(), e);
                                }
                                return false;
                            }
                        });
                        break block13;
                    }
                    catch (CoreException e) {
                        Activator.logError(e.getMessage(), e);
                        ** for (data : modified)
                    }
                }
                catch (Throwable var3_12) {
                    ** for (data : modified)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        data.store();
                    }
                    catch (CoreException e) {
                        Activator.logError(e.getMessage(), e);
                    }
                    continue;
lbl15:
                    // 1 sources

                    break block14;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        data.store();
                    }
                    catch (CoreException e) {
                        Activator.logError(e.getMessage(), e);
                    }
                    continue;
                }
lbl24:
                // 1 sources

                throw var3_12;
            }
            for (GitProjectData data : modified) {
                try {
                    data.store();
                }
                catch (CoreException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
        }
    }

    static void trace(String m) {
        if (GitTraceLocation.CORE.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), "(GitProjectData) " + m);
        }
    }

    private static synchronized void cache(IProject p, GitProjectData d) {
        projectDataCache.put(p, d);
    }

    private static synchronized void uncache(IProject p) {
        if (projectDataCache.remove(p) != null) {
            GitProjectData.trace("uncacheDataFor(" + p.getName() + ")");
        }
    }

    private static void unmap(GitProjectData data) {
        for (RepositoryMapping m : data.mappings.values()) {
            IContainer c = m.getContainer();
            if (c == null || !c.isAccessible()) continue;
            try {
                c.setSessionProperty(MAPPING_KEY, null);
            }
            catch (CoreException e) {
                Activator.logWarning(MessageFormat.format(CoreText.GitProjectData_failedToUnmapRepoMapping, c.getFullPath()), e);
            }
        }
    }

    private static synchronized GitProjectData lookup(IProject p) {
        return projectDataCache.get(p);
    }

    public static void reconfigureWindowCache() {
        WindowCacheConfig c = new WindowCacheConfig();
        IEclipsePreferences d = DefaultScope.INSTANCE.getNode(Activator.getPluginId());
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode(Activator.getPluginId());
        c.setPackedGitLimit((long)p.getInt("core_packedGitLimit", d.getInt("core_packedGitLimit", 0)));
        c.setPackedGitWindowSize(p.getInt("core_packedGitWindowSize", d.getInt("core_packedGitWindowSize", 0)));
        if (SystemReader.getInstance().isWindows()) {
            c.setPackedGitMMAP(false);
        } else {
            c.setPackedGitMMAP(p.getBoolean("core_packedGitMMAP", d.getBoolean("core_packedGitMMAP", false)));
        }
        c.setDeltaBaseCacheLimit(p.getInt("core_deltaBaseCacheLimit", d.getInt("core_deltaBaseCacheLimit", 0)));
        c.setStreamFileThreshold(p.getInt("core_streamFileThreshold", d.getInt("core_streamFileThreshold", 0)));
        c.setExposeStatsViaJmx(false);
        c.install();
    }

    public GitProjectData(IProject p) {
        this.project = p;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setRepositoryMappings(Collection<RepositoryMapping> newMappings) {
        this.mappings.clear();
        for (RepositoryMapping mapping : newMappings) {
            this.mappings.put(mapping.getContainerPath(), mapping);
        }
        this.remapAll();
    }

    public final Map<IPath, RepositoryMapping> getRepositoryMappings() {
        return this.mappings;
    }

    public void markTeamPrivateResources() throws CoreException {
        for (RepositoryMapping rm : this.mappings.values()) {
            IResource dotGit;
            IContainer c = rm.getContainer();
            if (c == null || (dotGit = c.findMember(".git")) == null) continue;
            try {
                Repository r = rm.getRepository();
                File dotGitDir = dotGit.getLocation().toFile().getCanonicalFile();
                if (!dotGitDir.equals(r.getDirectory())) continue;
                GitProjectData.trace("teamPrivate " + dotGit);
                dotGit.setTeamPrivateMember(true);
            }
            catch (IOException err) {
                throw new CoreException(Activator.error(CoreText.Error_CanonicalFile, err));
            }
        }
    }

    public boolean hasInnerRepositories() {
        return !this.protectedResources.isEmpty();
    }

    public boolean isProtected(IResource f) {
        return this.protectedResources.contains(f);
    }

    @Nullable
    public RepositoryMapping getRepositoryMapping(@Nullable IResource resource) {
        IResource r = resource;
        try {
            while (r != null) {
                RepositoryMapping m;
                if (r.isAccessible() && (m = (RepositoryMapping)r.getSessionProperty(MAPPING_KEY)) != null) {
                    return m;
                }
                r = r.getParent();
            }
        }
        catch (CoreException err) {
            Activator.logError(CoreText.GitProjectData_failedFindingRepoMapping, err);
        }
        return null;
    }

    private void deletePropertyFilesAndUncache() throws IOException {
        GitProjectData.deletePropertyFiles(this.getProject());
        GitProjectData.uncache(this.getProject());
    }

    private static void deletePropertyFiles(IProject project) throws IOException {
        File dir = GitProjectData.propertyFile(project).getParentFile();
        FileUtils.delete((File)dir, (int)1);
        GitProjectData.trace("deleteDataFor(" + project.getName() + ")");
    }

    public void store() throws CoreException {
        File dat = this.propertyFile();
        boolean ok = false;
        try {
            GitProjectData.trace("save " + dat);
            File tmp = File.createTempFile("gpd_", ".prop", dat.getParentFile());
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (OutputStream o = Files.newOutputStream(tmp.toPath(), new OpenOption[0]);){
                    Properties p = new Properties();
                    for (RepositoryMapping repoMapping : this.mappings.values()) {
                        repoMapping.store(p);
                    }
                    p.store(o, "GitProjectData");
                    ok = true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                if (!ok && tmp.exists()) {
                    FileUtils.delete((File)tmp);
                }
            }
            if (dat.exists()) {
                FileUtils.delete((File)dat);
            }
            if (!tmp.renameTo(dat)) {
                if (tmp.exists()) {
                    FileUtils.delete((File)tmp);
                }
                throw new CoreException(Activator.error(NLS.bind((String)CoreText.GitProjectData_saveFailed, (Object)dat), null));
            }
        }
        catch (IOException ioe) {
            throw new CoreException(Activator.error(NLS.bind((String)CoreText.GitProjectData_saveFailed, (Object)dat), ioe));
        }
    }

    private File propertyFile() {
        return GitProjectData.propertyFile(this.getProject());
    }

    private static File propertyFile(IProject project) {
        return new File(project.getWorkingLocation(Activator.getPluginId()).toFile(), "GitProjectData.properties");
    }

    private GitProjectData load() throws IOException {
        File dat = this.propertyFile();
        GitProjectData.trace("load " + dat);
        Throwable throwable = null;
        Object var3_5 = null;
        try (InputStream o = Files.newInputStream(dat.toPath(), new OpenOption[0]);){
            Properties p = new Properties();
            p.load(o);
            this.mappings.clear();
            for (Object keyObj : p.keySet()) {
                String key = keyObj.toString();
                if (!RepositoryMapping.isInitialKey(key)) continue;
                RepositoryMapping mapping = new RepositoryMapping(p, key);
                this.mappings.put(mapping.getContainerPath(), mapping);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!this.remapAll()) {
            try {
                this.store();
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                Activator.logError(status.getMessage(), status.getException());
            }
        }
        return this;
    }

    private boolean remapAll() {
        this.protectedResources.clear();
        boolean allMapped = true;
        Iterator<RepositoryMapping> iterator = this.mappings.values().iterator();
        while (iterator.hasNext()) {
            RepositoryMapping m = iterator.next();
            if (this.map(m)) continue;
            iterator.remove();
            allMapped = false;
        }
        return allMapped;
    }

    private boolean map(RepositoryMapping m) {
        IContainer c = null;
        m.clear();
        IResource r = this.getProject().findMember(m.getContainerPath());
        if (r instanceof IContainer) {
            c = (IContainer)r;
        } else if (r != null) {
            c = (IContainer)Adapters.adapt((Object)r, IContainer.class);
        }
        if (c == null) {
            this.logAndUnmapGoneMappedResource(m, null);
            return false;
        }
        m.setContainer(c);
        IPath absolutePath = m.getGitDirAbsolutePath();
        if (absolutePath == null) {
            this.logAndUnmapGoneMappedResource(m, c);
            return false;
        }
        File git = absolutePath.toFile();
        if (!RepositoryCache.FileKey.isGitRepository((File)git, (FS)FS.DETECTED)) {
            this.logAndUnmapGoneMappedResource(m, c);
            return false;
        }
        try {
            m.setRepository(Activator.getDefault().getRepositoryCache().lookupRepository(git));
        }
        catch (IOException ioe) {
            this.logAndUnmapGoneMappedResource(m, c);
            return false;
        }
        GitProjectData.trace("map " + c + " -> " + m.getRepository());
        try {
            c.setSessionProperty(MAPPING_KEY, (Object)m);
        }
        catch (CoreException err) {
            Activator.logError(CoreText.GitProjectData_failedToCacheRepoMapping, err);
        }
        IResource dotGit = c.findMember(".git");
        if (dotGit != null) {
            this.protect(dotGit);
        }
        GitProjectData.fireRepositoryChanged(m);
        return true;
    }

    private void logAndUnmapGoneMappedResource(RepositoryMapping m, IContainer c) {
        Activator.logError(MessageFormat.format(CoreText.GitProjectData_mappedResourceGone, m.toString()), new FileNotFoundException(m.getContainerPath().toString()));
        m.clear();
        if (c instanceof IProject) {
            UnmapJob unmapJob = new UnmapJob((IProject)c);
            unmapJob.schedule();
        } else if (c != null) {
            try {
                c.setSessionProperty(MAPPING_KEY, null);
            }
            catch (CoreException e) {
                Activator.logWarning(MessageFormat.format(CoreText.GitProjectData_failedToUnmapRepoMapping, c.getFullPath()), e);
            }
        }
    }

    private void protect(IResource resource) {
        IResource c = resource;
        try {
            c.setTeamPrivateMember(true);
        }
        catch (CoreException e) {
            Activator.logError(MessageFormat.format(CoreText.GitProjectData_FailedToMarkTeamPrivate, c.getFullPath()), e);
        }
        while (c != null && !c.equals((Object)this.getProject())) {
            GitProjectData.trace("protect " + c);
            this.protectedResources.add(c);
            c = c.getParent();
        }
    }

    private static class RCL
    implements IResourceChangeListener {
        private RCL() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 2: {
                    GitProjectData.uncache((IProject)event.getResource());
                    break;
                }
                case 4: {
                    try {
                        GitProjectData.delete((IProject)event.getResource());
                    }
                    catch (IOException e) {
                        Activator.logError(e.getMessage(), e);
                    }
                    break;
                }
                case 1: {
                    GitProjectData.update(event);
                    break;
                }
            }
        }
    }

    private static class UnmapJob
    extends Job {
        private final IProject project;

        private UnmapJob(IProject project) {
            super(MessageFormat.format(CoreText.GitProjectData_UnmapJobName, project.getName()));
            this.project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                RepositoryProvider.unmap((IProject)this.project);
                return Status.OK_STATUS;
            }
            catch (TeamException e) {
                return new Status(4, Activator.getPluginId(), MessageFormat.format(CoreText.GitProjectData_UnmappingGoneResourceFailed, this.project.getName()), (Throwable)e);
            }
        }
    }
}

