/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.report.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.report.model.LogEntry;
import org.polarsys.kitalpha.report.model.Severity;
import org.polarsys.kitalpha.report.utils.AbstractReportFactory;
import org.polarsys.kitalpha.report.utils.SeverityFactory;

public class ReportFactory
extends AbstractReportFactory {
    public static final String REPORT_LIST_ID = "default.report.list";
    public static final ReportFactory INSTANCE = new ReportFactory("default.report.list");

    public ReportFactory(String listId) {
        super(listId);
    }

    public LogEntry log(IStatus status) {
        Severity sev = SeverityFactory.INSTANCE.createInfo();
        if (status.getSeverity() == 4) {
            sev = SeverityFactory.INSTANCE.createError();
        } else if (status.getSeverity() == 2) {
            sev = SeverityFactory.INSTANCE.createWarning();
        }
        return this.log(sev, this.toString(status.getMessage(), status.getException()), null);
    }

    public LogEntry logError(Throwable th) {
        return this.log(SeverityFactory.INSTANCE.createError(), this.toString(null, th), null);
    }

    public LogEntry logError(String message, Throwable th) {
        return this.log(SeverityFactory.INSTANCE.createError(), this.toString(message, th), null);
    }

    public LogEntry logError(String message) {
        return this.log(SeverityFactory.INSTANCE.createError(), message, null);
    }

    public LogEntry logError(String message, EObject reference) {
        return this.log(SeverityFactory.INSTANCE.createError(), message, reference);
    }

    public LogEntry logError(String message, Throwable th, EObject reference) {
        return this.log(SeverityFactory.INSTANCE.createError(), this.toString(message, th), reference);
    }

    public LogEntry logWarning(Throwable th) {
        return this.log(SeverityFactory.INSTANCE.createWarning(), this.toString(null, th), null);
    }

    public LogEntry logWarning(String message) {
        return this.log(SeverityFactory.INSTANCE.createWarning(), message, null);
    }

    public LogEntry logWarning(String message, Throwable th) {
        return this.log(SeverityFactory.INSTANCE.createWarning(), this.toString(message, th), null);
    }

    public LogEntry logWarning(String message, EObject reference) {
        return this.log(SeverityFactory.INSTANCE.createWarning(), message, reference);
    }

    public LogEntry logWarning(String message, Throwable th, EObject reference) {
        return this.log(SeverityFactory.INSTANCE.createWarning(), this.toString(message, th), reference);
    }

    public LogEntry logDebug(Throwable th) {
        return this.log(SeverityFactory.INSTANCE.createDebug(), this.toString(null, th), null);
    }

    public LogEntry logDebug(String message, Throwable th) {
        return this.log(SeverityFactory.INSTANCE.createDebug(), this.toString(message, th), null);
    }

    public LogEntry logDebug(String message, EObject reference) {
        return this.log(SeverityFactory.INSTANCE.createDebug(), message, reference);
    }

    public LogEntry logDebug(String message) {
        return this.log(SeverityFactory.INSTANCE.createDebug(), message, null);
    }

    public LogEntry logDebug(String message, Throwable th, EObject reference) {
        return this.log(SeverityFactory.INSTANCE.createDebug(), this.toString(message, th), reference);
    }

    public LogEntry logInfo(Throwable th) {
        return this.log(SeverityFactory.INSTANCE.createInfo(), this.toString(null, th), null);
    }

    public LogEntry logInfo(String message, Throwable th) {
        return this.log(SeverityFactory.INSTANCE.createInfo(), this.toString(message, th), null);
    }

    public LogEntry logInfo(String message) {
        return this.log(SeverityFactory.INSTANCE.createInfo(), message, null);
    }

    public LogEntry logInfo(String message, EObject reference) {
        return this.log(SeverityFactory.INSTANCE.createInfo(), message, reference);
    }

    public LogEntry logInfo(String message, Throwable th, EObject reference) {
        return this.log(SeverityFactory.INSTANCE.createInfo(), this.toString(message, th), reference);
    }
}

