/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.CommitAction;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceModelParticipant;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceSynchronizeParticipant;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.team.ui.synchronize.WorkingSetScope;
import org.eclipse.team.ui.synchronize.WorkspaceScope;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class SyncAction
extends WorkspaceTraversalAction {
    public void execute(IAction action) throws InvocationTargetException {
        IFile file;
        if (SyncAction.isOpenEditorForSingleFile() && (file = this.getSelectedFile()) != null && SyncAction.isOKToShowSingleFile(file)) {
            SyncAction.showSingleFileComparison(this.getShell(), (Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), (IResource)file, this.getTargetPage());
            return;
        }
        if (SyncAction.isShowModelSync()) {
            ResourceMapping[] mappings = this.getCVSResourceMappings();
            if (mappings.length == 0) {
                return;
            }
            SubscriberScopeManager manager = WorkspaceSubscriberContext.createWorkspaceScopeManager(mappings, true, CommitAction.isIncludeChangeSets(this.getShell(), CVSUIMessages.SyncAction_1));
            WorkspaceSubscriberContext context = WorkspaceSubscriberContext.createContext((ISynchronizationScopeManager)manager, 3);
            WorkspaceModelParticipant participant = new WorkspaceModelParticipant((SynchronizationContext)context);
            TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            participant.run(this.getTargetPart());
        } else {
            IResource[] resources = this.getResourcesToCompare(this.getWorkspaceSubscriber());
            if (resources == null || resources.length == 0) {
                return;
            }
            WorkspaceSynchronizeParticipant participant = (WorkspaceSynchronizeParticipant)SubscriberParticipant.getMatchingParticipant((String)"org.eclipse.team.cvs.ui.cvsworkspace-participant", (IResource[])resources);
            if (participant == null) {
                IWorkingSet[] sets;
                Object scope = this.includesAllCVSProjects(resources) ? new WorkspaceScope() : ((sets = this.getSelectedWorkingSets()) != null ? new WorkingSetScope(sets) : new ResourceScope(resources));
                participant = new WorkspaceSynchronizeParticipant((ISynchronizeScope)scope);
                TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            }
            participant.refresh(resources, this.getTargetPart().getSite());
        }
    }

    private static boolean isShowModelSync() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("enableModelSync");
    }

    private static boolean isOpenEditorForSingleFile() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("openCompareEditorForSingleFile");
    }

    private IWorkingSet[] getSelectedWorkingSets() {
        ResourceMapping[] mappings = this.getCVSResourceMappings();
        ArrayList<IWorkingSet> sets = new ArrayList<IWorkingSet>();
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (!(mapping.getModelObject() instanceof IWorkingSet)) {
                return null;
            }
            IWorkingSet set = (IWorkingSet)mapping.getModelObject();
            sets.add(set);
            ++n2;
        }
        if (sets.isEmpty()) {
            return null;
        }
        return sets.toArray(new IWorkingSet[sets.size()]);
    }

    private boolean includesAllCVSProjects(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() != 4) {
                return false;
            }
            ++n2;
        }
        IProject[] cvsProjects = this.getAllCVSProjects();
        return cvsProjects.length == resources.length;
    }

    private IProject[] getAllCVSProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<IProject> cvsProjects = new HashSet<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (RepositoryProvider.isShared((IProject)project) && RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId()) != null) {
                cvsProjects.add(project);
            }
            ++n2;
        }
        return cvsProjects.toArray(new IProject[cvsProjects.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOKToShowSingleFile(IFile file) {
        IModelProviderDescriptor[] descriptors;
        if (!SyncAction.isShowModelSync()) {
            return true;
        }
        IModelProviderDescriptor[] iModelProviderDescriptorArray = descriptors = ModelProvider.getModelProviderDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IModelProviderDescriptor descriptor = iModelProviderDescriptorArray[n2];
            try {
                IResource[] resources = descriptor.getMatchingResources(new IResource[]{file});
                if (resources.length > 0) {
                    ResourceMapping[] mappings;
                    ModelProvider provider = descriptor.getModelProvider();
                    ResourceMapping[] resourceMappingArray = mappings = provider.getMappings((IResource)file, ResourceMappingContext.LOCAL_CONTEXT, null);
                    int n3 = mappings.length;
                    int n4 = 0;
                    block3: while (n4 < n3) {
                        ResourceTraversal[] traversals;
                        ResourceMapping mapping = resourceMappingArray[n4];
                        ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
                        int n5 = traversals.length;
                        int n6 = 0;
                        block4: while (true) {
                            IResource[] tResources;
                            if (n6 >= n5) {
                                ++n4;
                                continue block3;
                            }
                            ResourceTraversal traversal = resourceTraversalArray[n6];
                            IResource[] iResourceArray = tResources = traversal.getResources();
                            int n7 = tResources.length;
                            int n8 = 0;
                            while (true) {
                                if (n8 >= n7) {
                                    ++n6;
                                    continue block4;
                                }
                                IResource tr = iResourceArray[n8];
                                if (!tr.equals((Object)file)) {
                                    return false;
                                }
                                ++n8;
                            }
                            break;
                        }
                    }
                }
            }
            catch (CoreException e) {
                CVSUIPlugin.log(e);
            }
            ++n2;
        }
        return true;
    }

    public static void showSingleFileComparison(Shell shell, Subscriber subscriber, IResource resource, IWorkbenchPage page) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                try {
                    subscriber.refresh(new IResource[]{resource}, 0, monitor);
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            });
            SyncInfo info = subscriber.getSyncInfo(resource);
            if (info == null) {
                return;
            }
            shell.getDisplay().syncExec(() -> {
                if (info.getKind() == 0) {
                    MessageDialog.openInformation((Shell)shell, (String)CVSUIMessages.SyncAction_noChangesTitle, (String)CVSUIMessages.SyncAction_noChangesMessage);
                } else {
                    SyncInfoCompareInput input = new SyncInfoCompareInput(subscriber.getName(), info);
                    OpenInCompareAction.openCompareEditor((CompareEditorInput)input, (IWorkbenchPage)page);
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handle((Throwable)e);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (TeamException e) {
            Utils.handle((Throwable)e);
        }
    }

    public static boolean isSingleFile(IResource[] resources) {
        return resources.length == 1 && resources[0].getType() == 1;
    }

    @Override
    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        return super.isEnabledForCVSResource(cvsResource) || cvsResource.getParent().isCVSFolder() && !cvsResource.isIgnored();
    }

    @Override
    public String getId() {
        return "org.eclipse.team.ui.synchronizeLast";
    }

    @Override
    public boolean isEnabled() {
        if (super.isEnabled()) {
            return true;
        }
        IWorkingSet[] sets = this.getSelectedWorkingSets();
        if (sets == null || sets.length == 0) {
            return false;
        }
        Set projects = this.getProjects(sets);
        boolean existsProjectToSynchronize = false;
        for (IProject project : projects) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            if (provider == null) continue;
            existsProjectToSynchronize = true;
            if (CVSProviderPlugin.getTypeId().equals(provider.getID())) continue;
            return false;
        }
        return existsProjectToSynchronize;
    }

    private Set getProjects(IWorkingSet[] sets) {
        HashSet<IProject> projects = new HashSet<IProject>();
        if (sets == null) {
            return projects;
        }
        IWorkingSet[] iWorkingSetArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet set = iWorkingSetArray[n2];
            IAdaptable[] ad = set.getElements();
            if (ad != null) {
                IAdaptable[] iAdaptableArray = ad;
                int n3 = ad.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable a = iAdaptableArray[n4];
                    IResource resource = (IResource)a.getAdapter(IResource.class);
                    if (resource != null) {
                        projects.add(resource.getProject());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return projects;
    }
}

