/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.amalgam.explorer.contextual.core.ExplorerActivator;
import org.eclipse.amalgam.explorer.contextual.core.ext.AbstractExtensionPointManager;
import org.eclipse.amalgam.explorer.contextual.core.filter.ICandidateElementFilter;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class CandidateElementFilterManager
extends AbstractExtensionPointManager {
    private static final String FILTER_CONF_ELEMENT_NAME = "candidateElementFilter";
    private static Map<String, ICandidateElementFilter> _filterRegistry;

    public static boolean accept(Object object) {
        Map<String, ICandidateElementFilter> filters = CandidateElementFilterManager.getFilters();
        if (filters.isEmpty()) {
            return true;
        }
        Set<String> filters_ids = filters.keySet();
        for (String filters_id : filters_ids) {
            ICandidateElementFilter iFilter = filters.get(filters_id);
            if (iFilter.accept(object)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, ICandidateElementFilter> getFilters() {
        if (_filterRegistry == null) {
            IConfigurationElement[] configurationElements;
            _filterRegistry = new HashMap<String, ICandidateElementFilter>();
            IConfigurationElement[] iConfigurationElementArray = configurationElements = CandidateElementFilterManager.getConfigurationElementsFor("org.eclipse.amalgam.explorer.contextual.core", FILTER_CONF_ELEMENT_NAME);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                String filter_id = iConfigurationElement.getAttribute("id");
                ICandidateElementFilter filter = CandidateElementFilterManager.createTypedInstance(iConfigurationElement, "class", ICandidateElementFilter.class);
                if (_filterRegistry.get(filter_id) == null) {
                    _filterRegistry.put(filter_id, filter);
                } else {
                    String filter_class = iConfigurationElement.getAttribute("class");
                    ExplorerActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.amalgam.explorer.contextual.core", "Filter ID : " + filter_id + " is shared by many filters. Only the folowing filter will be retained : " + filter_class));
                }
                ++n2;
            }
        }
        return _filterRegistry;
    }

    public static ICandidateElementFilter getFilter(String filterID) {
        ICandidateElementFilter result = CandidateElementFilterManager.getFilters().get(filterID);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("There is no filter with id = " + filterID);
    }
}

