/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.integration.sirius.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;
import org.polarsys.kitalpha.ad.common.utils.URIHelper;
import org.polarsys.kitalpha.ad.integration.sirius.Activator;
import org.polarsys.kitalpha.ad.integration.sirius.actions.ServiceAction;
import org.polarsys.kitalpha.ad.integration.sirius.providers.SiriusSelectionProvider;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Service;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.edit.provider.ServiceItemProvider;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.edit.provider.ViewpointItemProvider;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.edit.provider.ViewpointItemProviderAdapterFactory;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ModelManager;
import org.polarsys.kitalpha.ad.viewpoint.integration.services.ServiceRunner;
import org.polarsys.kitalpha.ad.viewpoint.ui.provider.AFSelectionProvider;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class ServiceActionFactory
extends ExtensionContributionFactory {
    private final AFSelectionProvider selectionProvider = new SiriusSelectionProvider();

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        List selection = this.selectionProvider.getSelection();
        if (selection.isEmpty() || !(selection.get(0) instanceof EObject)) {
            return;
        }
        EObject selectedObj = (EObject)selection.get(0);
        MenuManager menu = new MenuManager("Viewpoint Services");
        try {
            this.fillMenu((IMenuManager)menu, selectedObj);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e);
        }
        additions.addContributionItem((IContributionItem)menu, null);
    }

    private void fillMenu(IMenuManager dynamicMenu, EObject selectedObj) {
        LinkedHashMap<Viewpoint, ModelManager> vp2mgr = new LinkedHashMap<Viewpoint, ModelManager>();
        HashMap<Viewpoint, List<ViewpointElement>> vp2elt = new HashMap<Viewpoint, List<ViewpointElement>>();
        this.computeActiveServices(vp2mgr, vp2elt, selectedObj);
        ViewpointItemProviderAdapterFactory adapterFactory = new ViewpointItemProviderAdapterFactory();
        ViewpointItemProvider provider = (ViewpointItemProvider)adapterFactory.createViewpointAdapter();
        Object url = provider.getImage(null);
        ImageDescriptor vpImage = ExtendedImageRegistry.getInstance().getImageDescriptor(url);
        url = ((ServiceItemProvider)adapterFactory.createServiceAdapter()).getImage(null);
        ImageDescriptor actionImage = ExtendedImageRegistry.getInstance().getImageDescriptor(url);
        for (Viewpoint vp : vp2mgr.keySet()) {
            ModelManager vpMgr = (ModelManager)vp2mgr.get(vp);
            if (!vp2elt.containsKey(vp)) continue;
            MenuManager mi = new MenuManager(vp.getName());
            mi.setImageDescriptor(vpImage);
            dynamicMenu.add((IContributionItem)mi);
            for (ViewpointElement elt : (List)vp2elt.get(vp)) {
                ServiceAction action = new ServiceAction(vpMgr, (Service)elt, this.selectionProvider);
                action.setText(elt.getName() == null ? "no name" : elt.getName());
                action.setImageDescriptor(actionImage);
                mi.add((IAction)action);
            }
        }
    }

    private void computeActiveServices(Map<Viewpoint, ModelManager> vp2mgr, Map<Viewpoint, List<ViewpointElement>> vp2elt, EObject selectedObj) {
        Viewpoint[] viewpointArray = this.sort(this.getAvailableViewpoints());
        int n = viewpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Viewpoint vp = viewpointArray[n2];
            if (selectedObj != null && !vp.isAbstract() && ViewpointManager.getInstance((EObject)selectedObj).isActive(vp.getId())) {
                ModelManager vpMgr = ModelManager.createWorkspaceManager((Viewpoint)vp);
                vp2mgr.put(vp, vpMgr);
                ServiceRunner runner = new ServiceRunner();
                for (ViewpointElement elt : this.sort(vpMgr.getServiceHandler().getElements())) {
                    Service action = (Service)elt;
                    if (!runner.canRun(action, vpMgr, this.selectionProvider.getSelection())) continue;
                    List<ViewpointElement> list = vp2elt.get(vp);
                    if (list == null) {
                        list = new ArrayList<ViewpointElement>();
                        vp2elt.put(vp, list);
                    }
                    list.add(elt);
                }
            }
            ++n2;
        }
    }

    public Viewpoint[] getAvailableViewpoints() {
        ArrayList<Viewpoint> vps = new ArrayList<Viewpoint>();
        Resource[] resources = ViewpointManager.getAvailableViewpoints();
        ResourceSetImpl set = new ResourceSetImpl();
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            String path2 = resource.getPath();
            if (path2 != null && !"".equals(path2)) {
                URI uri = URIHelper.createURI((Resource)resource);
                try {
                    Viewpoint vp = (Viewpoint)set.getEObject(uri, true);
                    vps.add(vp);
                }
                catch (Exception e) {
                    Activator.getDefault().logWarning(e);
                }
            }
            ++n2;
        }
        Viewpoint[] array = vps.toArray(new Viewpoint[vps.size()]);
        return array;
    }

    private Viewpoint[] sort(Viewpoint[] vps) {
        Arrays.sort(vps, new Comparator<Viewpoint>(){

            @Override
            public int compare(Viewpoint arg0, Viewpoint arg1) {
                String name0 = arg0.getName() == null ? "" : arg0.getName();
                String name1 = arg1.getName() == null ? "" : arg1.getName();
                return name0.compareTo(name1);
            }
        });
        return vps;
    }

    private List<ViewpointElement> sort(List<ViewpointElement> elements) {
        Collections.sort(elements, new Comparator<ViewpointElement>(){

            @Override
            public int compare(ViewpointElement arg0, ViewpointElement arg1) {
                String name0 = arg0.getName() == null ? "" : arg0.getName();
                String name1 = arg1.getName() == null ? "" : arg1.getName();
                return name0.compareTo(name1);
            }
        });
        return elements;
    }
}

