/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.DiagramNameEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ToolBasedLabelDirectEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusEditPartFactory;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusElementTypes;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusParserProvider;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public final class DefaultDirectEditOperation {
    private DefaultDirectEditOperation() {
    }

    public static void performDirectEditRequest(final IDiagramElementEditPart self, Request request, final SiriusWrapLabel figure) {
        final Request theRequest = request;
        try {
            self.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (self.isActive() && self.isEditModeEnabled() && DefaultDirectEditOperation.hasDirectEditTool(self)) {
                        DefaultTextAwareEditPart defaultTextAwareEditPart = new DefaultTextAwareEditPart(self.getNotationView(), (IFigure)figure, self.getViewer());
                        defaultTextAwareEditPart.setParent((EditPart)self);
                        if (!DefaultDirectEditOperation.isFigureAlreadyExist(self, figure)) {
                            DiagramNameEditPartOperation.refreshFont(defaultTextAwareEditPart);
                            if (figure.getParent() == null) {
                                figure.setParent(self.getFigure());
                            }
                            figure.setLocation(self.getFigure().getBounds().getTop());
                        }
                        TextDirectEditManager editManager = new TextDirectEditManager((GraphicalEditPart)defaultTextAwareEditPart, SiriusEditPartFactory.getTextCellEditorClass((GraphicalEditPart)defaultTextAwareEditPart), SiriusEditPartFactory.getTextCellEditorLocator(defaultTextAwareEditPart));
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            DefaultDirectEditOperation.performDirectEdit(self, initialChar.charValue(), (DirectEditManager)editManager);
                        } else if (theRequest instanceof DirectEditRequest && defaultTextAwareEditPart.getEditText().equals(defaultTextAwareEditPart.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            DefaultDirectEditOperation.performDirectEdit(self, editRequest.getLocation(), (DirectEditManager)editManager);
                        } else {
                            DefaultDirectEditOperation.performDirectEdit(self, (DirectEditManager)editManager);
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            DiagramPlugin.getDefault().logError(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean hasDirectEditTool(IDiagramElementEditPart part) {
        DDiagramElement elt = part.resolveDiagramElement();
        if (elt != null) {
            RepresentationElementMapping mapping = elt.getMapping();
            return mapping instanceof DiagramElementMapping && ((DiagramElementMapping)mapping).getLabelDirectEdit() != null;
        }
        return false;
    }

    private static boolean isFigureAlreadyExist(IDiagramElementEditPart self, SiriusWrapLabel figure) {
        for (Object obj : self.getChildren()) {
            AbstractGraphicalEditPart ep;
            if (!(obj instanceof AbstractGraphicalEditPart) || (ep = (AbstractGraphicalEditPart)obj).getContentPane() == null || !ep.getContentPane().getChildren().contains(figure)) continue;
            return true;
        }
        return false;
    }

    private static void performDirectEdit(IDiagramElementEditPart self, char initialCharacter, DirectEditManager editManager) {
        if (editManager instanceof TextDirectEditManager) {
            ((TextDirectEditManager)editManager).show(initialCharacter);
        } else {
            DefaultDirectEditOperation.performDirectEdit(self, editManager);
        }
    }

    private static void performDirectEdit(IDiagramElementEditPart self, DirectEditManager editManager) {
        editManager.show();
    }

    private static void performDirectEdit(IDiagramElementEditPart self, Point eventLocation, DirectEditManager editManager) {
        if (editManager.getClass() == TextDirectEditManager.class) {
            ((TextDirectEditManager)editManager).show(eventLocation.getSWTPoint());
        }
    }

    private static class DefaultTextAwareEditPart
    extends AbstractDiagramNameEditPart {
        private IFigure label;
        private IParser parser;
        private EditPartViewer viewer;

        DefaultTextAwareEditPart(View modelView, IFigure label, EditPartViewer viewer) {
            super(modelView);
            this.label = label;
            this.viewer = viewer;
            this.installEditPolicy("direct edit", (EditPolicy)new ToolBasedLabelDirectEditPolicy(this.getEditingDomain()));
        }

        public EditPartViewer getViewer() {
            return this.viewer;
        }

        @Override
        public void setLabel(IFigure label) {
            this.label = label;
        }

        public IContentAssistProcessor getCompletionProcessor() {
            return null;
        }

        public String getEditText() {
            if (this.resolveSemanticElement() == null || this.getParser() == null) {
                return "";
            }
            return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.resolveSemanticElement()), this.getParserOptions().intValue());
        }

        public ICellEditorValidator getEditTextValidator() {
            return new ICellEditorValidator(){

                public String isValid(final Object value) {
                    if (value instanceof String) {
                        final EObject element = this.resolveSemanticElement();
                        final IParser iParser = this.getParser();
                        try {
                            IParserEditStatus valid = (IParserEditStatus)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                                public void run() {
                                    this.setResult(iParser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                                }
                            });
                            return valid.getCode() == 0 ? null : valid.getMessage();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return null;
                }
            };
        }

        public IParser getParser() {
            if (this.parser == null) {
                String parserHint = Integer.toString(5002);
                SiriusParserProvider.HintAdapter hintAdapter = new SiriusParserProvider.HintAdapter(SiriusElementTypes.DNode_2001, this.resolveSemanticElement(), parserHint);
                this.parser = ParserService.getInstance().getParser((IAdaptable)hintAdapter);
            }
            return this.parser;
        }

        public ParserOptions getParserOptions() {
            return ParserOptions.NONE;
        }

        public void setLabelText(String text) {
        }

        public String getLabelText() {
            String text = null;
            EObject parserElement = this.resolveSemanticElement();
            if (parserElement != null && this.getParser() != null) {
                text = this.getParser().getPrintString((IAdaptable)new EObjectAdapter(parserElement), this.getParserOptions().intValue());
            }
            if (text == null || text.length() == 0) {
                text = "";
            }
            return text;
        }

        public IFigure getFigure() {
            return this.label;
        }
    }
}

