/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist;

import com.google.inject.Inject;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.RequiredExecutionEnvironmentHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.Configuration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.ConfigurationElement;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.ExtensionGeneratrionConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.GData;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.Generation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.GenerationConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.Release;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.TargetApplication;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.ViewConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdiagram.configuration.DiagramGenerationConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.services.VpconfGrammarAccess;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.AbstractVpconfProposalProvider;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.TargetApplicationReader;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.doc.model.docGenConfiguration.DocumentationGenerationConfiguration;

public class VpconfProposalProvider
extends AbstractVpconfProposalProvider {
    private static final String SPACE = " ";
    private static final String QUOTES = "\"";
    private static final Image image;
    static final String JDT_PLUGIN_ID = "org.eclipse.jdt.ui";
    static final String LIB_ICON_PATH = "icons/full/obj16/library_obj.png";
    @Inject
    private IGrammarAccess grammar;

    static {
        Bundle jdtBundle = Platform.getBundle((String)JDT_PLUGIN_ID);
        URL url = FileLocator.find((Bundle)jdtBundle, (IPath)new Path(LIB_ICON_PATH), Collections.emptyMap());
        image = ImageDescriptor.createFromURL((URL)url).createImage();
    }

    @Override
    public void completeTargetApplication_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List<String> targetPlatformProposals = TargetApplicationReader.getSupportedModelingEnvironment();
        for (String proposal : targetPlatformProposals) {
            if (proposal.contains(SPACE)) {
                proposal = QUOTES + proposal + QUOTES;
            }
            acceptor.accept(this.createCompletionProposal(proposal, context));
        }
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        if (this.grammar instanceof VpconfGrammarAccess) {
            VpconfGrammarAccess access = (VpconfGrammarAccess)this.grammar;
            ICompletionProposal proposal = this.createCompletionProposal(keyword.getValue(), this.getKeywordDisplayString(keyword), this.getImage((EObject)keyword), contentAssistContext);
            EObject current = contentAssistContext.getCurrentModel();
            if (current != null && NodeModelUtils.getNode((EObject)current) != null && proposal != null) {
                String text;
                INode nextSibling;
                ICompositeNode rootNode = NodeModelUtils.getNode((EObject)current).getRootNode();
                EObject root = NodeModelUtils.findActualSemanticObjectFor((INode)rootNode);
                if (root != null && root instanceof Configuration) {
                    Configuration configAspect = (Configuration)root;
                    for (ConfigurationElement ce : configAspect.getVpConfigurationElements()) {
                        if (ce instanceof ViewConfiguration && proposal.getDisplayString().matches(access.getViewConfigurationAccess().getViewKeyword_1().getValue())) {
                            return;
                        }
                        if (ce instanceof GenerationConfiguration) {
                            if (proposal.getDisplayString().matches(access.getGenerationConfigurationAccess().getProjectKeyword_1().getValue())) {
                                return;
                            }
                            if (proposal.getDisplayString().matches(access.getGenerationConfigurationAccess().getNsuriKeyword_3_0().getValue())) {
                                return;
                            }
                        }
                        if (ce instanceof TargetApplication && proposal.getDisplayString().matches(access.getTargetApplicationAccess().getTargetKeyword_1().getValue())) {
                            return;
                        }
                        if (ce instanceof Generation) {
                            Generation gen = (Generation)ce;
                            if (proposal.getDisplayString().matches(access.getGenerationAccess().getGenerationKeyword_1().getValue())) {
                                return;
                            }
                            EList listConfig = gen.getOwnedExtensionGenConf();
                            for (ExtensionGeneratrionConfiguration confOpt : listConfig) {
                                if (confOpt instanceof GData && proposal.getDisplayString().matches(access.getGDataAccess().getDataKeyword_1().getValue())) {
                                    return;
                                }
                                if (confOpt instanceof DiagramGenerationConfiguration && proposal.getDisplayString().matches(access.getDiagramGenerationConfigurationAccess().getDiagramKeyword_1().getValue())) {
                                    return;
                                }
                                if (!(confOpt instanceof DocumentationGenerationConfiguration) || !proposal.getDisplayString().matches(access.getDocumentationGenerationConfigurationAccess().getDocumentationKeyword_1().getValue())) continue;
                                return;
                            }
                            INode currentNode = contentAssistContext.getCurrentNode();
                            INode nextNode = currentNode.getNextSibling();
                            while (nextNode != null && !nextNode.getText().equals(")")) {
                                if (nextNode.getText().equals(proposal.getDisplayString())) {
                                    return;
                                }
                                nextNode = nextNode.getNextSibling();
                            }
                        }
                        if (!(ce instanceof Release) || !proposal.getDisplayString().matches(access.getReleaseAccess().getReleaseKeyword_1().getValue())) continue;
                        return;
                    }
                }
                INode currentNode = contentAssistContext.getCurrentNode();
                if (proposal.getDisplayString().matches(access.getGenerationConfigurationAccess().getNsuriKeyword_3_0().getValue()) && (nextSibling = currentNode.getNextSibling()) != null && (text = nextSibling.getText()).equals(access.getViewConfigurationAccess().getViewKeyword_1().getValue())) {
                    return;
                }
                if (proposal.getDisplayString().matches(access.getViewConfigurationAccess().getViewKeyword_1().getValue()) && (nextSibling = currentNode.getNextSibling()) != null && (text = nextSibling.getText()).equals(access.getGenerationAccess().getGenerationKeyword_1().getValue())) {
                    return;
                }
                if (proposal.getDisplayString().matches(access.getGenerationAccess().getGenerationKeyword_1().getValue()) && (nextSibling = currentNode.getNextSibling()) != null && (text = nextSibling.getText()).equals(access.getViewConfigurationAccess().getViewKeyword_1().getValue())) {
                    return;
                }
                this.getPriorityHelper().adjustKeywordPriority(proposal, contentAssistContext.getPrefix());
                acceptor.accept(proposal);
            }
        }
    }

    @Override
    public void completeRelease_RequiredExecutionEnvironment(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Collection availableExecutionEnvironements = RequiredExecutionEnvironmentHelper.getAvailableExecutionEnvironement();
        for (String jre : availableExecutionEnvironements) {
            if (!context.getMatcher().isCandidateMatchingPrefix(jre, context.getPrefix())) continue;
            String jre2 = QUOTES + jre + QUOTES;
            acceptor.accept(this.createCompletionProposal(jre2, new StyledString(jre), image, context));
        }
    }
}

