/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.ordering;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.ext.base.Option;

public final class EventEndHelper {
    public static final Function<ISequenceEvent, List<EventEnd>> EVENT_ENDS = new Function<ISequenceEvent, List<EventEnd>>(){

        public List<EventEnd> apply(ISequenceEvent from) {
            return EventEndHelper.findEndsFromSemanticOrdering(from);
        }
    };
    public static final Function<EventEnd, EObject> SEMANTIC_END = new Function<EventEnd, EObject>(){

        public EObject apply(EventEnd from) {
            return from.getSemanticEnd();
        }
    };
    public static final Predicate<SingleEventEnd> IS_START = new Predicate<SingleEventEnd>(){

        public boolean apply(SingleEventEnd from) {
            return from.isStart();
        }
    };
    public static final Predicate<EventEnd> PUNCTUAL_COMPOUND_EVENT_END = new Predicate<EventEnd>(){

        public boolean apply(EventEnd input) {
            return input instanceof CompoundEventEnd && EventEndHelper.getSemanticEvents(input).size() == 1;
        }
    };

    private EventEndHelper() {
    }

    public static List<EObject> getSemanticEvents(EventEnd eventEnd) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (eventEnd instanceof SingleEventEnd) {
            result.add(((SingleEventEnd)eventEnd).getSemanticEvent());
        } else if (eventEnd instanceof CompoundEventEnd) {
            result.addAll((Collection<EObject>)((CompoundEventEnd)eventEnd).getSemanticEvents());
        }
        return result;
    }

    public static SingleEventEnd getSingleEventEnd(EventEnd eventEnd, EObject semanticEvent) {
        SingleEventEnd result;
        block3: {
            block2: {
                result = null;
                if (!(eventEnd instanceof SingleEventEnd)) break block2;
                SingleEventEnd see = (SingleEventEnd)eventEnd;
                if (semanticEvent == null || !semanticEvent.equals(see.getSemanticEvent())) break block3;
                result = see;
                break block3;
            }
            if (eventEnd instanceof CompoundEventEnd) {
                CompoundEventEnd cee = (CompoundEventEnd)eventEnd;
                for (SingleEventEnd see : cee.getEventEnds()) {
                    if (semanticEvent == null || !semanticEvent.equals(see.getSemanticEvent())) continue;
                    result = see;
                    break;
                }
            }
        }
        return result;
    }

    public static List<EventEnd> findEndsFromSemanticOrdering(ISequenceEvent part) {
        ArrayList<EventEnd> ends = new ArrayList<EventEnd>();
        SequenceDiagram sdep = part.getDiagram();
        SequenceDDiagram seqDiag = (SequenceDDiagram)sdep.getNotationDiagram().getElement();
        Option<EObject> semanticEvent = part.getSemanticTargetElement();
        for (EventEnd ee : seqDiag.getSemanticOrdering().getEventEnds()) {
            if (!semanticEvent.some() || !EventEndHelper.getSemanticEvents(ee).contains(semanticEvent.get())) continue;
            ends.add(ee);
        }
        return ends;
    }

    public static Iterable<ISequenceEvent> getIndependantEvents(ISequenceEvent self, Collection<ISequenceEvent> childrenEvents) {
        final List<EventEnd> parentEnds = EventEndHelper.findEndsFromSemanticOrdering(self);
        Predicate<ISequenceEvent> isValidSubEvent = new Predicate<ISequenceEvent>(){

            public boolean apply(ISequenceEvent input) {
                List<EventEnd> inputEnds = EventEndHelper.findEndsFromSemanticOrdering(input);
                boolean res = inputEnds.removeAll(parentEnds);
                return !res;
            }
        };
        return Iterables.filter(childrenEvents, (Predicate)isValidSubEvent);
    }

    public static List<ISequenceEvent> getCompoundEvents(ISequenceEvent self) {
        ArrayList<ISequenceEvent> compoundEvents = new ArrayList<ISequenceEvent>();
        SequenceDiagram sdep = self.getDiagram();
        EObject semanticEvent = (EObject)self.getSemanticTargetElement().get();
        List<EventEnd> ends = EventEndHelper.findEndsFromSemanticOrdering(self);
        for (CompoundEventEnd cee : Iterables.filter(ends, CompoundEventEnd.class)) {
            for (SingleEventEnd see : cee.getEventEnds()) {
                ISequenceEvent ise;
                if (see.getSemanticEvent() == semanticEvent || (ise = EventEndHelper.findISequenceEvent(see, sdep)) == null) continue;
                compoundEvents.add(ise);
            }
        }
        return compoundEvents;
    }

    public static ISequenceEvent findISequenceEvent(SingleEventEnd end, SequenceDiagram sdep) {
        for (ISequenceEvent iSequenceEvent : sdep.getAllDelimitedSequenceEvents()) {
            Option<EObject> semanticEvent = iSequenceEvent.getSemanticTargetElement();
            if (!semanticEvent.some() || !end.getSemanticEvent().equals(semanticEvent.get())) continue;
            return iSequenceEvent;
        }
        return null;
    }
}

