/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.provider;

import com.google.common.base.Joiner;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.common.ui.business.api.views.properties.tabbed.LabelProviderProviderService;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class DTableLabelProvider
extends LabelProvider {
    private LabelProviderProviderService labelProviderProviderService = new LabelProviderProviderService();
    private AdapterFactoryLabelProvider adapterFactoryLabelProvider;

    public Image getImage(Object object) {
        Image labelImage = null;
        ILabelProvider firstProvidedLabelProvider = this.labelProviderProviderService.getFirstProvidedLabelProvider(object);
        if (firstProvidedLabelProvider != null) {
            labelImage = firstProvidedLabelProvider.getImage(object);
        } else {
            Object tempObject = object;
            if (object != null && !object.equals(StructuredSelection.EMPTY)) {
                List<?> semanticSelection;
                if (object instanceof IStructuredSelection && !(semanticSelection = this.extractSemanticSelection(((IStructuredSelection)object).toList())).isEmpty() && !this.containsDifferentTypes(semanticSelection)) {
                    tempObject = semanticSelection.iterator().next();
                }
                if (tempObject instanceof EObject || tempObject instanceof Resource) {
                    labelImage = this.getAdapterFactoryLabelProvider().getImage(tempObject);
                }
            }
        }
        return labelImage;
    }

    public String getText(Object object) {
        String text = null;
        ILabelProvider firstProvidedLabelProvider = this.labelProviderProviderService.getFirstProvidedLabelProvider(object);
        if (firstProvidedLabelProvider != null) {
            text = firstProvidedLabelProvider.getText(object);
        } else {
            int selectionSize = 0;
            Object tempObject = object;
            List<Object> semanticSelection = Collections.emptyList();
            if (object != null && !object.equals(StructuredSelection.EMPTY) && object instanceof IStructuredSelection) {
                semanticSelection = this.extractSemanticSelection(((IStructuredSelection)object).toList());
                selectionSize = semanticSelection.size();
                if (this.containsDifferentTypes(semanticSelection)) {
                    text = MessageFormat.format(Messages.DTableLabelProvider_nbSelectedItems, selectionSize);
                } else if (!semanticSelection.isEmpty()) {
                    tempObject = semanticSelection.iterator().next();
                }
            }
            if (tempObject != null) {
                text = this.getAdapterFactoryLabelProvider().getText(tempObject);
            }
            if (selectionSize > 1) {
                ArrayList<String> labels = new ArrayList<String>();
                for (Object t : semanticSelection) {
                    labels.add(this.getAdapterFactoryLabelProvider().getText(t));
                }
                text = MessageFormat.format(Messages.DTableLabelProvider_selectedItemsList, selectionSize, Joiner.on((String)", ").join(labels));
            }
        }
        return text;
    }

    private AdapterFactoryLabelProvider getAdapterFactoryLabelProvider() {
        IEditorPart editor;
        if (this.adapterFactoryLabelProvider == null && (editor = EclipseUIUtil.getActiveEditor()) instanceof AbstractDTreeEditor) {
            this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(((AbstractDTreeEditor)editor).getAdapterFactory());
        }
        return this.adapterFactoryLabelProvider;
    }

    private List<?> extractSemanticSelection(List<?> selection) {
        ArrayList semanticSelection = new ArrayList();
        Iterator<?> iterator = selection.iterator();
        while (iterator.hasNext()) {
            EObject target;
            Object obj;
            Object sel = obj = iterator.next();
            if (obj instanceof DSemanticDecorator && (target = ((DSemanticDecorator)obj).getTarget()) != null) {
                sel = target;
            }
            semanticSelection.add(sel);
        }
        return semanticSelection;
    }

    private boolean containsDifferentTypes(List<?> selection) {
        boolean areDistinct = false;
        if (selection.size() > 1) {
            Iterator<?> iterator = selection.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!iterator.hasNext() || iterator.next().getClass() == element.getClass()) continue;
                areDistinct = true;
            }
        }
        return areDistinct;
    }
}

