/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.ISequenceNodeMoveOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.ReparentExecutionOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SetMessageRangeOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.VerticalSpaceExpansionOrReduction;
import org.eclipse.sirius.diagram.sequence.business.internal.util.EventFinder;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ShiftMessagesOperation;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.ISEComplexMoveValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;

public class ISEComplexMoveCommandBuilder {
    private final TransactionalEditingDomain editingDomain;
    private final String label;
    private final RequestQuery requestQuery;
    private final ISEComplexMoveValidator validator;

    public ISEComplexMoveCommandBuilder(TransactionalEditingDomain editingDomain, String label, RequestQuery requestQuery, ISEComplexMoveValidator validator) {
        this.editingDomain = editingDomain;
        this.label = label;
        this.requestQuery = requestQuery;
        this.validator = validator;
    }

    public CompositeTransactionalCommand buildCommand() {
        CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(this.editingDomain, this.label);
        Integer vMove = this.requestQuery.getLogicalDelta().y;
        this.expandDiagram(ctc, vMove);
        this.handleNodes(ctc, vMove);
        this.handleMessages(ctc, vMove);
        return ctc;
    }

    private void handleMessages(CompositeTransactionalCommand ctc, Integer vMove) {
        this.shiftMessages(ctc, vMove);
        this.resizeMessages(ctc, vMove);
        this.reconnectMessages(ctc, vMove);
    }

    private void handleNodes(CompositeTransactionalCommand ctc, Integer vMove) {
        ArrayList<ISequenceNode> seqNodesToMove = new ArrayList<ISequenceNode>(this.validator.getSequenceNodeToMove());
        HashMap<AbstractNodeEvent, ISequenceEvent> reparents = new HashMap<AbstractNodeEvent, ISequenceEvent>();
        this.computeReparents(seqNodesToMove, reparents);
        this.moveNodes(ctc, vMove, seqNodesToMove);
        this.reparentNodes(ctc, vMove, reparents);
    }

    private void reconnectMessages(CompositeTransactionalCommand ctc, Integer vMove) {
        for (Reconnection reconnection : this.computeReconnections()) {
            Message message = reconnection.getMessage();
            ISequenceNode source = reconnection.getSource();
            ISequenceNode target = reconnection.getTarget();
            Rectangle srcBounds = source.getProperLogicalBounds();
            Rectangle tgtBounds = target.getProperLogicalBounds();
            Collection<ISequenceEvent> movedElements = this.validator.getMovedElements();
            if (movedElements.contains(source)) {
                srcBounds = this.requestQuery.getLogicalTransformedRectangle(srcBounds);
            }
            if (movedElements.contains(target)) {
                tgtBounds = this.requestQuery.getLogicalTransformedRectangle(tgtBounds);
            }
            Range newRange = movedElements.contains(message) ? message.getVerticalRange().shifted(vMove.intValue()) : message.getVerticalRange();
            SetMessageRangeOperation smrc = new SetMessageRangeOperation((Edge)message.getNotationView(), newRange);
            smrc.setSource((View)source.getNotationNode(), srcBounds);
            smrc.setTarget((View)target.getNotationNode(), tgtBounds);
            ctc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)this.editingDomain, (AbstractModelChangeOperation)smrc));
        }
    }

    private void reparentNodes(CompositeTransactionalCommand ctc, Integer vMove, Map<AbstractNodeEvent, ISequenceEvent> reparents) {
        for (Map.Entry<AbstractNodeEvent, ISequenceEvent> entry : reparents.entrySet()) {
            ISequenceEvent newParent = entry.getValue();
            ctc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)this.editingDomain, (AbstractModelChangeOperation)new ReparentExecutionOperation(entry.getKey(), newParent)));
            Rectangle realLocation = entry.getKey().getProperLogicalBounds();
            if (this.validator.getMovedElements().contains(entry.getKey())) {
                realLocation = this.requestQuery.getLogicalTransformedRectangle(realLocation);
            }
            Rectangle parentBounds = newParent.getProperLogicalBounds();
            if (this.validator.getMovedElements().contains(newParent)) {
                parentBounds = this.requestQuery.getLogicalTransformedRectangle(parentBounds);
            }
            Range futureRange = (Range)this.validator.getRangeFunction().apply((Object)((ISequenceEvent)entry.getKey()));
            realLocation.y = futureRange.getLowerBound();
            Point parentOrigin = parentBounds.getLocation();
            Dimension d = realLocation.getTopLeft().getDifference(parentOrigin);
            Point locationOnFinalParent = new Point(realLocation.x, d.height);
            SetBoundsCommand moveCommand = new SetBoundsCommand(ctc.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)entry.getKey().getNotationNode()), locationOnFinalParent);
            ctc.compose((IUndoableOperation)moveCommand);
        }
    }

    private void shiftMessages(CompositeTransactionalCommand ctc, Integer vMove) {
        ICommand messageMoveCommand = CommandFactory.createICommand((TransactionalEditingDomain)this.editingDomain, (AbstractModelChangeOperation)new ShiftMessagesOperation(this.validator.getMessageToMove(), this.validator.getMovedElements(), vMove, false, true));
        ctc.add((IUndoableOperation)messageMoveCommand);
    }

    private void resizeMessages(CompositeTransactionalCommand ctc, Integer vMove) {
        for (Message msg : Iterables.concat(this.validator.getResizedStartMessages(), this.validator.getResizedEndMessages())) {
            SetMessageRangeOperation smrc = new SetMessageRangeOperation(msg.getNotationEdge(), (Range)this.validator.getRangeFunction().apply((Object)msg));
            ISequenceEvent src = (ISequenceEvent)msg.getSourceElement();
            Range srcRange = (Range)this.validator.getRangeFunction().apply((Object)src);
            smrc.setSource(src.getNotationView(), new Rectangle(0, srcRange.getLowerBound(), 0, srcRange.getUpperBound()));
            ISequenceEvent tgt = (ISequenceEvent)msg.getTargetElement();
            Range tgtRange = (Range)this.validator.getRangeFunction().apply((Object)tgt);
            smrc.setTarget(tgt.getNotationView(), new Rectangle(0, tgtRange.getLowerBound(), 0, tgtRange.getUpperBound()));
            ICommand resizeStartMessages = CommandFactory.createICommand((TransactionalEditingDomain)this.editingDomain, (AbstractModelChangeOperation)smrc);
            ctc.add((IUndoableOperation)resizeStartMessages);
        }
    }

    private void moveNodes(CompositeTransactionalCommand ctc, Integer vMove, Collection<ISequenceNode> seqNodesToMove) {
        ICommand moveExecCmd = CommandFactory.createICommand((TransactionalEditingDomain)this.editingDomain, (AbstractModelChangeOperation)new ISequenceNodeMoveOperation(seqNodesToMove, vMove.intValue()));
        ctc.compose((IUndoableOperation)moveExecCmd);
        ctc.setLabel(moveExecCmd.getLabel());
    }

    private void expandDiagram(CompositeTransactionalCommand ctc, Integer vMove) {
        if (this.validator.getExpansionZone() != null && !this.validator.getExpansionZone().isEmpty()) {
            ctc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)this.editingDomain, (AbstractModelChangeOperation)new VerticalSpaceExpansionOrReduction(this.validator.getDiagram(), this.validator.getExpansionZone(), vMove, this.validator.getMovedElements())));
        }
    }

    private void computeReparents(Collection<ISequenceNode> sequenceNodesToMove, Map<AbstractNodeEvent, ISequenceEvent> reparents) {
        ArrayList movedExecutions = Lists.newArrayList((Iterable)Iterables.filter(sequenceNodesToMove, AbstractNodeEvent.class));
        ArrayList unmovedExecutions = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.validator.getDiagram().getAllAbstractNodeEvents(), (Predicate)Predicates.not((Predicate)Predicates.in(this.validator.getMovedElements()))));
        for (AbstractNodeEvent execToReparent : Iterables.concat((Iterable)movedExecutions, (Iterable)unmovedExecutions)) {
            ISequenceEvent potentialParent = this.getNewParent(execToReparent, reparents);
            if (!(potentialParent instanceof ISequenceNode) || potentialParent.equals(execToReparent.getHierarchicalParentEvent())) continue;
            reparents.put(execToReparent, potentialParent);
            sequenceNodesToMove.remove(execToReparent);
        }
    }

    private Collection<Reconnection> computeReconnections() {
        ArrayList<Reconnection> reconnections = new ArrayList<Reconnection>();
        for (Message message : this.validator.getDiagram().getAllMessages()) {
            ISequenceNode targetElement;
            ISequenceNode sourceElement = message.getSourceElement();
            ISequenceNode newSource = this.getNewReconnectionEnd(message, sourceElement);
            ISequenceNode newTarget = targetElement = message.getTargetElement();
            if (targetElement instanceof ISequenceEvent) {
                newTarget = this.getNewReconnectionEnd(message, targetElement);
            }
            if (sourceElement.equals(newSource) && targetElement.equals(newTarget)) continue;
            Reconnection rec = new Reconnection(message, newSource, newTarget);
            reconnections.add(rec);
        }
        return reconnections;
    }

    private ISequenceEvent getNewParent(AbstractNodeEvent movedExec, Map<AbstractNodeEvent, ISequenceEvent> reparents) {
        EventFinder newParentFinder = new EventFinder((Lifeline)movedExec.getLifeline().get());
        newParentFinder.setReparent(true);
        newParentFinder.setVerticalRangefunction(this.validator.getRangeFunction());
        newParentFinder.setEventsToIgnore(Predicates.equalTo((Object)movedExec));
        newParentFinder.setReparented(reparents);
        Range futureRange = (Range)this.validator.getRangeFunction().apply((Object)movedExec);
        Range lookedRange = new Range(futureRange.getLowerBound(), futureRange.getLowerBound());
        if (movedExec instanceof State && movedExec.isLogicallyInstantaneous()) {
            int mid = futureRange.middleValue();
            lookedRange = new Range(mid, mid);
        }
        ISequenceEvent potentialParent = newParentFinder.findMostSpecificEvent(lookedRange);
        return potentialParent;
    }

    private ISequenceNode getNewReconnectionEnd(Message message, ISequenceNode actualEnd) {
        boolean compoundEnds = false;
        if (message.isReflective() && actualEnd instanceof Execution) {
            Execution exec = (Execution)actualEnd;
            compoundEnds = exec.getLinkedMessages().contains(message);
        }
        boolean bothMoved = false;
        boolean bl = bothMoved = this.validator.getMovedElements().contains(message) && this.validator.getMovedElements().contains(actualEnd);
        if (!compoundEnds && !bothMoved && actualEnd instanceof ISequenceEvent) {
            EventFinder newEndFinder = new EventFinder((Lifeline)actualEnd.getLifeline().get());
            newEndFinder.setReconnection(true);
            Range lookedRange = (Range)this.validator.getRangeFunction().apply((Object)message);
            newEndFinder.setVerticalRangefunction(this.validator.getRangeFunction());
            ISequenceEvent potentialEnd = newEndFinder.findMostSpecificEvent(lookedRange);
            if (potentialEnd instanceof ISequenceNode) {
                return (ISequenceNode)potentialEnd;
            }
        }
        return actualEnd;
    }

    public static class Reconnection {
        final Message message;
        final ISequenceNode source;
        final ISequenceNode target;

        public Reconnection(Message message, ISequenceNode source, ISequenceNode target) {
            this.message = message;
            this.source = source;
            this.target = target;
        }

        public Message getMessage() {
            return this.message;
        }

        public ISequenceNode getSource() {
            return this.source;
        }

        public ISequenceNode getTarget() {
            return this.target;
        }
    }
}

