/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.build.BuildObject;
import org.eclipse.pde.internal.core.build.IBuildObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelUndoManager;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;

public class BuildUndoManager
extends ModelUndoManager {
    public BuildUndoManager(PDEFormEditor editor) {
        super(editor);
        this.setUndoLevelLimit(30);
    }

    @Override
    protected String getPageId(Object obj) {
        if (obj instanceof IBuildEntry) {
            return "build";
        }
        return null;
    }

    @Override
    protected void execute(IModelChangedEvent event, boolean undo) {
        Object[] elements = event.getChangedObjects();
        int type = event.getChangeType();
        String propertyName = event.getChangedProperty();
        IBuildModel model = (IBuildModel)event.getChangeProvider();
        switch (type) {
            case 1: {
                if (undo) {
                    this.executeRemove(model, elements);
                    break;
                }
                this.executeAdd(model, elements);
                break;
            }
            case 2: {
                if (undo) {
                    this.executeAdd(model, elements);
                    break;
                }
                this.executeRemove(model, elements);
                break;
            }
            case 3: {
                if (undo) {
                    this.executeChange(elements[0], propertyName, event.getNewValue(), event.getOldValue());
                    break;
                }
                this.executeChange(elements[0], propertyName, event.getOldValue(), event.getNewValue());
            }
        }
    }

    private void executeAdd(IBuildModel model, Object[] elements) {
        IBuild build = model.getBuild();
        try {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IBuildEntry) {
                    build.add((IBuildEntry)element);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeRemove(IBuildModel model, Object[] elements) {
        IBuild build = model.getBuild();
        try {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IBuildEntry) {
                    build.remove((IBuildEntry)element);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeChange(Object element, String propertyName, Object oldValue, Object newValue) {
        if (element instanceof BuildObject) {
            BuildObject bobj = (BuildObject)element;
            try {
                bobj.restoreProperty(propertyName, oldValue, newValue);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        IBuildObject bobj;
        Object obj;
        if (event.getChangeType() == 3 && (obj = event.getChangedObjects()[0]) instanceof IBuildObject && !((bobj = (IBuildObject)event.getChangedObjects()[0]) instanceof IBuild) && !bobj.isInTheModel()) {
            return;
        }
        super.modelChanged(event);
    }
}

