/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ecore.diagram.documentation;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.impl.EcoreFactoryImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryService;

public class DocumentationService {
    public static final String DOCUMENTATION_SOURCE = "http://www.polarsys.org/kitalpha/ecore/documentation";
    public static final String DESCRIPTION = "description";
    public static final String USAGE_GUIDELINE = "usage guideline";
    public static final String USED_IN_LEVELS = "used in levels";
    public static final String USAGE_EXAMPLES = "usage examples";
    public static final String CONSTRAINTS = "constraints";
    protected static final TransactionalEditingDomain editingDomain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain();

    public void createDocumentation(EModelElement receiver) {
        Collection<Object> documentation;
        if (DocumentationService.accept(receiver) && (documentation = this.getDocumentation(receiver)).isEmpty()) {
            EAnnotation eAnnotation = receiver.getEAnnotation(DOCUMENTATION_SOURCE);
            if (eAnnotation == null) {
                eAnnotation = this.creatDocumentationEAnnotation(receiver);
            }
            this.createEntry(eAnnotation, DESCRIPTION);
            this.createEntry(eAnnotation, USAGE_GUIDELINE);
            this.createEntry(eAnnotation, USED_IN_LEVELS);
            this.createEntry(eAnnotation, USAGE_EXAMPLES);
            this.createEntry(eAnnotation, CONSTRAINTS);
        }
    }

    public Collection<Object> getDocumentation(EModelElement receiver) {
        if (DocumentationService.accept(receiver)) {
            UniqueEList result = new UniqueEList();
            EAnnotation eAnnotation = receiver.getEAnnotation(DOCUMENTATION_SOURCE);
            if (eAnnotation != null) {
                Object contraintsEntry;
                Object usageExampleEntry;
                Object usageLevelEntry;
                Object usageGuidEntry;
                Object descriptionEntry = this.getEntry(eAnnotation, DESCRIPTION);
                if (descriptionEntry != null) {
                    result.add(descriptionEntry);
                }
                if ((usageGuidEntry = this.getEntry(eAnnotation, USAGE_GUIDELINE)) != null) {
                    result.add(usageGuidEntry);
                }
                if ((usageLevelEntry = this.getEntry(eAnnotation, USED_IN_LEVELS)) != null) {
                    result.add(usageLevelEntry);
                }
                if ((usageExampleEntry = this.getEntry(eAnnotation, USAGE_EXAMPLES)) != null) {
                    result.add(usageExampleEntry);
                }
                if ((contraintsEntry = this.getEntry(eAnnotation, CONSTRAINTS)) != null) {
                    result.add(contraintsEntry);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static boolean accept(EModelElement receiver) {
        return receiver instanceof EClassifier || receiver instanceof EPackage || receiver instanceof ETypedElement;
    }

    private EAnnotation creatDocumentationEAnnotation(final EModelElement receiver) {
        final EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setSource(DOCUMENTATION_SOURCE);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                receiver.getEAnnotations().add((Object)eAnnotation);
            }
        });
        return eAnnotation;
    }

    public void createEntry(final EAnnotation eAnnotation, String key) {
        Object existingEntry = this.getEntry(eAnnotation, key);
        if (existingEntry == null) {
            final EStringToStringMapEntryImpl entry = (EStringToStringMapEntryImpl)((EcoreFactoryImpl)EcoreFactory.eINSTANCE).createEStringToStringMapEntry();
            entry.setKey(key);
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    eAnnotation.getDetails().add((Object)entry);
                }
            });
        }
    }

    private Object getEntry(EAnnotation eAnnotation, String key) {
        for (Map.Entry entry : eAnnotation.getDetails()) {
            if (!key.equals(entry.getKey())) continue;
            return entry;
        }
        return null;
    }
}

