/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.mappingimport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DescriptionFactory;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.mappingimport.AutoImportException;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.mappingimport.MappingImportData;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.mappingimport.MappingImportKind;

public class MappingImportAgent {
    private Layer layer;
    private List<MappingImportData> mappingImportList;

    public MappingImportAgent(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("Mapping Import Agent Layer can not be null");
        }
        this.layer = layer;
        this.mappingImportList = new ArrayList<MappingImportData>();
    }

    public MappingImportAgent(EObject eObject) {
        this(MappingImportAgent.getCorrespondingLayer(eObject));
    }

    public void registerSpecifiedImport(AbstractNodeMapping original, AbstractNodeMapping imported) {
        MappingImportData data = new MappingImportData(original, imported, MappingImportKind.SPECIFIED);
        this.registerImportData(data);
    }

    public void registerAutoImport(AbstractNodeMapping original) {
        MappingImportData data = new MappingImportData(original, null, MappingImportKind.AUTO);
        this.registerImportData(data);
    }

    public Layer get_Layer() {
        return this.layer;
    }

    public boolean isAgentConcerned(EObject eObject) {
        Layer layer = MappingImportAgent.getCorrespondingLayer(eObject);
        if (layer != null) {
            return layer.equals(this.layer);
        }
        return false;
    }

    public boolean isImportRegistred(MappingImportData data) {
        boolean result = false;
        for (MappingImportData iMappingImportData : this.mappingImportList) {
            if (!iMappingImportData.equals(data) && !iMappingImportData.originalEquals(data)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void patchImports(boolean save) throws AutoImportException {
        for (MappingImportData iMappingImportData : this.mappingImportList) {
            if (iMappingImportData.getParent() != null || !iMappingImportData.getImportKind().equals((Object)MappingImportKind.AUTO)) continue;
            this.patchAutoImport(iMappingImportData);
        }
        for (MappingImportData iMappingImportData : this.mappingImportList) {
            this.patchMappingReuse(iMappingImportData);
        }
    }

    public void clear() {
        this.mappingImportList.clear();
        this.layer = null;
    }

    private void patchAutoImport(MappingImportData data) throws AutoImportException {
        this.createImport(data);
        this.addImportToItParent(data);
        for (MappingImportData iMappingImportData : this.lookForChildrenOf(data)) {
            this.patchAutoImport(iMappingImportData);
        }
    }

    private void addImportToItParent(MappingImportData data) throws AutoImportException {
        MappingImportData parentData = data.getParent();
        AbstractNodeMapping importedMapping = data.getImportedMapping();
        AbstractNodeMapping originalMapping = data.getOriginalMapping();
        if (importedMapping == null) {
            throw new AutoImportException("Import Agent doesn't find a MappingImport");
        }
        if (parentData == null) {
            if (importedMapping instanceof NodeMappingImport) {
                this.layer.getNodeMappings().add((Object)((NodeMappingImport)importedMapping));
            }
            if (importedMapping instanceof ContainerMappingImport) {
                this.layer.getContainerMappings().add((Object)((ContainerMappingImport)importedMapping));
            }
        } else {
            NodeMapping parentNodeImportedMapping;
            ContainerMapping parentContainerImportedMapping;
            AbstractNodeMapping parentImportedMapping = parentData.getImportedMapping();
            if (importedMapping instanceof ContainerMapping) {
                parentContainerImportedMapping = (ContainerMapping)parentImportedMapping;
                parentContainerImportedMapping.getSubContainerMappings().remove((Object)originalMapping);
                parentContainerImportedMapping.getSubContainerMappings().add((Object)((ContainerMapping)importedMapping));
            }
            if (parentImportedMapping instanceof NodeMapping && (parentNodeImportedMapping = (NodeMapping)parentImportedMapping).getBorderedNodeMappings().contains((Object)originalMapping)) {
                parentNodeImportedMapping.getBorderedNodeMappings().remove((Object)originalMapping);
                parentNodeImportedMapping.getBorderedNodeMappings().add((Object)((NodeMapping)importedMapping));
            }
            if (parentImportedMapping instanceof ContainerMapping) {
                parentContainerImportedMapping = (ContainerMapping)parentImportedMapping;
                if (parentContainerImportedMapping.getSubContainerMappings().contains((Object)originalMapping)) {
                    parentContainerImportedMapping.getSubContainerMappings().remove((Object)originalMapping);
                    parentContainerImportedMapping.getSubContainerMappings().add((Object)((ContainerMapping)importedMapping));
                }
                if (parentContainerImportedMapping.getSubNodeMappings().contains((Object)originalMapping)) {
                    parentContainerImportedMapping.getSubNodeMappings().remove((Object)originalMapping);
                    parentContainerImportedMapping.getSubNodeMappings().add((Object)((NodeMapping)importedMapping));
                }
                if (parentContainerImportedMapping.getBorderedNodeMappings().contains((Object)originalMapping)) {
                    parentContainerImportedMapping.getBorderedNodeMappings().remove((Object)originalMapping);
                    parentContainerImportedMapping.getBorderedNodeMappings().add((Object)((NodeMapping)importedMapping));
                }
            }
        }
    }

    private void createImport(MappingImportData data) {
        AbstractNodeMapping originalMapping = data.getOriginalMapping();
        AbstractNodeMapping importedMapping = data.getImportedMapping();
        if (importedMapping == null && originalMapping != null) {
            ContainerMappingImport mappingImport = null;
            if (originalMapping instanceof ContainerMapping) {
                ContainerMappingImport containerMappingImport;
                ContainerMapping containerMappingOriginal = (ContainerMapping)originalMapping;
                mappingImport = containerMappingImport = DescriptionFactory.eINSTANCE.createContainerMappingImport();
                containerMappingImport.setImportedMapping(containerMappingOriginal);
            }
            if (originalMapping instanceof NodeMapping) {
                NodeMapping nodeOriginalMapping = (NodeMapping)originalMapping;
                NodeMappingImport nodeMappingImport = DescriptionFactory.eINSTANCE.createNodeMappingImport();
                mappingImport = nodeMappingImport;
                nodeMappingImport.setImportedMapping(nodeOriginalMapping);
            }
            if (mappingImport != null) {
                mappingImport.setName(String.valueOf(originalMapping.getName()) + "_Import");
                mappingImport.setLabel(originalMapping.getLabel() != null ? String.valueOf(originalMapping.getLabel()) + "_Import" : mappingImport.getName());
                mappingImport.setDomainClass(originalMapping.getDomainClass());
                mappingImport.setPreconditionExpression(originalMapping.getPreconditionExpression());
                mappingImport.setSemanticElements(originalMapping.getSemanticElements());
                MappingImportAgent.reuseTools(originalMapping, (AbstractNodeMapping)mappingImport);
                MappingImportAgent.reuseMappings(originalMapping, (AbstractNodeMapping)mappingImport);
            }
            data.setImportedMapping((AbstractNodeMapping)mappingImport);
            data.setGenerated(true);
        }
    }

    public static void reuseMappings(AbstractNodeMapping originalMapping, AbstractNodeMapping importedMapping) {
        importedMapping.getReusedBorderedNodeMappings().addAll((Collection)MappingHelper.getAllBorderedNodeMappings((AbstractNodeMapping)originalMapping));
        if (importedMapping instanceof ContainerMappingImport) {
            ContainerMapping originalContainerMapping = (ContainerMapping)originalMapping;
            ContainerMappingImport containerImport = (ContainerMappingImport)importedMapping;
            containerImport.getReusedNodeMappings().addAll((Collection)MappingHelper.getAllNodeMappings((ContainerMapping)originalContainerMapping));
            containerImport.getReusedContainerMappings().addAll((Collection)MappingHelper.getAllContainerMappings((ContainerMapping)originalContainerMapping));
        }
    }

    public static void reuseTools(AbstractNodeMapping originalMapping, AbstractNodeMapping importedMapping) {
        if (originalMapping != null && importedMapping != null) {
            if (importedMapping instanceof NodeMappingImport) {
                NodeMappingImport nodeMappingImport = (NodeMappingImport)importedMapping;
                nodeMappingImport.getDropDescriptions().addAll((Collection)((NodeMapping)originalMapping).getDropDescriptions());
            }
            if (importedMapping instanceof ContainerMappingImport) {
                ContainerMappingImport containerMappingImport = (ContainerMappingImport)importedMapping;
                containerMappingImport.getDropDescriptions().addAll((Collection)((ContainerMapping)originalMapping).getDropDescriptions());
            }
            importedMapping.getDetailDescriptions().addAll((Collection)originalMapping.getDetailDescriptions());
            importedMapping.setDeletionDescription(originalMapping.getDeletionDescription());
            importedMapping.getPasteDescriptions().addAll((Collection)originalMapping.getPasteDescriptions());
            importedMapping.setDoubleClickDescription(originalMapping.getDoubleClickDescription());
            importedMapping.setLabelDirectEdit(originalMapping.getLabelDirectEdit());
            importedMapping.getNavigationDescriptions().addAll((Collection)originalMapping.getNavigationDescriptions());
        }
    }

    private List<MappingImportData> lookForChildrenOf(MappingImportData data) {
        ArrayList<MappingImportData> result = new ArrayList<MappingImportData>();
        if (data != null) {
            for (MappingImportData iMappingImportData : this.mappingImportList) {
                if (iMappingImportData.getParent() == null || !iMappingImportData.getParent().equals(data)) continue;
                result.add(iMappingImportData);
            }
        }
        return result;
    }

    private void patchMappingReuse(MappingImportData dataToReuse) {
        for (MappingImportData iMappingImportData : this.mappingImportList) {
            ContainerMapping reusingContainer;
            AbstractNodeMapping reusingNode = iMappingImportData.getImportedMapping();
            AbstractNodeMapping nodeToReuse = dataToReuse.getImportedMapping();
            if (nodeToReuse instanceof NodeMapping) {
                MappingImportAgent.reuseBorderedNode(reusingNode, dataToReuse);
                if (!(reusingNode instanceof ContainerMapping)) continue;
                reusingContainer = (ContainerMapping)reusingNode;
                MappingImportAgent.reuseNode(reusingContainer, dataToReuse);
                continue;
            }
            if (!(nodeToReuse instanceof ContainerMapping) || !(reusingNode instanceof ContainerMapping)) continue;
            reusingContainer = (ContainerMapping)reusingNode;
            MappingImportAgent.reuseContainer(reusingContainer, dataToReuse);
        }
    }

    public static void reuseBorderedNode(AbstractNodeMapping reusing, MappingImportData dataToReuse) {
        boolean reused = false;
        NodeMapping reusedNodeMapping = null;
        for (NodeMapping iBorderedNode : reusing.getReusedBorderedNodeMappings()) {
            if (!iBorderedNode.equals(dataToReuse.getOriginalMapping())) continue;
            reusedNodeMapping = iBorderedNode;
            reused = true;
            break;
        }
        if (reused) {
            reusing.getReusedBorderedNodeMappings().remove(reusedNodeMapping);
            reusing.getReusedBorderedNodeMappings().add((Object)((NodeMapping)dataToReuse.getImportedMapping()));
        }
    }

    public static void reuseNode(ContainerMapping reusing, MappingImportData dataToReuse) {
        boolean reused = false;
        NodeMapping reusedNodeMapping = null;
        for (NodeMapping iNode : reusing.getReusedNodeMappings()) {
            if (!iNode.equals(dataToReuse.getOriginalMapping())) continue;
            reusedNodeMapping = iNode;
            reused = true;
            break;
        }
        if (reused) {
            reusing.getReusedNodeMappings().remove(reusedNodeMapping);
            reusing.getReusedNodeMappings().add((Object)((NodeMapping)dataToReuse.getImportedMapping()));
        }
    }

    public static void reuseContainer(ContainerMapping reusing, MappingImportData dataToReuse) {
        boolean reused = false;
        ContainerMapping reusedContainerMapping = null;
        for (ContainerMapping iContainer : reusing.getReusedContainerMappings()) {
            if (!iContainer.equals(dataToReuse.getOriginalMapping())) continue;
            reusedContainerMapping = iContainer;
            reused = true;
            break;
        }
        if (reused) {
            reusing.getReusedContainerMappings().remove(reusedContainerMapping);
            reusing.getReusedContainerMappings().add((Object)((ContainerMapping)dataToReuse.getImportedMapping()));
        }
    }

    private void registerImportData(MappingImportData data) {
        if (!this.isImportRegistred(data)) {
            this.mappingImportList.add(data);
            this.computeAutoImport(data);
        } else {
            for (MappingImportData iMappingImportData : this.mappingImportList) {
                if (!iMappingImportData.equals(data) && !iMappingImportData.originalEquals(data) || !iMappingImportData.getImportKind().equals((Object)MappingImportKind.AUTO)) continue;
                iMappingImportData.setGenerated(true);
                iMappingImportData.setImportKind(data.getImportKind());
                iMappingImportData.setImportedMapping(data.getImportedMapping());
                iMappingImportData.setParent(data.getParent());
            }
        }
    }

    private void computeAutoImport(MappingImportData currentData) {
        AbstractNodeMapping originalMapping = currentData.getOriginalMapping();
        if (!(originalMapping.eContainer() instanceof Layer)) {
            MappingImportData parrentData = this.createOrGetParentDataOf(currentData);
            if (!this.isImportRegistred(parrentData)) {
                this.registerImportData(parrentData);
            }
            if (currentData.getParent() == null && currentData.getImportKind().equals((Object)MappingImportKind.AUTO)) {
                currentData.setParent(parrentData);
            }
        }
        Layer originalLayer = MappingImportAgent.getCorrespondingLayer((EObject)originalMapping);
        if (originalMapping instanceof NodeMapping) {
            for (ContainerMapping iContainerMapping : originalLayer.getContainerMappings()) {
                if (!iContainerMapping.getReusedBorderedNodeMappings().contains((Object)originalMapping) && !iContainerMapping.getReusedNodeMappings().contains((Object)originalMapping)) continue;
                this.registerImportData(new MappingImportData((AbstractNodeMapping)iContainerMapping));
            }
            for (NodeMapping iNodeMapping : originalLayer.getNodeMappings()) {
                if (!iNodeMapping.getReusedBorderedNodeMappings().contains((Object)originalMapping) || originalMapping.equals(iNodeMapping)) continue;
                this.registerImportData(new MappingImportData((AbstractNodeMapping)iNodeMapping));
            }
        }
        if (originalMapping instanceof ContainerMapping) {
            for (ContainerMapping iContainerMapping : originalLayer.getContainerMappings()) {
                if (!iContainerMapping.getReusedContainerMappings().contains((Object)originalMapping) || originalMapping.equals(iContainerMapping)) continue;
                this.registerImportData(new MappingImportData((AbstractNodeMapping)iContainerMapping));
            }
        }
    }

    private MappingImportData createOrGetParentDataOf(MappingImportData data) {
        if (data.getParent() != null) {
            return data.getParent();
        }
        if (!(data.getOriginalMapping().eContainer() instanceof Layer)) {
            AbstractNodeMapping parentOriginalMapping = (AbstractNodeMapping)data.getOriginalMapping().eContainer();
            MappingImportData parentData = new MappingImportData(parentOriginalMapping);
            return this.lookForMappingInRegisteredMapping(parentData);
        }
        return null;
    }

    private MappingImportData lookForMappingInRegisteredMapping(MappingImportData data) {
        if (data != null) {
            for (MappingImportData iMappingImportData : this.mappingImportList) {
                if (!iMappingImportData.equals(data)) continue;
                return iMappingImportData;
            }
        }
        return data;
    }

    private static Layer getCorrespondingLayer(EObject eObject) {
        if (eObject instanceof Layer) {
            return (Layer)eObject;
        }
        if (eObject instanceof AbstractNodeMapping) {
            AbstractNodeMapping aNodeMapping = (AbstractNodeMapping)eObject;
            EObject parent = aNodeMapping.eContainer();
            while (parent.eContainer() != null && !(parent instanceof Layer)) {
                parent = parent.eContainer();
            }
            if (parent != null && parent instanceof Layer) {
                return (Layer)parent;
            }
        }
        return null;
    }
}

