/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.cadence.core.api;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.internal.CadenceExtensions;

public class CadenceRegistry {
    public static IConfigurationElement[] getAllWorkflowElement(String workflowId) {
        return CadenceExtensions.getAllWorkflowElement(workflowId);
    }

    public static IConfigurationElement[] getWorkflowElementParameters(String workflowId, String workflowElementId) {
        IConfigurationElement config = CadenceExtensions.getWorkflowElement(workflowId, workflowElementId);
        return CadenceExtensions.getWorkflowElementParameters(config);
    }

    public static IConfigurationElement[] getActivitiesConfigList(String workflowId, String workflowElementId) {
        return CadenceExtensions.getActivitiesForWorkflowElement(workflowId, workflowElementId);
    }

    public static IConfigurationElement getActivity(String id) {
        return CadenceExtensions.getActivityConfigElement(id);
    }

    public static boolean isMultiple(IConfigurationElement element) {
        return Boolean.parseBoolean(element.getAttribute("Multiple"));
    }

    public static String getDescription(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren("Description");
        String res = "";
        if (children != null) {
            res = children[0].getValue();
        }
        return res;
    }

    public static String getIdentifier(IConfigurationElement element) {
        return element.getAttribute("Identifier");
    }

    public static String getName(IConfigurationElement element) {
        return element.getAttribute("Name");
    }

    public static String getOrderNumber(IConfigurationElement element) {
        return element.getAttribute("orderNumber");
    }

    public static IActivity getIActivityClass(IConfigurationElement element) {
        IActivity activity = null;
        if (element != null) {
            try {
                activity = (IActivity)element.createExecutableExtension("ActivityClass");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return activity;
    }

    public static IActivity getIActivityClassFromId(String id) {
        IConfigurationElement config = CadenceExtensions.getActivityConfigElement(id);
        return CadenceRegistry.getIActivityClass(config);
    }
}

