/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.FilteredModelScope;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractPatternInstance;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractModifiableTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IRoleSelection;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.ITemplatePatternSelection;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.PatternsUIPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.AbstractTableChoiceDialog;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.ElementInclusionDialog;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.RoleChoiceDialog;
import org.eclipse.emf.diffmerge.patterns.ui.environment.IModelEnvironmentUI;
import org.eclipse.emf.diffmerge.patterns.ui.util.IUIExtender;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.ModelSubsetViewer;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.RoleBindingViewer;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractTemplateElementsPage;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractModifiableTemplateElementsPage<T extends AbstractModifiableTemplatePatternSpecification>
extends AbstractTemplateElementsPage<T> {
    static final String DEFAULT_MESSAGE = Messages.AbstractModifiableTemplateElementsPage_Prompt;
    ISemanticRuleProvider _ruleProvider;

    protected AbstractModifiableTemplateElementsPage(String title_p, T data_p) {
        this(title_p, DEFAULT_MESSAGE, data_p);
    }

    protected AbstractModifiableTemplateElementsPage(String title_p, String message_p, T data_p) {
        super(title_p, message_p, data_p);
        EObject context = null;
        try {
            context = (EObject)data_p.getModelScope().getContents().get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (context != null) {
            this._ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor((Object)context);
        }
    }

    @Override
    protected boolean allowEdition() {
        return true;
    }

    @Override
    public void createControl(Composite parent_p) {
        super.createControl(parent_p);
        this.createSpecificControls();
    }

    protected Composite createSpecificControls() {
        Composite buttonComposite = new Composite((Composite)this.getControl(), 0);
        buttonComposite.setLayoutData((Object)new GridData(16384, 128, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        this.createIncludeAllDependenciesButton(buttonComposite);
        this.createIncludeAllInstancesButton(buttonComposite);
        return buttonComposite;
    }

    protected boolean checkAddChildren(Collection<? extends EObject> elements_p) {
        boolean addChildren = true;
        boolean mustAskUser = false;
        Iterator<? extends EObject> it = elements_p.iterator();
        while (!mustAskUser && it.hasNext()) {
            if (it.next().eContents().isEmpty()) continue;
            mustAskUser = true;
        }
        if (mustAskUser) {
            addChildren = MessageDialog.openQuestion((Shell)this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)Messages.AbstractModifiableTemplateElementsPage_IncludeChildrenPrompt);
        }
        return addChildren;
    }

    private MenuItem createAddToScopeItem(Menu menu_p, ModelSubsetViewer viewer_p) {
        MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.AbstractModifiableTemplateElementsPage_Include);
        result.setEnabled(true);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                Object choices;
                IModelScope modelScope = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getModelScope();
                EObject root = EcoreUtil.getRootContainer((EObject)((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getScopeElement());
                ElementInclusionDialog dialog = new ElementInclusionDialog(AbstractModifiableTemplateElementsPage.this.getShell(), null, root, (Collection<? extends EObject>)modelScope.getContents(), modelScope);
                int answer = dialog.open();
                if (answer == 0 && (choices = dialog.getChoice()) != null) {
                    boolean addChildren = AbstractModifiableTemplateElementsPage.this.checkAddChildren((Collection<EObject>)choices);
                    ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).addElements((Collection)choices, addChildren, false);
                }
            }
        });
        return result;
    }

    protected Button createIncludeAllDependenciesButton(Composite parent_p) {
        final Button result = new Button(parent_p, 8);
        result.setText(Messages.AbstractModifiableTemplateElementsPage_IncludeAllDependencies);
        result.setLayoutData((Object)new GridData(16384, 128, false, false));
        boolean hasDep = ((AbstractModifiableTemplatePatternSpecification)this.getData()).hasDependencies();
        result.setEnabled(hasDep);
        if (hasDep) {
            this.setDependenciesMessage();
        }
        ((AbstractModifiableTemplatePatternSpecification)this.getData()).addSelectedPatternListener(new ITemplatePatternSelection.IPatternChangedListener(){

            public void patternChanged(TemplatePattern newPattern_p) {
                boolean hasDependencies = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).hasDependencies();
                result.setEnabled(hasDependencies);
                if (hasDependencies) {
                    AbstractModifiableTemplateElementsPage.this.setDependenciesMessage();
                } else {
                    AbstractModifiableTemplateElementsPage.this.setMessage(DEFAULT_MESSAGE);
                }
            }
        });
        ((AbstractModifiableTemplatePatternSpecification)this.getData()).addTemplateElementsChangedListener(new AbstractModifiableTemplatePatternSpecification.ITemplateElementsChangedListener(){

            public void templateElementsChanged() {
                boolean hasDependencies = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).hasDependencies();
                result.setEnabled(hasDependencies);
                if (hasDependencies) {
                    AbstractModifiableTemplateElementsPage.this.setDependenciesMessage();
                } else {
                    AbstractModifiableTemplateElementsPage.this.setMessage(DEFAULT_MESSAGE);
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Collection dependencies = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getDependencies();
                AbstractModifiableTemplateElementsPage.this.promptAndAddDependencies(dependencies);
            }
        });
        return result;
    }

    protected Button createIncludeAllInstancesButton(Composite parent_p) {
        final Button result = new Button(parent_p, 8);
        result.setText(Messages.AbstractModifiableTemplateElementsPage_IncludeInstancesLabel);
        result.setLayoutData((Object)new GridData(16384, 128, false, false));
        boolean hasInst = ((AbstractModifiableTemplatePatternSpecification)this.getData()).hasRelatedInstances();
        result.setEnabled(hasInst);
        ((AbstractModifiableTemplatePatternSpecification)this.getData()).addSelectedPatternListener(new ITemplatePatternSelection.IPatternChangedListener(){

            public void patternChanged(TemplatePattern newPattern_p) {
                boolean hasInstances = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).hasRelatedInstances();
                result.setEnabled(hasInstances);
            }
        });
        ((AbstractModifiableTemplatePatternSpecification)this.getData()).addTemplateElementsChangedListener(new AbstractModifiableTemplatePatternSpecification.ITemplateElementsChangedListener(){

            public void templateElementsChanged() {
                boolean hasInstances = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).hasRelatedInstances();
                result.setEnabled(hasInstances);
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Collection instances = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getRelatedInstances();
                AbstractModifiableTemplateElementsPage.this.promptAndAddInstances(instances);
            }
        });
        result.setVisible(false);
        return result;
    }

    private MenuItem createIncludeDependenciesItem(Menu menu_p, final ModelSubsetViewer viewer_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.AbstractModifiableTemplateElementsPage_IncludeDependencies);
        result.setEnabled(false);
        viewer_p.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List selection = ((IStructuredSelection)event.getSelection()).toList();
                result.setEnabled(((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).hasDependencies((Collection)selection));
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selection = viewer_p.getSelection().toList();
                Collection dependencies = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getDependencies((Collection)selection);
                AbstractModifiableTemplateElementsPage.this.promptAndAddDependencies(dependencies);
            }
        });
        return result;
    }

    private MenuItem createIncludeParentItem(Menu menu_p, final ModelSubsetViewer viewer_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.AbstractModifiableTemplateElementsPage_IncludeParent);
        result.setEnabled(false);
        viewer_p.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List selection = ((IStructuredSelection)event.getSelection()).toList();
                selection = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).filterNonModelNonInstanceElements((Collection)selection);
                boolean enable = false;
                for (EObject selected : selection) {
                    EObject parent = selected.eContainer();
                    if (parent == null || ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).isInModelScope(parent)) continue;
                    enable = true;
                    break;
                }
                result.setEnabled(enable);
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object choices;
                List selection = viewer_p.getSelection().toList();
                selection = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).filterNonModelNonInstanceElements((Collection)selection);
                FHashSet parents = new FHashSet();
                for (EObject selected : selection) {
                    EObject parent = selected.eContainer();
                    if (parent == null || ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).isInModelScope(parent)) continue;
                    parents.add(parent);
                }
                IModelScope modelScope = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getModelScope();
                ElementInclusionDialog dialog = new ElementInclusionDialog(AbstractModifiableTemplateElementsPage.this.getShell(), null, (Collection<? extends EObject>)parents, (Collection<? extends EObject>)parents, modelScope);
                int answer = dialog.open();
                if (answer == 0 && (choices = dialog.getChoice()) != null) {
                    boolean addChildren = AbstractModifiableTemplateElementsPage.this.checkAddChildren((Collection<EObject>)choices);
                    ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).addElements((Collection)choices, addChildren, true);
                }
            }
        });
        return result;
    }

    private MenuItem createCreateRoleItem(Menu menu_p, final ModelSubsetViewer viewer_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.AbstractModifiableTemplateElementsPage_CreateRole);
        result.setEnabled(false);
        viewer_p.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List selection = ((IStructuredSelection)event.getSelection()).toList();
                selection = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).filterNonModelNonInstanceElements((Collection)selection);
                result.setEnabled(!selection.isEmpty());
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                List selection = viewer_p.getSelection().toList();
                selection = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).filterNonModelNonInstanceElements((Collection)selection);
                if (!selection.isEmpty()) {
                    String defaultName;
                    if (selection.size() > 1) {
                        EClass type = ModelsUtil.getCommonType((Collection)selection);
                        defaultName = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getRoleNameForType(type);
                    } else {
                        defaultName = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getText((EObject)selection.get(0));
                    }
                    String roleName = AbstractModifiableTemplateElementsPage.this.promptForRoleName(defaultName);
                    if (roleName != null) {
                        ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).addRoleFor(roleName, (Collection)selection);
                        AbstractModifiableTemplateElementsPage.this.validate();
                        viewer_p.refresh();
                    }
                }
            }
        });
        return result;
    }

    @Override
    protected void createMappingControls(Menu menu_p, ModelSubsetViewer viewer_p) {
        this.createMapToCurrentRoleItem(menu_p, viewer_p);
        this.createMapToSomeRoleItem(menu_p, viewer_p);
        this.createCreateRoleItem(menu_p, viewer_p);
        this.createRemoveMappingItem(menu_p, viewer_p);
        new MenuItem(menu_p, 2);
    }

    private MenuItem createMapToSomeRoleItem(Menu menu_p, final ModelSubsetViewer viewer_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.AbstractModifiableTemplateElementsPage_MapToRole);
        result.setEnabled(false);
        viewer_p.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List selection = ((IStructuredSelection)event.getSelection()).toList();
                selection = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).filterNonModelNonInstanceElements((Collection)selection);
                result.setEnabled(!selection.isEmpty());
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                IPatternRole selectedRole;
                RoleChoiceDialog dialog = new RoleChoiceDialog(AbstractModifiableTemplateElementsPage.this.getShell(), null, null, (IPattern)((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getPattern(), AbstractTableChoiceDialog.SelectionKind.SINGLE);
                int answer = dialog.open();
                if (answer == 0 && (selectedRole = (IPatternRole)dialog.getChoice()) instanceof TemplatePatternRole) {
                    List selection = viewer_p.getSelection().toList();
                    selection = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).filterNonModelNonInstanceElements((Collection)selection);
                    for (EObject selectedElement : selection) {
                        ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).mapToRole((TemplatePatternRole)selectedRole, selectedElement);
                    }
                    AbstractModifiableTemplateElementsPage.this.validate();
                    viewer_p.refresh();
                }
            }
        });
        return result;
    }

    private MenuItem createMapToCurrentRoleItem(Menu menu_p, final ModelSubsetViewer viewer_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.AbstractModifiableTemplateElementsPage_MapToCurrentRole);
        result.setEnabled(false);
        ((AbstractModifiableTemplatePatternSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

            public void roleChanged(TemplatePatternRole newRole_p) {
                boolean enable;
                boolean bl = enable = newRole_p != null;
                if (enable) {
                    List selection = viewer_p.getSelection().toList();
                    selection = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).filterNonModelNonInstanceElements((Collection)selection);
                    enable = !selection.isEmpty();
                }
                result.setEnabled(enable);
            }
        });
        viewer_p.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enable;
                boolean bl = enable = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getRole() != null;
                if (enable) {
                    List selection = viewer_p.getSelection().toList();
                    selection = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).filterNonModelNonInstanceElements((Collection)selection);
                    enable = !selection.isEmpty();
                }
                result.setEnabled(enable);
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplatePatternRole currentRole = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getRole();
                for (Object selected : viewer_p.getSelection().toList()) {
                    if (!(selected instanceof EObject)) continue;
                    EObject selectedElement = (EObject)selected;
                    if (!((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).isInModelScope(selectedElement)) continue;
                    ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).mapToRole(currentRole, selectedElement);
                }
                AbstractModifiableTemplateElementsPage.this.validate();
                viewer_p.refresh();
            }
        });
        return result;
    }

    @Override
    protected ModelSubsetViewer createModelViewer(Composite parent_p) {
        final RoleBindingViewer resultViewer = new RoleBindingViewer(parent_p, true, false){

            @Override
            protected String getText(EObject element_p, String defaultText_p) {
                String result = defaultText_p;
                if (AbstractModifiableTemplateElementsPage.this._ruleProvider != null) {
                    String prefix = AbstractModifiableTemplateElementsPage.this._ruleProvider.getPrefixText(element_p);
                    if (!"".equals(prefix)) {
                        prefix = "(" + prefix + ")_";
                    }
                    result = String.valueOf(prefix) + result;
                } else {
                    result = "?_" + result;
                }
                if (((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).hasDependencies(element_p)) {
                    result = UIUtil.markAsDependentElement(result);
                }
                result = super.getText(element_p, result);
                return result;
            }

            @Override
            protected int getControlWidgetConfiguration() {
                int result = ModelSubsetViewer.SORT | ModelSubsetViewer.EXPAND | ModelSubsetViewer.COLLAPSE;
                if (AbstractModifiableTemplateElementsPage.this.showParentsCheckbox()) {
                    result |= ModelSubsetViewer.SHOW_PARENTS;
                }
                return result;
            }
        };
        ((ModelSubsetViewer)resultViewer).setInput(this.getData());
        ((AbstractModifiableTemplatePatternSpecification)this.getData()).addTemplateElementsChangedListener(new AbstractModifiableTemplatePatternSpecification.ITemplateElementsChangedListener(){

            public void templateElementsChanged() {
                resultViewer.setInput(AbstractModifiableTemplateElementsPage.this.getData());
                AbstractModifiableTemplateElementsPage.this.validate();
            }
        });
        return resultViewer;
    }

    @Override
    protected void createNavigationControls(Menu menu_p, ModelSubsetViewer viewer_p) {
        boolean created;
        IUIExtender uiExtender = PatternsUIPlugin.getDefault().getSemanticUIUtil();
        if (uiExtender != null && (created = uiExtender.createNavigationItems(menu_p, viewer_p))) {
            new MenuItem(menu_p, 2);
        }
    }

    private MenuItem createRemoveFromScopeItem(Menu menu_p, final ModelSubsetViewer viewer_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.AbstractModifiableTemplateElementsPage_Exclude);
        result.setEnabled(false);
        viewer_p.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List selection = ((IStructuredSelection)event.getSelection()).toList();
                selection = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).filterNonModelElements((Collection)selection);
                result.setEnabled(!selection.isEmpty());
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                FOrderedSet selectedElements = new FOrderedSet();
                Iterator it = viewer_p.getSelection().iterator();
                boolean childrenInvolved = false;
                while (it.hasNext()) {
                    Object selected = it.next();
                    if (!(selected instanceof EObject)) continue;
                    EObject selectedElement = (EObject)selected;
                    if (!((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).isInModelScope(selectedElement)) continue;
                    selectedElements.add(selectedElement);
                    if (selectedElement.eContents().isEmpty() || ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).isInstanceRelated(selectedElement)) continue;
                    childrenInvolved = true;
                }
                if (!selectedElements.isEmpty() && ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getModelScope() instanceof FilteredModelScope) {
                    boolean proceed = true;
                    boolean removeChildren = true;
                    if (childrenInvolved) {
                        MessageDialog dialog = new MessageDialog(AbstractModifiableTemplateElementsPage.this.getShell(), CorePatternsPlugin.getDefault().getLabel(), null, Messages.AbstractModifiableTemplateElementsPage_ExcludeChildrenPrompt, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                        int answer = dialog.open();
                        proceed = answer != 2;
                        removeChildren = answer == 0;
                    } else {
                        String message;
                        if (selectedElements.size() == 1) {
                            IModelEnvironmentUI me = PatternsUIPlugin.getDefault().getModelEnvironmentUI();
                            message = String.format(Messages.AbstractModifiableTemplateElementsPage_ConfirmExcludeOne, me.getText(selectedElements.iterator().next()));
                        } else {
                            message = String.format(Messages.AbstractModifiableTemplateElementsPage_ConfirmExcludeMany, selectedElements.size());
                        }
                        proceed = MessageDialog.openConfirm((Shell)AbstractModifiableTemplateElementsPage.this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)message);
                    }
                    if (proceed) {
                        ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).removeElements((Collection)selectedElements, removeChildren);
                    }
                }
            }
        });
        return result;
    }

    private MenuItem createRemoveMappingItem(Menu menu_p, final ModelSubsetViewer viewer_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.AbstractModifiableTemplateElementsPage_RemoveMapping);
        result.setEnabled(false);
        viewer_p.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                boolean enable = false;
                List selection = viewer_p.getSelection().toList();
                selection = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).filterNonModelElements((Collection)selection);
                for (EObject selectedElement : selection) {
                    List roles = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).getRolesOf(selectedElement);
                    if (roles.isEmpty()) continue;
                    enable = true;
                    break;
                }
                result.setEnabled(enable);
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                List selection = viewer_p.getSelection().toList();
                selection = ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).filterNonModelElements((Collection)selection);
                for (EObject selectedElement : selection) {
                    ((AbstractModifiableTemplatePatternSpecification)AbstractModifiableTemplateElementsPage.this.getData()).removeFromRole(selectedElement);
                }
                AbstractModifiableTemplateElementsPage.this.validate();
                viewer_p.refresh();
            }
        });
        return result;
    }

    @Override
    protected void createScopeModificationControls(Menu menu_p, ModelSubsetViewer viewer_p) {
        new MenuItem(menu_p, 2);
        this.createRemoveFromScopeItem(menu_p, viewer_p);
        this.createAddToScopeItem(menu_p, viewer_p);
        this.createIncludeDependenciesItem(menu_p, viewer_p);
        this.createIncludeParentItem(menu_p, viewer_p);
    }

    protected void promptAndAddDependencies(Collection<? extends EObject> dependencies_p) {
        if (!dependencies_p.isEmpty()) {
            Object choices;
            IModelScope modelScope = ((AbstractModifiableTemplatePatternSpecification)this.getData()).getModelScope();
            ElementInclusionDialog dialog = new ElementInclusionDialog(this.getShell(), Messages.AbstractModifiableTemplateElementsPage_SelectDependencies, dependencies_p, dependencies_p, modelScope);
            int answer = dialog.open();
            if (answer == 0 && (choices = dialog.getChoice()) != null) {
                boolean addChildren = this.checkAddChildren((Collection<EObject>)choices);
                ((AbstractModifiableTemplatePatternSpecification)this.getData()).addElements((Collection)choices, addChildren, true);
            }
        }
    }

    protected void promptAndAddInstances(Collection<? extends AbstractPatternInstance> instances_p) {
        if (!instances_p.isEmpty()) {
            Object choices;
            IModelScope modelScope = ((AbstractModifiableTemplatePatternSpecification)this.getData()).getModelScope();
            ElementInclusionDialog dialog = new ElementInclusionDialog(this.getShell(), Messages.AbstractModifiableTemplateElementsPage_IncludeInstancesPrompt, instances_p, instances_p, modelScope);
            int answer = dialog.open();
            if (answer == 0 && (choices = dialog.getChoice()) != null) {
                ((AbstractModifiableTemplatePatternSpecification)this.getData()).addElements((Collection)choices, true, false);
            }
        }
    }

    protected void setDependenciesMessage() {
        this.setMessage(Messages.AbstractModifiableTemplateElementsPage_WarnDependencies, 2);
    }
}

