/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.PatternsUIPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.environment.IModelEnvironmentUI;
import org.eclipse.emf.diffmerge.patterns.ui.providers.CollectionAsTreeContentProvider;
import org.eclipse.emf.diffmerge.patterns.ui.providers.DiscriminatingLabelProvider;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ModelSubsetViewer
extends Viewer {
    public static int NONE = 0;
    public static int NAME_FILTER = 1;
    public static int SHOW_PARENTS = 2;
    public static int SORT = 4;
    public static int EXPAND = 8;
    public static int COLLAPSE = 16;
    protected final Shell _shell;
    protected Collection<EObject> _vdata;
    protected boolean _showParents;
    private IModelEnvironmentUI.SortingMethod _sortingMethod;
    protected ITreeSelection _selection;
    protected Button _showParentsButton;
    private Composite _composite;
    protected boolean _isMultipleSelection;
    protected TreeViewer _treeViewer;
    private ITreeContentProvider _dataProvider;

    public ModelSubsetViewer(Composite parent_p, boolean multipleSelection_p, boolean showParents_p) {
        this._isMultipleSelection = multipleSelection_p;
        this.initialize(parent_p);
        this._shell = parent_p.getShell();
        this._selection = null;
        this._showParents = showParents_p;
        ModelSubsetLabelProvider labelProvider = new ModelSubsetLabelProvider(this.getInternalLabelProvider());
        this._dataProvider = new CollectionAsTreeContentProvider();
        this._treeViewer.setContentProvider((IContentProvider)this._dataProvider);
        this._treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this._sortingMethod = null;
        ViewerComparator sorter = this.getSorter();
        if (sorter != null) {
            this._treeViewer.setComparator(sorter);
        } else {
            this.setSortingMethod(IModelEnvironmentUI.SortingMethod.BY_TYPE_AND_NAME);
        }
        if (this._showParentsButton != null) {
            this._showParentsButton.setSelection(showParents_p);
        }
    }

    public void addFilter(ViewerFilter filter_p) {
        TreeViewer clientViewer = this._treeViewer;
        if (clientViewer instanceof StructuredViewer) {
            ((StructuredViewer)clientViewer).addFilter(filter_p);
        }
    }

    protected void initialize(Composite parent_p) {
        this._composite = new Composite(parent_p, 0);
        this.createControl(this._composite);
    }

    protected void createControl(Composite parent_p) {
        GridLayout layout = new GridLayout(1, true);
        parent_p.setLayout((Layout)layout);
        this._treeViewer = this.createTreeViewer(parent_p);
        if (this._treeViewer != null) {
            GridData gdData = new GridData();
            gdData.verticalAlignment = 4;
            gdData.horizontalAlignment = 4;
            gdData.grabExcessHorizontalSpace = true;
            gdData.grabExcessVerticalSpace = true;
            this._treeViewer.getControl().setLayoutData((Object)gdData);
        }
    }

    public void addSelectionListener(ISelectionChangedListener listener_p) {
        this._treeViewer.addSelectionChangedListener(listener_p);
    }

    protected void createControlWidgets(Composite parent_p) {
        boolean none;
        int configuration = this.getControlWidgetConfiguration();
        boolean bl = none = (configuration & SORT) != SORT && (configuration & EXPAND) != EXPAND && (configuration & COLLAPSE) != COLLAPSE && (configuration & SHOW_PARENTS) != SHOW_PARENTS;
        if (none) {
            return;
        }
        Composite composite = new Composite(parent_p, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout compositeLayout = new GridLayout(4, false);
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        if ((configuration & SORT) == SORT) {
            final Button sortButton = new Button(composite, 8);
            sortButton.setImage(PatternsUIPlugin.getDefault().getImage(PatternsUIPlugin.ImageID.SORT));
            sortButton.setToolTipText(Messages.ModelSubsetViewer_TooltipSort);
            sortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private Menu _dropMenu = null;

                public void widgetSelected(SelectionEvent e_p) {
                    if (this._dropMenu == null) {
                        this._dropMenu = new Menu((Decorations)ModelSubsetViewer.this._shell, 8);
                        ModelSubsetViewer.this._shell.setMenu(this._dropMenu);
                        final MenuItem nameSortingItem = new MenuItem(this._dropMenu, 16);
                        nameSortingItem.setText(Messages.ModelSubsetViewer_SortByName);
                        nameSortingItem.setSelection(ModelSubsetViewer.this.getSortingMethod() == IModelEnvironmentUI.SortingMethod.BY_NAME);
                        nameSortingItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if (nameSortingItem.getSelection()) {
                                    ModelSubsetViewer.this.setSortingMethod(IModelEnvironmentUI.SortingMethod.BY_NAME);
                                }
                            }
                        });
                        final MenuItem nameTypeSortingItem = new MenuItem(this._dropMenu, 16);
                        nameTypeSortingItem.setText(Messages.ModelSubsetViewer_SortByNameAndType);
                        nameTypeSortingItem.setSelection(ModelSubsetViewer.this.getSortingMethod() == IModelEnvironmentUI.SortingMethod.BY_TYPE_AND_NAME);
                        nameTypeSortingItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if (nameTypeSortingItem.getSelection()) {
                                    ModelSubsetViewer.this.setSortingMethod(IModelEnvironmentUI.SortingMethod.BY_TYPE_AND_NAME);
                                }
                            }
                        });
                    }
                    Composite parent = sortButton.getParent();
                    Rectangle bounds = sortButton.getBounds();
                    Point point = parent.toDisplay(new Point(bounds.x + bounds.width - 1, bounds.y));
                    this._dropMenu.setLocation(point.x, point.y);
                    this._dropMenu.setVisible(true);
                }
            });
        }
        if ((configuration & EXPAND) == EXPAND) {
            Button expandButton = new Button(composite, 8);
            expandButton.setImage(PatternsUIPlugin.getDefault().getImage(PatternsUIPlugin.ImageID.EXPANDALL));
            expandButton.setToolTipText(Messages.ModelSubsetViewer_TooltipExpand);
            expandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event_p) {
                    BusyIndicator.showWhile((Display)ModelSubsetViewer.this._shell.getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).ModelSubsetViewer.this._treeViewer.expandAll();
                        }
                    });
                }
            });
        }
        if ((configuration & COLLAPSE) == COLLAPSE) {
            Button collapseButton = new Button(composite, 8);
            collapseButton.setImage(PatternsUIPlugin.getDefault().getImage(PatternsUIPlugin.ImageID.COLLAPSEALL));
            collapseButton.setToolTipText(Messages.ModelSubsetViewer_TooltipCollapse);
            collapseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event_p) {
                    BusyIndicator.showWhile((Display)ModelSubsetViewer.this._shell.getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).ModelSubsetViewer.this._treeViewer.collapseAll();
                        }
                    });
                }
            });
        }
        if ((configuration & SHOW_PARENTS) == SHOW_PARENTS) {
            this._showParentsButton = new Button(composite, 32);
            this._showParentsButton.setText(Messages.ModelSubsetViewer_ShowParents);
            this._showParentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected;
                    ModelSubsetViewer.this._showParents = selected = ModelSubsetViewer.this._showParentsButton.getSelection();
                    ModelSubsetViewer.this.setInput(ModelSubsetViewer.this._vdata);
                }
            });
        }
    }

    protected TreeViewer createTreeViewer(Composite parent_p) {
        TreeViewer result;
        this.createControlWidgets(parent_p);
        if ((this.getControlWidgetConfiguration() & NAME_FILTER) == NAME_FILTER) {
            parent_p.setLayoutData((Object)new GridData(1808));
            result = new TreeViewer(parent_p, this.getTreeStyle());
            result.setAutoExpandLevel(-1);
        } else {
            result = new TreeViewer(parent_p, this.getTreeStyle());
            Layout parentLayout = parent_p.getLayout();
            if (parentLayout instanceof GridLayout) {
                GridLayout gridLayout = (GridLayout)parentLayout;
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
            }
            parent_p.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelSubsetViewer.this._selection = (ITreeSelection)event.getSelection();
            }
        });
        return result;
    }

    protected Collection<Object> getAllParents(EObject obj_p) {
        FHashSet res = new FHashSet();
        Object parent = this.getParent(obj_p);
        if (parent != null && parent instanceof EObject && !(parent instanceof Resource)) {
            res.add(parent);
            res.addAll(this.getAllParents((EObject)parent));
        }
        return res;
    }

    protected Color getBackgroundColor(EObject element_p, Color defaultColor_p) {
        return null;
    }

    public EObject getChoice() {
        EObject result = null;
        List<EObject> choices = this.getChoices();
        if (!choices.isEmpty()) {
            result = choices.get(0);
        }
        return result;
    }

    public List<EObject> getChoices() {
        ArrayList<EObject> result = new ArrayList<EObject>();
        IStructuredSelection selection = this.getSelection();
        if (selection != null) {
            for (EObject selected : selection) {
                result.add(selected);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public Composite getControl() {
        return this._composite;
    }

    protected int getControlWidgetConfiguration() {
        return SHOW_PARENTS | SORT | EXPAND | COLLAPSE;
    }

    protected int getExpandDepth() {
        return this._showParents ? ModelsUtil.getDepth((Iterable)ModelsUtil.getRoots(this._vdata), (boolean)false) : 0;
    }

    protected Font getFont(EObject element_p, Font defaultFont_p) {
        return null;
    }

    protected Color getForegroundColor(EObject element_p, Color defaultColor_p) {
        Collection<EObject> roots = this._vdata;
        if (!EcoreUtil.isAncestor(roots, (EObject)element_p)) {
            return UIUtil.getColor(15);
        }
        return null;
    }

    public Object getInput() {
        return this._treeViewer == null ? null : this._treeViewer.getInput();
    }

    protected ILabelProvider getInternalLabelProvider() {
        return new DiscriminatingLabelProvider(){

            @Override
            public String getText(Object element_p) {
                String result = null;
                if (element_p instanceof EObject) {
                    result = PatternsUIPlugin.getDefault().getModelEnvironmentUI().getText(element_p);
                }
                if (result == null) {
                    result = super.getText(element_p);
                }
                return result;
            }
        };
    }

    protected IEditingDomainItemProvider getItemProvider(EObject element_p) {
        IEditingDomainItemProvider result = null;
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)element_p);
        if (editingDomain != null) {
            result = (IEditingDomainItemProvider)editingDomain.getAdapterFactory().adapt((Notifier)element_p, IEditingDomainItemProvider.class);
        }
        return result;
    }

    protected Object getParent(Object element_p) {
        Object parent = null;
        if (!(element_p instanceof EObject)) {
            return parent;
        }
        EObject element = (EObject)element_p;
        IEditingDomainItemProvider provider = this.getItemProvider(element);
        parent = provider != null ? provider.getParent((Object)element) : element.eContainer();
        return parent;
    }

    public IStructuredSelection getSelection() {
        return this._selection != null ? this._selection : new StructuredSelection();
    }

    protected IModelEnvironmentUI.SortingMethod getSortingMethod() {
        return this._sortingMethod;
    }

    protected ViewerComparator getSorter() {
        return null;
    }

    protected String getText(EObject element_p, String defaultText_p) {
        return defaultText_p;
    }

    public TreeViewer getTreeViewer() {
        return this._treeViewer;
    }

    protected int getTreeStyle() {
        return (this._isMultipleSelection ? 2 : 4) | 0x800 | 0x10000 | 0x200;
    }

    public boolean isValid(EObject element_p) {
        return this._vdata.contains(element_p);
    }

    public void refresh() {
        this._treeViewer.refresh();
    }

    public void select(Object ... elements_p) {
        this._treeViewer.setSelection((ISelection)new StructuredSelection(elements_p), true);
    }

    public boolean selectFirst() {
        boolean result = false;
        if (!this._vdata.isEmpty()) {
            Object firstValid = this._vdata.toArray()[0];
            this.select(firstValid);
        }
        return result;
    }

    public void setEnabled(boolean enabled_p) {
        if (this._treeViewer != null && !this._treeViewer.getControl().isDisposed()) {
            this._treeViewer.getControl().setEnabled(enabled_p);
        }
    }

    public void setInput(Object input_p) {
        if (this._showParents) {
            this.setInputWithParents(input_p);
        } else {
            this.setFlatInput(input_p);
        }
    }

    protected void setFlatInput(Object input_p) {
        if (input_p instanceof Collection) {
            HashSet<EObject> elements = new HashSet<EObject>();
            for (Object obj : (Collection)input_p) {
                if (!(obj instanceof EObject)) continue;
                elements.add((EObject)obj);
            }
            this._vdata = elements;
            this._treeViewer.setAutoExpandLevel(this.getExpandDepth());
            this._treeViewer.setInput(this._vdata);
        } else if (this._treeViewer != null) {
            this._treeViewer.setInput(input_p);
        }
    }

    protected void setInputWithParents(Object input_p) {
        if (input_p instanceof Collection) {
            HashSet<EObject> elements = new HashSet<EObject>();
            HashSet<EObject> elementsAndParents = new HashSet<EObject>();
            for (Object obj : (Collection)input_p) {
                if (!(obj instanceof EObject)) continue;
                EObject current = (EObject)obj;
                Collection<Object> parents = this.getAllParents(current);
                for (Object p : parents) {
                    if (!(p instanceof EObject)) continue;
                    elementsAndParents.add((EObject)p);
                }
                elementsAndParents.add((EObject)obj);
                elements.add((EObject)obj);
            }
            this._vdata = elements;
            this._treeViewer.setAutoExpandLevel(this.getExpandDepth());
            this._treeViewer.setInput(elementsAndParents);
        } else if (this._treeViewer != null) {
            this._treeViewer.setInput(input_p);
        }
    }

    public void setSelection(ISelection selection_p, boolean reveal_p) {
    }

    protected void setSortingMethod(IModelEnvironmentUI.SortingMethod newMethod_p) {
        IModelEnvironmentUI me;
        if (this._sortingMethod != newMethod_p && (me = PatternsUIPlugin.getDefault().getModelEnvironmentUI()) != null) {
            this._sortingMethod = newMethod_p;
            ViewerComparator sorter = me.getSorter(newMethod_p);
            this._treeViewer.setComparator(sorter);
        }
    }

    private class ModelSubsetLabelProvider
    implements ILabelProvider,
    IFontProvider,
    IColorProvider {
        private final ILabelProvider _innerLabelProvider;

        public ModelSubsetLabelProvider(ILabelProvider innerLabelProvider_p) {
            this._innerLabelProvider = innerLabelProvider_p;
        }

        public void addListener(ILabelProviderListener listener_p) {
            this._innerLabelProvider.addListener(listener_p);
        }

        public void dispose() {
            this._innerLabelProvider.dispose();
        }

        public Image getImage(Object element_p) {
            return this._innerLabelProvider.getImage(element_p);
        }

        public String getText(Object element_p) {
            String result = null;
            String defaultText = this._innerLabelProvider.getText(element_p);
            if (element_p instanceof EObject) {
                result = ModelSubsetViewer.this.getText((EObject)element_p, defaultText);
            }
            if (result == null) {
                result = defaultText;
            }
            return result;
        }

        public boolean isLabelProperty(Object element_p, String property_p) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener_p) {
            this._innerLabelProvider.removeListener(listener_p);
        }

        public Font getFont(Object element_p) {
            Font result = null;
            Font defaultFont = ModelSubsetViewer.this._treeViewer.getTree().getFont();
            if (element_p instanceof EObject) {
                result = ModelSubsetViewer.this.getFont((EObject)element_p, defaultFont);
            }
            if (result == null) {
                result = defaultFont;
            }
            return result;
        }

        public Color getBackground(Object element_p) {
            Color result = null;
            Color defaultColor = ModelSubsetViewer.this._treeViewer.getTree().getBackground();
            if (element_p instanceof EObject) {
                result = ModelSubsetViewer.this.getBackgroundColor((EObject)element_p, defaultColor);
            }
            if (result == null) {
                result = defaultColor;
            }
            return result;
        }

        public Color getForeground(Object element_p) {
            Color result = null;
            Color defaultColor = ModelSubsetViewer.this._treeViewer.getTree().getForeground();
            if (element_p instanceof EObject) {
                result = ModelSubsetViewer.this.getForegroundColor((EObject)element_p, defaultColor);
            }
            if (result == null) {
                result = defaultColor;
            }
            return result;
        }
    }
}

